/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.rcp.license.internal.core;

import com.nxp.s32ds.ext.rcp.license.cll.CLL;
import com.nxp.s32ds.ext.rcp.license.cll.CLLActivationType;
import com.nxp.s32ds.ext.rcp.license.cll.CLLFeatureDetail;
import com.nxp.s32ds.ext.rcp.license.cll.CLLReason;
import com.nxp.s32ds.ext.rcp.license.cll.ICLL;
import com.nxp.s32ds.rcp.license.core.FNOId;
import com.nxp.s32ds.rcp.license.core.LicenseCoreActivator;
import com.nxp.s32ds.rcp.license.core.LicenseException;
import com.nxp.s32ds.rcp.license.core.LicenseFeature;
import com.nxp.s32ds.rcp.license.core.LicenseStatus;
import com.nxp.s32ds.rcp.license.internal.core.LicenseBackend;
import java.util.Map;
import java.util.Set;

public class CLLBackend
implements LicenseBackend {
    private static final String PARAM_MODEL_HTTP_PROXY_PASSWORD = "http.proxyPassword";
    private static final String PARAM_MODEL_HTTP_PROXY_USER = "http.proxyUser";
    private static final String PARAM_MODEL_HTTP_PROXY_PORT = "http.proxyPort";
    private static final String PARAM_MODEL_HTTP_PROXY_HOST = "http.proxyHost";
    private static final String PARAM_MODEL_HTTP_PROXY_SET = "http.proxySet";
    private static final String PARAM_MODEL_TEST_MODE = "license.cll.test";
    private ICLL cll;
    private boolean testFNO = false;
    private Throwable problem;

    public CLLBackend() {
        try {
            this.cll = CLL.loadCLL();
        }
        catch (Throwable e) {
            this.problem = e;
            LicenseCoreActivator.log(4, e.getMessage());
        }
    }

    public CLLBackend(ICLL cll) {
        this.cll = cll;
    }

    @Override
    @Deprecated
    public LicenseStatus createStatus(FNOId licenseFeatureId) {
        return new LicenseStatus(this.getBestFor(licenseFeatureId));
    }

    private CLLFeatureDetail getBestFor(FNOId fid) {
        CLLFeatureDetail f = this.cll.listFeatures(fid.getProductName(), fid.getFeatureId(), fid.getVersion(), new CLLReason());
        if (f != null && f.getNext() != null) {
            if ("FOREVER".equals(f.getDaysToExpire())) {
                return f;
            }
            long maxDays = Long.parseLong(f.getDaysToExpire());
            CLLFeatureDetail best = f;
            CLLFeatureDetail cur = f;
            while (cur.getNext() != null) {
                if ("FOREVER".equals((cur = cur.getNext()).getDaysToExpire())) {
                    return cur;
                }
                long curDays = Long.parseLong(cur.getDaysToExpire());
                if (maxDays >= curDays) continue;
                maxDays = curDays;
                best = cur;
            }
            return best;
        }
        return f;
    }

    @Override
    public void activate(String id, Map<String, String> params) throws LicenseException {
        if (params.containsKey("offlineRequest")) {
            CLLBackend.checked(this.cll.activateLicense(id, CLLActivationType.CLL_ACTIVATION_TYPE_OFFLINE_FNO, params.get("offlineRequest"), 0L, 0L));
        } else if (params.containsKey("offlineResponse")) {
            CLLBackend.checked(this.cll.processOfflineResponse(params.get("offlineResponse")));
        } else {
            CLLBackend.checked(this.cll.activateLicense(id, CLLActivationType.CLL_ACTIVATION_TYPE_FNO, "", 0L, 0L));
        }
    }

    @Override
    public void init(Map<String, String> params, Set<String> products) throws LicenseException {
        if (params.containsKey(PARAM_MODEL_TEST_MODE) && "true".equalsIgnoreCase(params.get(PARAM_MODEL_TEST_MODE))) {
            this.cll.setFNOUrlForTesting(true);
            this.testFNO = true;
        }
        if (params.containsKey(PARAM_MODEL_HTTP_PROXY_SET)) {
            String proxyHost = CLLBackend.getOrEmpty(params, PARAM_MODEL_HTTP_PROXY_HOST);
            int proxyPort = Integer.parseInt(CLLBackend.getOrEmpty(params, PARAM_MODEL_HTTP_PROXY_PORT));
            String proxyUser = CLLBackend.getOrEmpty(params, PARAM_MODEL_HTTP_PROXY_USER);
            String proxyPassword = CLLBackend.getOrEmpty(params, PARAM_MODEL_HTTP_PROXY_PASSWORD);
            this.cll.configureProxy(proxyHost, proxyPort, proxyUser, proxyPassword);
        }
    }

    private static String getOrEmpty(Map<String, String> map, String key) {
        if (map.containsKey(key)) {
            return map.get(key);
        }
        return "";
    }

    @Override
    @Deprecated
    public String getActivationId(FNOId licenseFeatureId) {
        CLLFeatureDetail f = this.getBestFor(licenseFeatureId);
        if (f != null) {
            return f.getActivationID();
        }
        return "";
    }

    @Override
    public void refreshFeature(String activationId) {
        CLLReason result = this.cll.refreshLicense(activationId, false, "", 0L, 0L);
        if (result != null && result.isError()) {
            throw new RuntimeException(result.toString());
        }
    }

    @Override
    public boolean isTestMode() {
        return this.testFNO;
    }

    @Override
    public void returnLicense(String id, Map<String, String> params) throws LicenseException {
        if (params.containsKey("offlineRequest")) {
            CLLBackend.checked(this.cll.returnLicense(id, true, params.get("offlineRequest")));
        } else if (params.containsKey("offlineResponse")) {
            CLLBackend.checked(this.cll.processOfflineResponse(params.get("offlineResponse")));
        } else {
            CLLBackend.checked(this.cll.returnLicense(id, false, ""));
        }
    }

    @Override
    public LicenseFeature createFeature(FNOId id) {
        try {
            CLLFeatureDetail fd = this.getBestFor(id);
            String activationId = fd != null ? fd.getActivationID() : "";
            boolean testMode = this.isTestMode();
            LicenseStatus status = new LicenseStatus(fd);
            return new LicenseFeature(id, status, activationId, testMode);
        }
        catch (Throwable e) {
            LicenseCoreActivator.log(4, e.getMessage());
            return new LicenseFeature(id, LicenseStatus.error(e));
        }
    }

    @Override
    public boolean isLicenseAvailableByFeature(String featureName, String version) {
        CLLReason reason = this.cll.verifyLicenseAvailabilityByFeature(featureName, version);
        if (reason == null) {
            return false;
        }
        return reason.getErrorNo() == 0;
    }

    private static void checked(CLLReason reason) throws LicenseException {
        if (reason != null) {
            throw new LicenseException(reason.toString());
        }
    }

    @Override
    public Throwable getProblem() {
        return this.problem;
    }
}

