/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.debug.ide.s32debugger.flash.validation;

import com.nxp.s32ds.debug.ide.core.DebuggerUtils;
import com.nxp.s32ds.debug.ide.s32debugger.flash.internal.validation.S32DebuggerFlashProgrammerErrorMessages;
import com.nxp.s32ds.debug.ide.s32debugger.flash.internal.validation.S32DebuggerFlashProgrammerValidationActivator;
import com.nxp.s32ds.debug.ide.s32debugger.flash.validation.S32DebuggerFlashProgrammerParams;
import com.nxp.s32ds.debug.ide.s32debugger.validation.S32DebuggerAttributesValidator;
import com.nxp.s32ds.debug.ide.s32debugger.validation.S32DebuggerParams;
import com.nxp.s32ds.debug.ide.validation.ErrorMessages;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.NLS;

public class S32DebuggerFlashProgrammerAttributesValidator {
    private S32DebuggerAttributesValidator s32DebuggerAttributesValidator = new S32DebuggerAttributesValidator();

    public String getVirtualIP() {
        return this.s32DebuggerAttributesValidator.getDebuggerConnectionString();
    }

    public List<IStatus> validateDebuggerParameters(S32DebuggerFlashProgrammerParams flashProgrammerParams, boolean checkForLaunch) {
        String flashType = flashProgrammerParams.getFlashType();
        String flashName = flashProgrammerParams.getFlashName();
        if (flashName.isEmpty() || flashType.isEmpty()) {
            ArrayList<IStatus> error = new ArrayList<IStatus>(1);
            error.add((IStatus)new Status(4, S32DebuggerFlashProgrammerValidationActivator.getInstance().getBundleId(), S32DebuggerFlashProgrammerErrorMessages.S32DebuggerFlashProgrammerAttributesValidator_select_device));
            return error;
        }
        S32DebuggerParams s32DebuggerParams = flashProgrammerParams.getS32DebuggerParams();
        s32DebuggerParams.setDeviceCoreId(null);
        return this.s32DebuggerAttributesValidator.validateDebuggerParameters(s32DebuggerParams, checkForLaunch);
    }

    public IStatus validateProjectParameters(S32DebuggerFlashProgrammerParams flashProgrammerParams) {
        Map<String, String> idToBinaryMap = flashProgrammerParams.getIdToBinaryMap();
        Map<String, String> binaryIdIsEnabledMap = flashProgrammerParams.getBinaryIdIsEnabledMap();
        Map<String, String> binaryIdToProjectNameMap = flashProgrammerParams.getBinaryIdToProjectNameMap();
        boolean allDisabled = true;
        for (String binaryId : idToBinaryMap.keySet()) {
            ICProject project;
            if (!"enabled".equals(binaryIdIsEnabledMap.get(binaryId))) continue;
            String projectName = binaryIdToProjectNameMap.get(binaryId);
            if (!("<undefined>".equals(projectName) || (project = CoreModel.getDefault().getCModel().getCProject(projectName)) != null && project.exists())) {
                return new Status(4, S32DebuggerFlashProgrammerValidationActivator.getInstance().getBundleId(), NLS.bind((String)S32DebuggerFlashProgrammerErrorMessages.S32DebuggerFlashProgrammerAttributesValidator_project_not_exist, (Object)projectName));
            }
            String binaryPath = idToBinaryMap.get(binaryId);
            String absoluteBinaryPath = DebuggerUtils.getAbsoluteBinaryPathByProjectName((String)projectName, (String)binaryPath);
            if (absoluteBinaryPath == null) {
                return new Status(4, S32DebuggerFlashProgrammerValidationActivator.getInstance().getBundleId(), NLS.bind((String)S32DebuggerFlashProgrammerErrorMessages.S32DebuggerFlashProgrammerAttributesValidator_binary_not_exist, (Object)binaryPath));
            }
            File binary = new File(absoluteBinaryPath);
            if (!binary.exists()) {
                return new Status(4, S32DebuggerFlashProgrammerValidationActivator.getInstance().getBundleId(), NLS.bind((String)S32DebuggerFlashProgrammerErrorMessages.S32DebuggerFlashProgrammerAttributesValidator_binary_not_exist, (Object)binary.getName()));
            }
            if (!allDisabled) continue;
            allDisabled = false;
        }
        if (allDisabled) {
            if (idToBinaryMap.isEmpty()) {
                return new Status(4, S32DebuggerFlashProgrammerValidationActivator.getInstance().getBundleId(), S32DebuggerFlashProgrammerErrorMessages.S32DebuggerFlashProgrammerAttributesValidator_no_applications);
            }
            return new Status(4, S32DebuggerFlashProgrammerValidationActivator.getInstance().getBundleId(), S32DebuggerFlashProgrammerErrorMessages.S32DebuggerFlashProgrammerAttributesValidator_select_at_least_one_application);
        }
        return Status.OK_STATUS;
    }

    public IStatus validateMainTabParameters(S32DebuggerFlashProgrammerParams mainParams) {
        return this.validateProjectParameters(mainParams);
    }

    public IStatus validateFlashParameters(S32DebuggerFlashProgrammerParams flashProgrammerParams, boolean checkForLaunch) {
        ArrayList<IStatus> errors = new ArrayList<IStatus>();
        errors.addAll(this.validateDebuggerParameters(flashProgrammerParams, checkForLaunch));
        errors.add(this.validateMainTabParameters(flashProgrammerParams));
        Collection errorStatuses = errors.stream().filter(status -> status.getSeverity() == 4).collect(Collectors.toList());
        if (!errorStatuses.isEmpty()) {
            StringBuilder builder = new StringBuilder(ErrorMessages.LaunchSequence_wrong_attributes);
            errorStatuses.forEach(status -> {
                builder.append("\n");
                builder.append(status.getMessage());
            });
            return new Status(4, S32DebuggerFlashProgrammerValidationActivator.getInstance().getBundleId(), builder.toString());
        }
        return Status.OK_STATUS;
    }
}

