/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.cle.runtime.memory.spaces.internal.core;

import com.nxp.s32ds.cle.runtime.memory.spaces.core.DeviceCoreMemorySpaceDescriptor;
import com.nxp.s32ds.cle.runtime.memory.spaces.core.DeviceCoreMemorySpaceRecognitionDescriptor;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;

public class MemorySpacesRegistry {
    private static MemorySpacesRegistry INSTANCE;
    private final Collection<DeviceCoreMemorySpaceDescriptor> memorySpaces = new ArrayList<DeviceCoreMemorySpaceDescriptor>();
    private final HashMap<String, DeviceCoreMemorySpaceRecognitionDescriptor> id2memSpaceRecognitionDescriptor = new HashMap();
    private final DeviceCoreMemorySpaceRecognitionDescriptor deviceCoreMemorySpaceRecognitionDescriptor = new DeviceCoreMemorySpaceRecognitionDescriptor(){

        @Override
        public int getShift() {
            return 0;
        }

        @Override
        public BigInteger getMask() {
            return this.getMask();
        }

        @Override
        public String getId() {
            return "DEFAULT_MEMORY_SPACE_RECOGNITION_DESCRIPTOR_ID";
        }
    };

    private MemorySpacesRegistry() {
        this.addDeviceCoreMemorySpaceRecognitionDescriptor(this.deviceCoreMemorySpaceRecognitionDescriptor);
    }

    public static MemorySpacesRegistry getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new MemorySpacesRegistry();
        }
        return INSTANCE;
    }

    public Collection<DeviceCoreMemorySpaceDescriptor> getMemoryDescriptors() {
        return this.memorySpaces;
    }

    public void addDeviceMemorySpaceDescriptor(DeviceCoreMemorySpaceDescriptor descriptor) {
        if (descriptor != null && !this.memorySpaces.contains(descriptor)) {
            this.memorySpaces.add(descriptor);
        }
    }

    public void removeDeviceMemorySpaceDescriptor(DeviceCoreMemorySpaceDescriptor descriptor) {
        if (descriptor != null && this.memorySpaces.contains(descriptor)) {
            this.memorySpaces.remove(descriptor);
        }
    }

    public void removeAllDeviceMemorySpaceDescriptors() {
        this.memorySpaces.clear();
    }

    public void addDeviceCoreMemorySpaceRecognitionDescriptor(DeviceCoreMemorySpaceRecognitionDescriptor descriptor) {
        this.id2memSpaceRecognitionDescriptor.put(descriptor.getId(), descriptor);
    }

    public DeviceCoreMemorySpaceRecognitionDescriptor getMemorySpaceRecognitionDescriptor(String id) {
        return this.id2memSpaceRecognitionDescriptor.getOrDefault(id, this.deviceCoreMemorySpaceRecognitionDescriptor);
    }
}

