/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.debug.ide.global.variables.actions;

import com.nxp.s32ds.debug.ide.global.variables.Activator;
import com.nxp.s32ds.debug.ide.global.variables.S32GlobalVariablesMessages;
import com.nxp.s32ds.debug.ide.global.variables.actions.ActionsUtil;
import com.nxp.s32ds.debug.ide.global.variables.context.GlobalVariablesDMVMNode;
import com.nxp.s32ds.debug.ide.global.variables.gdb.control.GlobalVariablesService;
import com.nxp.s32ds.debug.ide.global.variables.gdb.control.S32DSGlobalVariablesManager;
import org.eclipse.debug.ui.IDebugView;
import org.eclipse.jface.action.Action;

public class ShowPathInNameAction
extends Action {
    public static final String ACTION_ID = String.valueOf(Activator.getInstance().getBundleId()) + ".show.path.in.name.action";
    private IDebugView fDebugView;

    public ShowPathInNameAction(IDebugView debugView) {
        super(S32GlobalVariablesMessages.ShowPathInNameAction_Name, 2);
        this.fDebugView = debugView;
        this.setToolTipText(S32GlobalVariablesMessages.ShowPathInNameAction_Name);
        this.setImageDescriptor(Activator.addPathToNameImageDescriptor);
        this.setId(ACTION_ID);
    }

    public void run() {
        String sessionId = ActionsUtil.getCurrentSessionId(this.fDebugView);
        if (sessionId.isEmpty()) {
            return;
        }
        GlobalVariablesDMVMNode.restoreShowPathInNameGlobalVariables(this.isChecked());
        S32DSGlobalVariablesManager.getInstance().getGlobalVariablesService(sessionId).setNeedRefresh();
        this.fDebugView.getViewer().refresh();
    }

    public void setEnabled(boolean enabled) {
        if (enabled) {
            String sessionId = ActionsUtil.getCurrentSessionId(this.fDebugView);
            if (sessionId.isEmpty()) {
                super.setEnabled(false);
                return;
            }
            GlobalVariablesService globalVariablesService = S32DSGlobalVariablesManager.getInstance().getGlobalVariablesService(sessionId);
            if (globalVariablesService == null || globalVariablesService.getGlobalVariables().isEmpty()) {
                super.setEnabled(false);
                return;
            }
        }
        super.setEnabled(enabled);
    }
}

