/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.debug.ide.global.variables.context;

import com.nxp.s32ds.debug.ide.global.variables.Activator;
import com.nxp.s32ds.debug.ide.global.variables.S32GlobalVariablesMessages;
import com.nxp.s32ds.debug.ide.global.variables.gdb.control.GlobalVariablesService;
import com.nxp.s32ds.debug.ide.global.variables.model.GlobalVariableModel;
import java.io.File;
import java.util.concurrent.Executor;
import org.eclipse.cdt.debug.core.ICWatchpointTarget;
import org.eclipse.cdt.dsf.concurrent.DataRequestMonitor;
import org.eclipse.cdt.dsf.datamodel.DMContexts;
import org.eclipse.cdt.dsf.datamodel.IDMContext;
import org.eclipse.cdt.dsf.debug.service.IExpressions;
import org.eclipse.cdt.dsf.debug.ui.viewmodel.expression.IExpressionUpdate;
import org.eclipse.cdt.dsf.debug.ui.viewmodel.numberformat.IFormattedValueVMContext;
import org.eclipse.cdt.dsf.debug.ui.viewmodel.variable.SyncVariableDataAccess;
import org.eclipse.cdt.dsf.debug.ui.viewmodel.variable.VariableVMNode;
import org.eclipse.cdt.dsf.service.DsfSession;
import org.eclipse.cdt.dsf.ui.viewmodel.datamodel.AbstractDMVMProvider;
import org.eclipse.cdt.dsf.ui.viewmodel.datamodel.IDMVMContext;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.model.IExpression;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IChildrenCountUpdate;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IChildrenUpdate;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IViewerUpdate;
import org.eclipse.debug.ui.actions.IWatchExpressionFactoryAdapter2;

public class GlobalVariablesDMVMNode
extends VariableVMNode {
    private static final String GDB_FILE_SEPARATOR = "::";
    private static final String SHOW_VARIABLE_WITH_PATH_FORMAT = "%s [%s]";
    private static final String VARIABLE_REGEX = "'.*'::.*";
    private static final String VARIABLE_REGEX_POINTER = ".*'.*'::.*";
    public static final String VARIABLE_WITH_PATH_REGEX = "^'.*'::.*$";
    private static boolean showPathInName = false;
    private final S32DSVariableExpressionFactory s32dsVariableExpressionFactory = new S32DSVariableExpressionFactory();

    public GlobalVariablesDMVMNode(AbstractDMVMProvider provider, DsfSession session, SyncVariableDataAccess syncVariableDataAccess) {
        super(provider, session, syncVariableDataAccess);
    }

    public IDMVMContext createVMContext(IDMContext dmc) {
        return new S32DSDMVMContextGlobalVariable(dmc);
    }

    protected void updateElementCountInSessionThread(IChildrenCountUpdate update) {
        IExpressions.IExpressionDMContext expressionDMC = (IExpressions.IExpressionDMContext)this.findDmcInPath(update.getViewerInput(), update.getElementPath(), IExpressions.IExpressionDMContext.class);
        if (expressionDMC != null) {
            super.updateElementCountInSessionThread(update);
        } else {
            GlobalVariablesService globalVariablesService = (GlobalVariablesService)this.getServicesTracker().getService(GlobalVariablesService.class);
            if (globalVariablesService == null) {
                update.setStatus(Status.error((String)S32GlobalVariablesMessages.GlobalVariablesDMVMNode_GlobalVariables_service_is_null));
                update.done();
                return;
            }
            int count = globalVariablesService.getGlobalVariablesToShow().size();
            update.setChildCount(count);
            update.done();
        }
    }

    protected void updateElementsInSessionThread(IChildrenUpdate childrenUpdate) {
        IExpressions.IExpressionDMContext expressionDMC = (IExpressions.IExpressionDMContext)this.findDmcInPath(childrenUpdate.getViewerInput(), childrenUpdate.getElementPath(), IExpressions.IExpressionDMContext.class);
        if (expressionDMC != null) {
            super.updateElementsInSessionThread(childrenUpdate);
        } else {
            this.getGlobalsUpdateElementsInSessionThread(childrenUpdate);
        }
    }

    private void getGlobalsUpdateElementsInSessionThread(IChildrenUpdate update) {
        IDMContext idmContext = this.findDmcInPath(update.getViewerInput(), update.getElementPath(), IDMContext.class);
        IExpressions expressionService = (IExpressions)this.getServicesTracker().getService(IExpressions.class);
        GlobalVariablesService globalVariablesService = (GlobalVariablesService)this.getServicesTracker().getService(GlobalVariablesService.class);
        IExpressions.IExpressionDMContext[] expressionDMCs = new IExpressions.IExpressionDMContext[globalVariablesService.getGlobalVariablesToShow().size()];
        int i = 0;
        for (GlobalVariableModel globalVariableModel : globalVariablesService.getGlobalVariablesToShow()) {
            expressionDMCs[i++] = this.createExpressionForGlobalVar(expressionService, idmContext, GlobalVariablesDMVMNode.getFormattedExpression(globalVariableModel.getFilePath().toPortableString(), globalVariableModel.getName()));
        }
        this.fillUpdateWithVMCs(update, (IDMContext[])expressionDMCs);
        update.done();
    }

    public void update(IExpressionUpdate update) {
        this.getSession().getExecutor().execute(() -> {
            IExpressions expressionService = (IExpressions)this.getServicesTracker().getService(IExpressions.class);
            if (expressionService != null) {
                IExpressions.IExpressionDMContext expressionDMC = this.createExpressionForGlobalVar(expressionService, this.createCompositeDMVMContext((IViewerUpdate)update), update.getExpression().getExpressionText());
                S32DSDMVMContextGlobalVariable variableVmc = (S32DSDMVMContextGlobalVariable)this.createVMContext((IDMContext)expressionDMC);
                variableVmc.setExpression(update.getExpression());
                update.setExpressionElement((Object)variableVmc);
                update.done();
            } else {
                this.handleFailedUpdate((IViewerUpdate)update);
            }
        });
    }

    protected void associateExpression(Object element, IExpression expression) {
        if (element instanceof S32DSDMVMContextGlobalVariable) {
            ((S32DSDMVMContextGlobalVariable)((Object)element)).setExpression(expression);
        }
    }

    private IExpressions.IExpressionDMContext createExpressionForGlobalVar(IExpressions expressionService, IDMContext dmc, String expression) {
        IExpressions.IExpressionDMContext exprDMC = expressionService.createExpression(dmc, expression);
        if (this.fCastToTypeSupport != null) {
            exprDMC = this.fCastToTypeSupport.replaceWithCastedExpression(exprDMC);
        }
        return exprDMC;
    }

    private static String getFormattedExpression(String filePath, String globalVariableName) {
        if (new File(filePath).exists()) {
            return '\'' + filePath + '\'' + GDB_FILE_SEPARATOR + globalVariableName;
        }
        return globalVariableName;
    }

    protected String getExpressionDisplayName(IExpressions.IExpressionDMContext dmc, String name) {
        String nameToDisplay = super.getExpressionDisplayName(dmc, name);
        if (nameToDisplay.matches(VARIABLE_WITH_PATH_REGEX) && nameToDisplay.equals(name)) {
            String varName = nameToDisplay.substring(nameToDisplay.indexOf(GDB_FILE_SEPARATOR) + GDB_FILE_SEPARATOR.length());
            String path = nameToDisplay.substring(0, nameToDisplay.indexOf(GDB_FILE_SEPARATOR));
            nameToDisplay = showPathInName ? String.format(SHOW_VARIABLE_WITH_PATH_FORMAT, varName, path) : varName;
        }
        return nameToDisplay;
    }

    public static void restoreShowPathInNameGlobalVariables(boolean value) {
        showPathInName = value;
    }

    public static boolean getShowPathInNameGlobalVariables() {
        return showPathInName;
    }

    public class S32DSDMVMContextGlobalVariable
    extends VariableVMNode.VariableExpressionVMC
    implements IFormattedValueVMContext,
    ICWatchpointTarget {
        private IExpression fExpression;

        public S32DSDMVMContextGlobalVariable(IDMContext idmContext) {
            super((VariableVMNode)GlobalVariablesDMVMNode.this, idmContext);
        }

        public void setExpression(IExpression expression) {
            this.fExpression = expression;
        }

        public String getExpression() {
            IExpressions.IExpressionDMContext expressionDMContext = (IExpressions.IExpressionDMContext)DMContexts.getAncestorOfType((IDMContext)this.getDMContext(), IExpressions.IExpressionDMContext.class);
            if (expressionDMContext != null) {
                String expressionString = expressionDMContext.getExpression();
                if (expressionString.matches(GlobalVariablesDMVMNode.VARIABLE_REGEX_POINTER)) {
                    expressionString = expressionString.replaceAll("'.*'::", "");
                    return expressionString;
                }
                return expressionString;
            }
            return "";
        }

        public Object getAdapter(Class adapter) {
            if (this.fExpression != null && adapter.isAssignableFrom(this.fExpression.getClass())) {
                return this.fExpression;
            }
            if (adapter.isAssignableFrom(IWatchExpressionFactoryAdapter2.class)) {
                return GlobalVariablesDMVMNode.this.s32dsVariableExpressionFactory;
            }
            return super.getAdapter(adapter);
        }

        public boolean equals(Object other) {
            if (other instanceof S32DSDMVMContextGlobalVariable && super.equals(other)) {
                S32DSDMVMContextGlobalVariable otherGroup = (S32DSDMVMContextGlobalVariable)((Object)other);
                return otherGroup.fExpression == null && this.fExpression == null || otherGroup.fExpression != null && otherGroup.fExpression.equals(this.fExpression);
            }
            return false;
        }

        public void canSetWatchpoint(ICWatchpointTarget.CanCreateWatchpointRequest request) {
            request.setCanCreate(true);
        }

        public void getSize(final ICWatchpointTarget.GetSizeRequest request) {
            IExpressions.IExpressionDMContext exprDmc = (IExpressions.IExpressionDMContext)DMContexts.getAncestorOfType((IDMContext)this.getDMContext(), IExpressions.IExpressionDMContext.class);
            if (exprDmc != null) {
                GlobalVariablesDMVMNode.this.getSession().getExecutor().execute(() -> {
                    IExpressions expressionService = (IExpressions)GlobalVariablesDMVMNode.this.getServicesTracker().getService(IExpressions.class);
                    if (expressionService != null) {
                        DataRequestMonitor<IExpressions.IExpressionDMAddress> drm = new DataRequestMonitor<IExpressions.IExpressionDMAddress>((Executor)GlobalVariablesDMVMNode.this.getSession().getExecutor(), null){

                            public void handleCompleted() {
                                if (this.isSuccess()) {
                                    request.setSize(((IExpressions.IExpressionDMAddress)this.getData()).getSize());
                                }
                                request.setStatus(this.getStatus());
                                request.done();
                            }
                        };
                        expressionService.getExpressionAddressData(exprDmc, (DataRequestMonitor)drm);
                    } else {
                        request.setStatus((IStatus)new Status(4, Activator.getInstance().getBundleId(), S32GlobalVariablesMessages.GlobalVariablesDMVMNode_Cant_get_expression_size));
                        request.done();
                    }
                });
            } else {
                request.setStatus((IStatus)new Status(4, Activator.getInstance().getBundleId(), S32GlobalVariablesMessages.GlobalVariablesDMVMNode_Cant_get_expression_size));
                request.done();
            }
        }
    }

    protected class S32DSVariableExpressionFactory
    implements IWatchExpressionFactoryAdapter2 {
        protected S32DSVariableExpressionFactory() {
        }

        public boolean canCreateWatchExpression(Object element) {
            return element instanceof S32DSDMVMContextGlobalVariable;
        }

        public String createWatchExpression(Object element) throws CoreException {
            if (element instanceof S32DSDMVMContextGlobalVariable) {
                S32DSDMVMContextGlobalVariable exprVmc = (S32DSDMVMContextGlobalVariable)((Object)element);
                return exprVmc.getExpression();
            }
            return null;
        }
    }
}

