/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.debug.ide.global.variables.model;

import com.nxp.s32ds.debug.ide.global.variables.Activator;
import com.nxp.s32ds.debug.ide.global.variables.S32GlobalVariablesMessages;
import com.nxp.s32ds.debug.ide.global.variables.model.GlobalVariableImpl;
import com.nxp.s32ds.debug.ide.global.variables.model.GlobalVariableModel;
import com.nxp.s32ds.debug.ide.global.variables.model.IGlobalVariablesResult;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.cdt.dsf.mi.service.command.output.MIConsoleStreamOutput;
import org.eclipse.cdt.dsf.mi.service.command.output.MIOOBRecord;
import org.eclipse.cdt.dsf.mi.service.command.output.MIOutput;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;

public class LegacyGlobalVariablesResult
extends IGlobalVariablesResult {
    private static final String LINE_SEPARATOR = ":";
    private static final String FILE_PATH_REGEX = ".*:\\\\n";
    private static final String NON_DEBUGGING_SYMBOLS = "\\nNon-debugging symbols:\\n";
    private static final String ALL_DEFINED_VARIABLES = "All defined variables:\\n";
    private static final String FILE = "\\nFile ";
    private static final String VAR_REGEX = ".* .*;\\\\n";
    private static final String STATIC = "static";
    private static final String GLOBAL_VAR_REGEX_NO_POINTERS = "\\b([\\w\\s\\*]+)\\b\\s+(\\w+(?:\\[\\d*\\])*(?:\\[\\d*\\])*)\\s*;";
    private static final String GLOBAL_VAR_REGEX_POINTERS = "\\b(\\w+\\s*(\\*+))\\s*(\\w+(?:\\[\\d*\\])?)\\s*(?:,\\s*(\\w+\\s*(\\*+))\\s*(\\w+(?:\\[\\d*\\])?))*\\s*;";
    private List<GlobalVariableModel> globalVariables;
    private Map<String, SortedSet<GlobalVariableModel>> path2globalVariables;
    private Pattern pattern;

    public LegacyGlobalVariablesResult(MIOutput record, String elfDirectory) {
        super(record);
        this.parseOutput(record, elfDirectory);
    }

    private void parseOutput(MIOutput record, String elfDirectory) {
        this.globalVariables = new ArrayList<GlobalVariableModel>();
        this.path2globalVariables = new HashMap<String, SortedSet<GlobalVariableModel>>();
        boolean wasAllVaraiblesDefined = false;
        MIOOBRecord[] mioobRecords = record.getMIOOBRecords();
        Path lastPath = null;
        TreeSet<GlobalVariableImpl> lastList = null;
        MIOOBRecord[] mIOOBRecordArray = mioobRecords;
        int n = mioobRecords.length;
        int n2 = 0;
        while (n2 < n) {
            MIOOBRecord mioobRecord = mIOOBRecordArray[n2];
            if (mioobRecord instanceof MIConsoleStreamOutput) {
                MIConsoleStreamOutput consoleStreamOutput = (MIConsoleStreamOutput)mioobRecord;
                if (!wasAllVaraiblesDefined && consoleStreamOutput.getCString().equals(ALL_DEFINED_VARIABLES)) {
                    wasAllVaraiblesDefined = true;
                } else if (wasAllVaraiblesDefined) {
                    if (consoleStreamOutput.getCString().equals(NON_DEBUGGING_SYMBOLS)) {
                        if (lastList != null && !lastList.isEmpty()) {
                            this.globalVariables.addAll((Collection<GlobalVariableModel>)lastList);
                            this.path2globalVariables.put(lastPath.toOSString(), (SortedSet<GlobalVariableModel>)lastList);
                        }
                    } else if (consoleStreamOutput.getCString().equals(FILE)) {
                        if (lastList != null && !lastList.isEmpty()) {
                            this.globalVariables.addAll((Collection<GlobalVariableModel>)lastList);
                            this.path2globalVariables.put(lastPath.toOSString(), (SortedSet<GlobalVariableModel>)lastList);
                        }
                    } else if (consoleStreamOutput.getCString().matches(FILE_PATH_REGEX)) {
                        Path pathToUse = lastPath = new Path(consoleStreamOutput.getCString().substring(0, consoleStreamOutput.getCString().lastIndexOf(58)));
                        if (!lastPath.isAbsolute()) {
                            lastPath = new Path(String.valueOf(elfDirectory) + '/' + lastPath.toOSString());
                        }
                        if (!new File(lastPath.toOSString()).exists()) {
                            lastPath = pathToUse;
                        }
                        lastList = new TreeSet<GlobalVariableImpl>();
                    } else if (consoleStreamOutput.getCString().matches(VAR_REGEX)) {
                        String description = consoleStreamOutput.getCString().substring(0, consoleStreamOutput.getCString().indexOf("\\n"));
                        String globalvar = description.replace(STATIC, "");
                        this.pattern = Pattern.compile(GLOBAL_VAR_REGEX_NO_POINTERS);
                        Matcher matcher = this.pattern.matcher(globalvar);
                        this.pattern = Pattern.compile(GLOBAL_VAR_REGEX_POINTERS);
                        Matcher matcher1 = this.pattern.matcher(globalvar);
                        String type = null;
                        String name = null;
                        String array = "";
                        if (matcher.find()) {
                            type = matcher.group(1).trim();
                            name = matcher.group(2).trim();
                            if (name.contains("[")) {
                                array = name.substring(name.indexOf(91), name.lastIndexOf(93) + 1);
                                type = String.valueOf(type) + array;
                                name = name.replace(array, "");
                            }
                        } else if (matcher1.find()) {
                            type = matcher1.group(1).trim();
                            name = matcher1.group(3).trim();
                            if (name.contains("[")) {
                                array = name.substring(name.indexOf(91), name.lastIndexOf(93) + 1);
                                type = String.valueOf(type) + array;
                                name = name.replace(array, "");
                            }
                        } else if (globalvar.contains("(") && globalvar.contains(")")) {
                            array = globalvar.substring(globalvar.indexOf(40) + 1, globalvar.indexOf(41));
                            name = array.replace("*", "");
                            if (globalvar.contains("[")) {
                                name = array.substring(0, array.indexOf(91)).replace("*", "");
                            }
                            type = globalvar.replace(name, "").replace(";", "");
                        }
                        String[] splitString = description.split(LINE_SEPARATOR);
                        int line = -1;
                        try {
                            line = Integer.parseInt(splitString[0]);
                        }
                        catch (NumberFormatException e) {
                            Activator.getInstance().logWarning(e.getMessage(), e.getCause());
                        }
                        Path path = lastPath;
                        try {
                            if (path != null && !type.contains(S32GlobalVariablesMessages.GlobalVar_Exception)) {
                                GlobalVariableImpl globalVariableModel = new GlobalVariableImpl(name, (IPath)path, type, line, description);
                                lastList.add(globalVariableModel);
                            }
                        }
                        catch (Exception e) {
                            Activator.getInstance().logError(e.getMessage(), e);
                        }
                    }
                }
            }
            ++n2;
        }
        if (lastList != null && !this.path2globalVariables.containsKey(lastPath.toOSString())) {
            this.globalVariables.addAll(lastList);
            this.path2globalVariables.put(lastPath.toOSString(), lastList);
        }
    }

    @Override
    public List<GlobalVariableModel> getGlobalVariables() {
        return this.globalVariables;
    }

    @Override
    public Map<String, SortedSet<GlobalVariableModel>> getPath2GlobalVariables() {
        return this.path2globalVariables;
    }
}

