/*
 * Decompiled with CFR 0.152.
 */
package com.freescale.s32ds.cdt.core.errorParsers;

import com.freescale.s32ds.cdt.core.FSLErrorParserManager;
import com.freescale.s32ds.cdt.core.IFSLErrorParser3;
import com.freescale.s32ds.cdt.core.errorParsers.CommonErrorParser;
import com.freescale.s32ds.cdt.core.errorParsers.ErrorParsersActivator;
import com.freescale.s32ds.cdt.core.errorParsers.Messages;
import com.freescale.s32ds.cdt.core.errorParsers.TraceUtil;
import java.util.regex.Pattern;
import org.eclipse.cdt.core.ErrorParserManager;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

public class MwErrorParser
extends CommonErrorParser
implements IFSLErrorParser3 {
    private static final int STATE_START = 0;
    private static final int STATE_HEADER = 1;
    private static final int STATE_LOCATIONS = 2;
    private static final int STATE_COMPILATION_ELEMENT = 3;
    private static final int STATE_MESSAGE = 4;
    private int state = 0;
    private String varName;
    private CommonErrorParser.Message msg = null;
    private boolean isErrorMsg;
    private static final Pattern m = Pattern.compile(Messages.getString("MwErrorParser_Problems", null));

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean processLine(String line, ErrorParserManager eoParser) {
        try {
            String errMsg;
            TraceUtil.debugMwfeErrorParser("Parsing line: " + line);
            if (this.state == 0 && this.isProblemLine(line)) {
                boolean consume = this.handleFirstProblemLine(eoParser, line);
                if (!(eoParser instanceof FSLErrorParserManager)) return consume;
                ((FSLErrorParserManager)eoParser).addErrorMsgLine(line);
                return consume;
            }
            if (this.state == 1) {
                this.state = 2;
                String[] locations = this.getErrorLocation(line);
                TraceUtil.debugMwfeErrorParser("File path: " + this.msg.filePath);
                TraceUtil.debugMwfeErrorParser("Line number: " + this.msg.lineNumber);
                if (locations.length == 2) {
                    this.msg.filePath = locations[0];
                    this.msg.lineNumber = Integer.parseInt(locations[1]);
                    if (!(eoParser instanceof FSLErrorParserManager)) return true;
                    ((FSLErrorParserManager)eoParser).addErrorMsgLine(line);
                    return true;
                }
                this.msg.filePath = "";
                this.msg.lineNumber = 0;
                String errMsg2 = this.getErrorMessage(line);
                if (errMsg2 != null) {
                    this.msg.appendDescription(errMsg2);
                    this.state = 4;
                    if (eoParser instanceof FSLErrorParserManager) {
                        ((FSLErrorParserManager)eoParser).addErrorMsgLine(line);
                    }
                }
                if (errMsg2 == null) return false;
                return true;
            }
            if (this.state == 2) {
                this.state = 3;
                this.varName = this.getErrorCompilationElement(line);
                if (this.varName != null) {
                    TraceUtil.debugMwfeErrorParser("Translation element: " + this.varName);
                    if (!(eoParser instanceof FSLErrorParserManager)) return true;
                    ((FSLErrorParserManager)eoParser).addErrorMsgLine(line);
                    return true;
                }
                errMsg = this.getErrorMessage(line);
                if (errMsg != null) {
                    this.msg.appendDescription(errMsg);
                    this.state = 4;
                    if (!(eoParser instanceof FSLErrorParserManager)) return true;
                    ((FSLErrorParserManager)eoParser).addErrorMsgLine(line);
                    return true;
                }
            }
            if (this.state == 3) {
                this.state = 4;
                errMsg = this.getErrorMessage(line);
                if (errMsg != null) {
                    this.msg.appendDescription(errMsg);
                    if (eoParser instanceof FSLErrorParserManager) {
                        ((FSLErrorParserManager)eoParser).addErrorMsgLine(line);
                    }
                    this.isErrorMsg = true;
                    return true;
                }
                if (line.length() > 0 && this.msg != null) {
                    this.msg.appendAlternateDescription(line);
                }
                TraceUtil.debugMwfeErrorParser("First description line: " + this.msg.getDescription());
                return false;
            }
            if (this.state != 4) {
                this.clearState();
                return false;
            }
            errMsg = this.getErrorMessage(line);
            if (errMsg != null) {
                this.msg.appendDescription(errMsg);
                if (eoParser instanceof FSLErrorParserManager) {
                    ((FSLErrorParserManager)eoParser).addErrorMsgLine(line);
                }
                TraceUtil.debugMwfeErrorParser("Compound description: " + this.msg.getDescription());
                return true;
            }
            if (this.isErrorMsg) {
                if (eoParser instanceof FSLErrorParserManager) {
                    ((FSLErrorParserManager)eoParser).setErrorMsgComplete(true);
                }
                this.generateMarker(eoParser);
                TraceUtil.debugMwfeErrorParser("Clearing error parser state for line: " + line);
                this.clearState();
            }
            if (this.isProblemLine(line)) {
                boolean consume = this.handleFirstProblemLine(eoParser, line);
                if (!(eoParser instanceof FSLErrorParserManager)) return consume;
                ((FSLErrorParserManager)eoParser).flushPendingErrors();
                ((FSLErrorParserManager)eoParser).addErrorMsgLine(line);
                return consume;
            }
            if (line.length() <= 0) return false;
            if (this.msg == null) return false;
            this.msg.appendAlternateDescription(line);
            return false;
        }
        catch (NumberFormatException e) {
            ErrorParsersActivator.DEFAULT.getLog().log((IStatus)new Status(4, "com.freescale.s32ds.cdt.core.errorParsers", e.getMessage(), (Throwable)e));
            TraceUtil.debugMwfeErrorParser("Clearing error parser state for line: " + line);
            this.clearState();
        }
        return false;
    }

    public void flush(ErrorParserManager eoParser) {
        if (this.msg != null && !this.msg.isEmpty()) {
            if (eoParser instanceof FSLErrorParserManager) {
                ((FSLErrorParserManager)eoParser).setErrorMsgComplete(true);
            }
            this.generateMarker(eoParser);
        }
        this.clearState();
    }

    private void generateMarker(ErrorParserManager eoParser) {
        IFile resource = this.msg.getFile(eoParser);
        if (resource == null) {
            eoParser.generateExternalMarker(null, this.msg.lineNumber, this.msg.getDescription(), this.msg.getMarkerSeverity(), this.varName, this.msg.getExternalFile());
        } else {
            eoParser.generateMarker((IResource)resource, this.msg.lineNumber, this.msg.getDescription(), this.msg.getMarkerSeverity(), this.varName);
        }
    }

    private boolean handleFirstProblemLine(ErrorParserManager eoParser, String line) {
        this.flush(eoParser);
        this.state = 1;
        this.msg = new CommonErrorParser.Message();
        this.msg.severity = this.getProblemSeverity(line);
        this.isErrorMsg = false;
        TraceUtil.debugMwfeErrorParser("Severity: " + this.msg.severity);
        return true;
    }

    private void clearState() {
        this.state = 0;
        this.msg = null;
        this.varName = null;
        this.isErrorMsg = false;
    }

    private String[] getErrorLocation(String line) {
        String[] s1 = line.split("\\|");
        if (s1.length != 6) {
            return new String[0];
        }
        return new String[]{s1[0].substring(1), s1[1]};
    }

    private String getErrorCompilationElement(String line) {
        int idxOf = line.indexOf(61);
        if (idxOf == -1) {
            return null;
        }
        return line.substring(idxOf + 1);
    }

    private String getErrorMessage(String line) {
        int idxOf = line.indexOf(62);
        if (idxOf != 0) {
            return null;
        }
        return line.substring(idxOf + 1);
    }

    protected boolean isProblemLine(String line) {
        return m.matcher(line).matches();
    }

    private int getProblemSeverity(String line) {
        if (line.contains("|Error")) {
            return 2;
        }
        if (line.contains("|Warning")) {
            return 1;
        }
        if (line.contains("|Note")) {
            return 0;
        }
        ErrorParsersActivator.DEFAULT.getLog().log((IStatus)new Status(4, "com.freescale.s32ds.cdt.core.errorParsers", "Unknown message type"));
        throw new IllegalArgumentException("Unknown message type");
    }

    public void shutdown() {
    }
}

