/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.tad.common.view.action;

import com.nxp.s32ds.tad.common.TadCommonActivator;
import com.nxp.s32ds.tad.common.messages.Messages;
import com.nxp.s32ds.tad.common.model.TadModel;
import com.nxp.s32ds.tad.common.view.TadView;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.TreeViewer;

public class PauseViewAction
extends Action {
    private TadModel tadModel;
    private TadView view;

    public PauseViewAction(TadModel tadModel, TadView view) {
        this.tadModel = tadModel;
        this.view = view;
    }

    public void run() {
        if (this.isEnabled()) {
            for (TreeViewer viewer : this.view.getTreeViewers().values()) {
                this.view.enableViewer(viewer, !this.isChecked());
            }
            this.tadModel.getLogger().info(String.format(Messages.Info_ViewPaused, this.view.getTitle(), this.isChecked() ? "paused" : "unpaused"));
            if (!this.isChecked() && !this.view.getController().isDataReady()) {
                this.view.showProgressBar();
                this.view.getController().requestData();
            }
        }
    }

    public String getText() {
        return String.format(Messages.Label_PauseView, this.view.getTitle());
    }

    public String getToolTipText() {
        return String.format(Messages.Label_PauseView_ToolTip, this.view.getTitle());
    }

    public ImageDescriptor getImageDescriptor() {
        return TadCommonActivator.getDefault().getImageDescriptor("pause");
    }
}

