/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.cle.cdt.project.info.core.exports.toolchains;

import com.nxp.s32ds.cle.cdt.project.info.core.exports.ProjectInfoExportSettings;
import com.nxp.s32ds.cle.cdt.project.info.core.exports.toolchains.ToolchainMetadata;
import com.nxp.s32ds.cle.cdt.project.info.core.internal.PIActivator;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.cdtvariables.CdtVariableException;
import org.eclipse.cdt.core.settings.model.ICConfigurationDescription;
import org.eclipse.cdt.managedbuilder.core.ITool;
import org.eclipse.cdt.managedbuilder.core.IToolChain;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.variables.IStringVariableManager;
import org.eclipse.core.variables.VariablesPlugin;

public abstract class GDBToolChainExporter
implements ToolchainMetadata {
    public static final String EMPTY = "";
    public static final String SEARCH_PATTERN = "(%s[^ ]*|%s\"[^ ]*\"|%s\"\"[^ ]*\"\")";
    public static final String GDB_TARGET_PARAMETER = "-T ";
    public static final String SPLIT_PATTERN = "%s| %s";
    public static final String INCLUDE_PARAMETER = "-I";
    public static final String PREPROCESSOR_PARAMETER = "-D";
    private static final String[] SPLITTING_PARAMETERS = new String[]{"-I", "-D", "-T "};

    public List<String> processOptions(ITool tool, List<String> options, ProjectInfoExportSettings settings) {
        ArrayList<String> resultList = new ArrayList<String>();
        for (String result : options) {
            if (settings.getDefaultPaths().booleanValue()) {
                try {
                    result = result.replace(CCorePlugin.getDefault().getCdtVariableManager().resolveValue("${ProjDirPath}", EMPTY, EMPTY, settings.getConfiguration()), "${ProjDirPath}");
                }
                catch (CdtVariableException e1) {
                    PIActivator.getDefault().logError(e1.getMessage());
                }
            } else if (settings.getAbsolutePaths().booleanValue()) {
                String otherSeporator = "/".equals(File.separator) ? "\\" : "/";
                result = result.replace(otherSeporator, File.separator);
            }
            String option = result;
            if (!Arrays.stream(SPLITTING_PARAMETERS).filter(parameter -> option.contains((CharSequence)parameter)).findAny().isPresent()) {
                resultList.add(result);
                continue;
            }
            Arrays.stream(SPLITTING_PARAMETERS).forEach(parameter -> {
                String[] splitted = option.split(String.format(SPLIT_PATTERN, parameter, parameter));
                if (splitted.length > 1) {
                    Arrays.stream(splitted).filter(strPart -> !strPart.isEmpty()).forEach(strPart -> {
                        boolean bl = resultList.add(parameter.concat((String)strPart));
                    });
                }
            });
        }
        return resultList;
    }

    public String getRootToolchainId(IToolChain toolchain) {
        IToolChain stepToolchain;
        IToolChain root = toolchain;
        while ((stepToolchain = root.getSuperClass()) != null) {
            root = stepToolchain;
        }
        return root.getId();
    }

    Collection<String> getLinkerCommandFiles(List<String> options, String pattern, ICConfigurationDescription configuration) {
        List<String> opts = this.getLinkerCommandFileOpts(pattern, options);
        if (opts.size() == 0) {
            return Collections.emptyList();
        }
        ArrayList<String> result = new ArrayList<String>();
        opts.forEach(option -> {
            boolean bl = result.add(this.extractFilePathFromOpt(pattern, (String)option, configuration));
        });
        return result;
    }

    List<String> getLinkerCommandFileOpts(String pattern, List<String> options) {
        ArrayList<String> linkerFilesOpts = new ArrayList<String>();
        Pattern searchPat = Pattern.compile(String.format(SEARCH_PATTERN, pattern, pattern, pattern));
        for (String option : options) {
            Matcher matcher = searchPat.matcher(option);
            while (matcher.find()) {
                int i = 1;
                while (i <= matcher.groupCount()) {
                    linkerFilesOpts.add(matcher.group(i));
                    ++i;
                }
            }
        }
        return linkerFilesOpts;
    }

    String extractFilePathFromOpt(String pattern, String opt, ICConfigurationDescription configuration) {
        IStringVariableManager varMng = VariablesPlugin.getDefault().getStringVariableManager();
        String fileString = opt.substring(pattern.length()).replace("\"", EMPTY);
        try {
            fileString = CCorePlugin.getDefault().getCdtVariableManager().resolveValue(fileString, EMPTY, EMPTY, configuration);
            return varMng.performStringSubstitution(fileString, false);
        }
        catch (CoreException e) {
            PIActivator.getDefault().log(e.getStatus());
            return fileString;
        }
    }

    public Collection<String> getLinkerCommandFiles(List<String> options, ICConfigurationDescription configuration) {
        return this.getLinkerCommandFiles(options, GDB_TARGET_PARAMETER, configuration);
    }

    public abstract boolean isSptAssembler(ITool var1);
}

