/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.cle.cdt.project.info.core.internal;

import com.nxp.s32ds.cle.cdt.project.info.core.imports.PIReader;
import com.nxp.s32ds.cle.cdt.project.info.core.internal.Messages;
import com.nxp.s32ds.cle.cdt.project.info.core.internal.PIActivator;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.cdtvariables.CdtVariableException;
import org.eclipse.cdt.core.settings.model.ICConfigurationDescription;
import org.eclipse.cdt.managedbuilder.core.BuildException;
import org.eclipse.cdt.managedbuilder.core.IOption;
import org.eclipse.cdt.managedbuilder.core.ITool;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.NLS;

public final class ProjectInfoPathProcessor {
    public static final String EMPTY = "";
    public static final String PROJDIRPATH = "${ProjDirPath}";
    public static final String LINKED_FILE = "link::";
    public static final String SEPARATOR = "::";

    public static final String getAbsolutePath(ICConfigurationDescription config, String path) throws CoreException {
        String resolvedPath = ProjectInfoPathProcessor.resolvePath(config, path);
        java.nio.file.Path configurationPath = Paths.get(resolvedPath, new String[0]);
        if (configurationPath.isAbsolute() && Files.exists(configurationPath, new LinkOption[0])) {
            return configurationPath.normalize().toString();
        }
        IProject project = config.getProjectDescription().getProject();
        IResource member = project.findMember(resolvedPath);
        if (member == null) {
            member = project.getWorkspace().getRoot().findMember(resolvedPath);
        }
        if (member == null) {
            throw new CoreException((IStatus)new Status(4, PIActivator.getDefault().getBundleId(), NLS.bind((String)Messages.ProjectInfoPathProcessor_cannot_process_path, (Object)resolvedPath)));
        }
        return member.getLocation().toOSString();
    }

    public static final String resolvePath(ICConfigurationDescription config, String path) {
        try {
            return CCorePlugin.getDefault().getCdtVariableManager().resolveValue(path, EMPTY, EMPTY, config);
        }
        catch (CdtVariableException e) {
            PIActivator.getDefault().log(e.getStatus());
            return path;
        }
    }

    public static final IFile makeOutIFile(IProject project, String path, PIReader importPIReader) {
        if (importPIReader.getProjectInfoPath() == null && path.contains(PROJDIRPATH)) {
            path = path.replace(PROJDIRPATH, EMPTY);
        } else if (Paths.get(path = path.replace('\\', '/'), new String[0]).isAbsolute() && importPIReader.getProjectInfoPath() != null) {
            String oldProjectPath = Paths.get(importPIReader.getProjectInfoPath(), new String[0]).getParent().toString().replace('\\', '/');
            if (path.startsWith(oldProjectPath)) {
                path = path.substring(oldProjectPath.length());
            } else {
                PIActivator.getDefault().logWarning(NLS.bind((String)Messages.ProjectInfoPathProcessor_cannot_make_path_relative, (Object)path, (Object)oldProjectPath));
            }
        }
        return project.getFile(path);
    }

    public static final java.nio.file.Path makeInPath(String path, PIReader importPIReader) {
        java.nio.file.Path result;
        java.nio.file.Path source;
        if ((path = path.replace('\\', '/')).contains(PROJDIRPATH)) {
            path = path.replace(PROJDIRPATH, importPIReader.getRootFolder());
        }
        if ((source = Paths.get(path, new String[0])).isAbsolute() && importPIReader.getProjectInfoPath() != null) {
            String oldProjectPath = Paths.get(importPIReader.getProjectInfoPath(), new String[0]).getParent().toString().replace('\\', '/');
            if (path.startsWith(oldProjectPath)) {
                path = path.substring(oldProjectPath.length());
                result = Paths.get(importPIReader.getRootFolder(), path);
            } else {
                result = Paths.get(path, new String[0]);
            }
        } else {
            result = !source.isAbsolute() ? Paths.get(importPIReader.getRootFolder(), path) : source;
        }
        if (!result.toFile().exists()) {
            PIActivator.getDefault().logWarning(NLS.bind((String)Messages.ProjectInfoPathProcessor_cannot_find_path, (Object)result.toString()));
        }
        return result;
    }

    public static final String substituteVarsPaths(String toolCommandFlagsString, ITool tool) {
        IOption option;
        int n;
        IOption[] iOptionArray;
        List<String> findValue = ProjectInfoPathProcessor.findValue(toolCommandFlagsString, "-I ?\"([^\"]+)\"|-I ?([^ ]+)");
        if (!findValue.isEmpty()) {
            for (String string : findValue) {
                toolCommandFlagsString = toolCommandFlagsString.replace(string, EMPTY);
            }
            iOptionArray = tool.getOptions();
            n = iOptionArray.length;
            int n2 = 0;
            while (n2 < n) {
                option = iOptionArray[n2];
                if (option.getId() != null && option.getId().contains("include.paths")) {
                    toolCommandFlagsString = ProjectInfoPathProcessor.substituteIncludePath(toolCommandFlagsString, option);
                }
                ++n2;
            }
        }
        if (!(findValue = ProjectInfoPathProcessor.findValue(toolCommandFlagsString, "--sysroot=\"[^\"]+\"|--sysroot=[^ ]+")).isEmpty()) {
            for (String string : findValue) {
                toolCommandFlagsString = toolCommandFlagsString.replace(string, EMPTY);
            }
            iOptionArray = tool.getOptions();
            n = iOptionArray.length;
            int n3 = 0;
            while (n3 < n) {
                option = iOptionArray[n3];
                if (option.getId() != null && option.getId().contains("sysroot")) {
                    toolCommandFlagsString = ProjectInfoPathProcessor.substituteSysrootPath(toolCommandFlagsString, option);
                }
                ++n3;
            }
        }
        return toolCommandFlagsString;
    }

    private static String substituteSysrootPath(String toolCommandFlagsString, IOption option) {
        String stringValue = (String)option.getValue();
        String listCmd = option.getCommand();
        if (stringValue != null) {
            stringValue = String.valueOf(listCmd) + ' ' + stringValue + ' ';
        }
        toolCommandFlagsString = String.valueOf(stringValue) + toolCommandFlagsString;
        return toolCommandFlagsString;
    }

    private static String substituteIncludePath(String toolCommandFlagsString, IOption option) {
        try {
            String[] stringValue = option.getBasicStringListValue();
            String listCmd = option.getCommand();
            StringBuilder builder = new StringBuilder();
            if (stringValue != null) {
                String[] stringArray = stringValue;
                int n = stringValue.length;
                int n2 = 0;
                while (n2 < n) {
                    String temp = stringArray[n2];
                    if (temp.length() > 0) {
                        builder.append(String.valueOf(listCmd) + ' ' + temp + ' ');
                    }
                    ++n2;
                }
            }
            toolCommandFlagsString = String.valueOf(builder.toString()) + toolCommandFlagsString;
        }
        catch (BuildException e) {
            PIActivator.getDefault().logError(e.getMessage());
        }
        return toolCommandFlagsString;
    }

    private static final List<String> findValue(String values, String stringPattern) {
        Pattern pattern = Pattern.compile(stringPattern);
        ArrayList<String> list = new ArrayList<String>();
        Matcher matcher = pattern.matcher(values);
        while (matcher.find()) {
            list.add(matcher.group(0));
        }
        return list;
    }

    public static String process(String path, Boolean defaultPaths, ICConfigurationDescription config) throws CoreException {
        if (defaultPaths.booleanValue()) {
            return path;
        }
        return ProjectInfoPathProcessor.getAbsolutePath(config, path);
    }

    public static String makeAbsOrRel(String path, boolean useAbsolute, ICConfigurationDescription cfg) throws CoreException {
        Path p = new Path(path);
        boolean isAbsolute = p.isAbsolute();
        if (!useAbsolute && isAbsolute) {
            IPath root = cfg.getProjectDescription().getProject().getLocation();
            path = p.makeRelativeTo(root).toOSString();
        } else if (useAbsolute && !isAbsolute) {
            path = ProjectInfoPathProcessor.getAbsolutePath(cfg, path);
        }
        return path;
    }
}

