/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.mem.validation.connections.tasystem;

import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.common.utils.logging.LogManager;
import com.nxp.swtools.common.utils.os.OSDetect;
import com.nxp.swtools.common.utils.text.UtilsText;
import com.nxp.swtools.mem.validation.connections.tasystem.ProcessDestroyer;
import com.nxp.swtools.mem.validation.connections.tasystem.StreamGobbler;
import com.nxp.swtools.mem.validation.connections.tasystem.TASystem;
import com.nxp.swtools.mem.validation.connections.tasystem.TASystemDescriptor;
import com.nxp.swtools.mem.validation.connections.tasystem.TASystemInstance;
import com.nxp.swtools.mem.validation.connections.tasystem.TargetAccessType;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.logging.Logger;

public class TASystemLauncher {
    private static final Logger LOGGER = LogManager.getLogger(TASystemLauncher.class);
    public static final long INIT_PROCESS_WAIT = 300000L;
    public static final String CCS_CONSOLE_ARG = "-console";
    @Nullable
    private static TASystemLauncher instance;
    public static final long DEFAULT_SCRIPT_TIMEOUT_MS = 3600000L;
    private Map<String, @Nullable Process> sharedServices = new HashMap<String, Process>();
    private Map<String, TASystemInstance> systemsInUse = new HashMap<String, TASystemInstance>();

    public static @Nullable Process createProcess( @Nullable TASystemDescriptor.TAProcessDescriptor pd, String execPath, boolean setDirectory, Map<String, String> params, @Nullable Map<String, String> envParams) throws IOException {
        File exeFile = null;
        if (pd != null && pd.type == TargetAccessType.GDB_PY) {
            exeFile = new File(execPath);
            if (!exeFile.exists()) {
                throw new FileNotFoundException("Validation process executable path does not exist: " + execPath);
            }
            if (OSDetect.isUnix() && !exeFile.canExecute() && !exeFile.setExecutable(true, false)) {
                throw new IOException(String.valueOf(UtilsText.safeString((String)pd.type.name())) + " can't start! Please verify the current user execution permission for: " + execPath);
            }
        }
        String[] args = TASystemLauncher.generateProcessArguments(Objects.requireNonNull(pd), execPath, params);
        ProcessBuilder pb = new ProcessBuilder(new String[0]);
        pb.redirectErrorStream(true);
        pb.command(args);
        if (pd != null && pd.type == TargetAccessType.GDB_PY && setDirectory && exeFile != null) {
            pb.directory(exeFile.getParentFile());
        }
        if (envParams != null) {
            Map<@Nullable String, @Nullable String> procEnv = pb.environment();
            for (Map.Entry<String, String> envParam : envParams.entrySet()) {
                procEnv.put(envParam.getKey(), envParam.getValue());
            }
        }
        Process proc = pb.start();
        if (pd.mode == TASystemDescriptor.TAProcessMode.SERVICE || pd.mode == TASystemDescriptor.TAProcessMode.SHARED_SERVICE) {
            boolean finished = false;
            try {
                Thread.sleep(300000L);
                proc.exitValue();
                finished = true;
            }
            catch (IllegalThreadStateException itse) {
                LOGGER.severe(itse.getLocalizedMessage());
            }
            catch (InterruptedException e) {
                LOGGER.severe(e.getLocalizedMessage());
                Thread.currentThread().interrupt();
            }
            if (finished) {
                throw new IOException(String.format("Launching: %s terminated unexpectedly!", execPath));
            }
        }
        if (pd.gobbler) {
            proc.getOutputStream().close();
            new Thread(new StreamGobbler(proc.getInputStream(), pd.type.name())).start();
        }
        return proc;
    }

    private static String[] generateProcessArguments(TASystemDescriptor.TAProcessDescriptor pd, String execPath, Map<String, String> params) {
        ArrayList<String> argList = new ArrayList<String>();
        argList.add(execPath);
        TASystemDescriptor.TAProcessArgument[] args = pd.args;
        if (args != null) {
            TASystemDescriptor.TAProcessArgument[] tAProcessArgumentArray = args;
            int n = args.length;
            int n2 = 0;
            while (n2 < n) {
                TASystemDescriptor.TAProcessArgument arg = tAProcessArgumentArray[n2];
                argList.add(arg.generate(params));
                ++n2;
            }
        }
        return argList.toArray(new String[argList.size()]);
    }

    public static synchronized TASystemLauncher getInstance() {
        TASystemLauncher instanceLoc = instance;
        if (instanceLoc == null) {
            instance = instanceLoc = new TASystemLauncher();
        }
        return instanceLoc;
    }

    private static boolean isProcessRunning(String execPath) {
        String command;
        String[] line;
        String taskname = new File(execPath).getName();
        String PID = "";
        if (OSDetect.isWindows()) {
            String command2 = String.format(String.valueOf(System.getenv("windir")) + "\\system32\\" + "tasklist.exe /FI \"IMAGENAME eq %s\" /NH", taskname);
            String[] line2 = TASystemLauncher.runCmd(command2).split("\\s+");
            if (line2.length >= 2) {
                try {
                    Integer.parseInt(line2[1]);
                    PID = line2[1];
                }
                catch (NumberFormatException numberFormatException) {
                    return false;
                }
            }
        } else if (OSDetect.isUnix() && (line = TASystemLauncher.runCmd(command = String.format("ps -e | grep -e \"\\s%s\" | grep -v grep", taskname)).trim().split("\\s+")).length >= 1) {
            try {
                Integer.parseInt(line[0]);
                PID = line[0];
            }
            catch (NumberFormatException e) {
                LOGGER.severe(e.getMessage());
            }
        }
        return !PID.isEmpty();
    }

    private static String runCmd(String command) {
        StringBuffer out = new StringBuffer();
        try {
            Process p;
            String[] cmd;
            if (OSDetect.isUnix()) {
                cmd = new String[]{"/bin/sh", "-c", command};
                p = Runtime.getRuntime().exec(cmd);
            } else {
                p = Runtime.getRuntime().exec(command);
            }
            try {
                cmd = null;
                Object var4_7 = null;
                try (BufferedReader input = new BufferedReader(new InputStreamReader(p.getInputStream(), StandardCharsets.UTF_8));){
                    String line = "";
                    while ((line = input.readLine()) != null) {
                        out.append(line);
                    }
                    input.close();
                    p.destroy();
                }
                catch (Throwable throwable) {
                    if (cmd == null) {
                        cmd = throwable;
                    } else if (cmd != throwable) {
                        cmd.addSuppressed(throwable);
                    }
                    throw cmd;
                }
            }
            catch (Exception err) {
                LOGGER.severe(err.getMessage());
            }
        }
        catch (Exception err) {
            LOGGER.severe(err.getMessage());
        }
        return out.toString();
    }

    public static boolean serviceIsDown(TASystemInstance sysInstance) {
        TASystemDescriptor.TAProcessDescriptor[] tAProcessDescriptorArray = sysInstance.getSystem().getDescriptor().processes;
        int n = sysInstance.getSystem().getDescriptor().processes.length;
        int n2 = 0;
        while (n2 < n) {
            TASystemDescriptor.TAProcessDescriptor pd = tAProcessDescriptorArray[n2];
            if (pd.type == TargetAccessType.SERIAL && sysInstance.getOutputHandler() == null) {
                return true;
            }
            if (sysInstance.isRunning()) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    public TASystemInstance acquire(TASystem system, Map<String, String> params) throws IOException {
        return this.acquire(system, params, new HashMap<String, String>());
    }

    public synchronized TASystemInstance acquire(TASystem system, Map<String, String> params, Map<String, String> env) throws IOException {
        String sysId = system.getSystemId();
        TASystemInstance sysInUse = this.systemsInUse.get(sysId);
        if (sysInUse == null) {
            sysInUse = this.createTASystemInstance(system, params);
            this.systemsInUse.put(sysId, sysInUse);
        }
        if (TASystemLauncher.serviceIsDown(sysInUse)) {
            sysInUse.launchTransientProcess(3600000L, env);
        }
        return sysInUse;
    }

    private TASystemInstance createTASystemInstance(TASystem system, Map<String, String> params) throws IOException {
        HashMap<String, @Nullable Process> services = new HashMap<String, Process>();
        TASystemDescriptor.TAProcessDescriptor transientPD = null;
        String transientPath = null;
        TASystemDescriptor.TAProcessDescriptor[] tAProcessDescriptorArray = system.getDescriptor().processes;
        int n = system.getDescriptor().processes.length;
        int n2 = 0;
        while (n2 < n) {
            TASystemDescriptor.TAProcessDescriptor pd = tAProcessDescriptorArray[n2];
            switch (pd.mode) {
                case SHARED_SERVICE: {
                    Process sharedService = this.sharedServices.get(system.getProcessKey(pd));
                    if (sharedService == null && !TASystemLauncher.isProcessRunning(UtilsText.safeString((String)system.getPath(pd.type.name())))) {
                        sharedService = TASystemLauncher.createProcess(pd, UtilsText.safeString((String)system.getPath(pd.type.name())), false, params, null);
                        this.sharedServices.put(system.getProcessKey(pd), sharedService);
                    }
                    if (sharedService == null) break;
                    services.put(system.getProcessKey(pd), sharedService);
                    break;
                }
                case SERVICE: {
                    Process service = TASystemLauncher.createProcess(pd, UtilsText.safeString((String)system.getPath(pd.type.name())), false, params, null);
                    services.put(system.getProcessKey(pd), service);
                    break;
                }
                case TRANSIENT: {
                    transientPD = pd;
                    transientPath = system.getPath(transientPD.type.name());
                }
            }
            ++n2;
        }
        return new TASystemInstance(system, services, params, transientPD, UtilsText.safeString(transientPath));
    }

    public synchronized void destroyServices() {
        for (TASystemInstance tASystemInstance : this.systemsInUse.values()) {
            TASystem sys = tASystemInstance.getSystem();
            TASystemDescriptor.TAProcessDescriptor[] tAProcessDescriptorArray = sys.getDescriptor().processes;
            int n = sys.getDescriptor().processes.length;
            int n2 = 0;
            while (n2 < n) {
                TASystemDescriptor.TAProcessDescriptor pd = tAProcessDescriptorArray[n2];
                if (pd.mode == TASystemDescriptor.TAProcessMode.SERVICE) {
                    String processKey = sys.getProcessKey(pd);
                    String execPath = TASystem.getExecPath(processKey);
                    String execName = new File(execPath).getName();
                    Process process = tASystemInstance.getService(sys.getProcessKey(pd));
                    ProcessDestroyer.destroy(execName, process, null);
                }
                ++n2;
            }
        }
        for (Map.Entry entry : this.sharedServices.entrySet()) {
            String sharedServiceKey = (String)entry.getKey();
            Process process = (Process)entry.getValue();
            String execPath = TASystem.getExecPath(sharedServiceKey);
            String execName = new File(execPath).getName();
            ProcessDestroyer.destroy(execName, process, null);
        }
    }

    public synchronized boolean isInUse(TASystem system) {
        String sysId = system.getSystemId();
        TASystemInstance sysInUseList = this.systemsInUse.get(sysId);
        return sysInUseList != null;
    }

    public synchronized void remove(TASystem system) {
        TASystemDescriptor.TAProcessDescriptor[] tAProcessDescriptorArray = system.getDescriptor().processes;
        int n = system.getDescriptor().processes.length;
        int n2 = 0;
        while (n2 < n) {
            TASystemDescriptor.TAProcessDescriptor pd = tAProcessDescriptorArray[n2];
            if (pd.mode == TASystemDescriptor.TAProcessMode.SERVICE) {
                Process process = this.sharedServices.remove(system.getProcessKey(pd));
            }
            ++n2;
        }
    }
}

