/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.mem.validation.listeners;

import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.common.utils.logging.LogManager;
import com.nxp.swtools.mem.validation.model.VPresentationModel;
import com.nxp.swtools.mem.validation.model.presenter.VScenarioPresentation;
import com.nxp.swtools.mem.validation.model.presenter.VStagePresentation;
import com.nxp.swtools.mem.validation.model.presenter.ValidationPresentationModel;
import com.nxp.swtools.mem.validation.model.scripts.VScriptConfig;
import com.nxp.swtools.mem.validation.model.scripts.VScriptParamValue;
import com.nxp.swtools.mem.validation.ui.CustomText;
import java.util.Objects;
import java.util.logging.Logger;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.widgets.Text;

public class DecSizeIntegerParamKeyListener
implements KeyListener,
ModifyListener {
    protected static final Logger LOGGER = LogManager.getLogger(DecSizeIntegerParamKeyListener.class);
    private static final String KB_SIZE = "KB";
    private static final String MB_SIZE = "MB";
    private static final String GB_SIZE = "GB";
    private VPresentationModel data;

    public DecSizeIntegerParamKeyListener(VPresentationModel data) {
        this.data = data;
    }

    private void checkKeyPressed(KeyEvent event, String sizeValue, int sizeValueLength, int cursorPosition, @Nullable String selectionText, int selectionStart, int selectionCount) {
        switch (event.keyCode) {
            case 8: 
            case 127: 
            case 262144: 
            case 0x1000003: 
            case 0x1000004: 
            case 0x1000007: 
            case 0x1000008: {
                event.doit = true;
                break;
            }
            default: {
                if (event.character == '0' && cursorPosition != 0 || event.character >= '1' && event.character <= '9') {
                    event.doit = true;
                    if (selectionText != null || selectionCount <= 0) {
                        this.checkValue(event, String.valueOf(sizeValue.substring(0, selectionStart)) + event.character + sizeValue.substring(selectionStart + selectionCount, sizeValueLength));
                        break;
                    }
                    this.checkValue(event, String.valueOf(sizeValue.substring(0, cursorPosition)) + event.character + sizeValue.substring(cursorPosition, sizeValueLength));
                    break;
                }
                event.doit = false;
            }
        }
    }

    public void checkValue(KeyEvent event, @Nullable String strValue) {
        Text text = (Text)event.widget;
        CustomText customText = (CustomText)text.getParent();
        if (customText != null) {
            VScriptParamValue model = (VScriptParamValue)customText.getData("qcs.validation.ddr.model");
            long value = this.getLongValue(strValue);
            if (model != null) {
                if (value != -1L) {
                    model.setValue("" + this.getBytesSize(customText, value));
                } else {
                    model.setValue("" + value);
                }
            }
        }
    }

    public long getBytesSize(CustomText customText, long value) {
        String currentState = customText.getState();
        if (currentState != null) {
            if (currentState.equals(KB_SIZE)) {
                return value << 10;
            }
            if (currentState.equals(MB_SIZE)) {
                return value << 20;
            }
            if (currentState.equals(GB_SIZE)) {
                return value << 30;
            }
        }
        return value;
    }

    public VPresentationModel getData() {
        return this.data;
    }

    public long getLongValue(@Nullable String strValue) {
        long value = -1L;
        try {
            value = Long.decode(Objects.requireNonNull(strValue));
        }
        catch (NumberFormatException e) {
            LOGGER.info(e.getMessage());
        }
        return value;
    }

    public void keyPressed(@Nullable KeyEvent event) {
        if (event == null) {
            return;
        }
        Text text = (Text)event.widget;
        String sizeValue = text.getText();
        int sizeValueLength = sizeValue.length();
        int cursorPosition = text.getSelection().x;
        String selectionText = text.getSelectionText();
        int selectionStart = text.getSelection().x;
        int selectionCount = text.getSelectionCount();
        this.checkKeyPressed(event, sizeValue, sizeValueLength, cursorPosition, selectionText, selectionStart, selectionCount);
    }

    public void keyReleased(@Nullable KeyEvent event) {
    }

    public void modifyText(@Nullable ModifyEvent event) {
        if (event == null) {
            return;
        }
        Text text = (Text)event.widget;
        CustomText customText = (CustomText)text.getParent();
        if (customText != null) {
            VScriptConfig scriptConfig;
            VScriptParamValue model = (VScriptParamValue)customText.getData("qcs.validation.ddr.model");
            VScenarioPresentation selectedScenario = this.data.getSelectedScenario();
            ValidationPresentationModel validation = this.data.getValidationModel();
            if (selectedScenario != null && validation != null && model != null && (scriptConfig = selectedScenario.getSelectedScriptConfig()) != null) {
                VStagePresentation selectedStage;
                long value = this.getLongValue(text.getText());
                model.setValue(this.getBytesSize(customText, value));
                this.data.validateScript(scriptConfig);
                if (!this.getData().getSkipSync() && (selectedStage = validation.getSelectedStage()) != null && selectedStage.getSyncScriptConfig()) {
                    selectedStage.syncModifiedParam(model, this.data);
                }
                this.data.validateSelectedScriptConfig();
            }
        }
    }
}

