/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.mem.validation.listeners;

import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.common.utils.text.UtilsText;
import com.nxp.swtools.mem.validation.Messages;
import com.nxp.swtools.mem.validation.model.VPresentationModel;
import com.nxp.swtools.mem.validation.model.VRunResult;
import com.nxp.swtools.mem.validation.model.presenter.VScenarioPresentation;
import com.nxp.swtools.mem.validation.ui.CellLogsView;
import com.nxp.swtools.mem.validation.utils.TestResultsLogger;
import java.io.File;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;

public class TestLogsComboSelectionListener
implements ISelectionChangedListener {
    private VPresentationModel data;

    public TestLogsComboSelectionListener(VPresentationModel data) {
        this.data = data;
    }

    public void selectionChanged(@Nullable SelectionChangedEvent event) {
        if (event == null) {
            return;
        }
        VScenarioPresentation scenData = this.data.getSelectedScenario();
        CellLogsView logsView = this.data.getView().getCellLogsView();
        if (logsView == null) {
            return;
        }
        StructuredSelection sel = (StructuredSelection)event.getSelection();
        VRunResult runResult = (VRunResult)sel.getFirstElement();
        if (runResult != null) {
            String logFilePath = null;
            logFilePath = runResult.getType() == VRunResult.ResultType.PHY ? TestResultsLogger.getPhyTrainingLogFilePath(runResult.getParamVariation()) : TestResultsLogger.getLogFilePath(runResult);
            File logFile = new File(logFilePath);
            if (logFile.exists()) {
                if (scenData != null && scenData.showAllLogs()) {
                    String logText = TestResultsLogger.loadFile(logFile);
                    logText = UtilsText.safeString((String)logText);
                    logsView.setLogText(logText);
                    logsView.setLogsComboEnabled(false);
                } else {
                    String logPart = null;
                    logPart = runResult.getType() != VRunResult.ResultType.SKIPPED ? TestResultsLogger.getLogPart(logFile, runResult) : Messages.LOG_NOT_GENERATED_TEST_SKIPPED;
                    logsView.setLogsComboEnabled(true);
                    logPart = UtilsText.safeString((String)logPart);
                    logsView.setLogText(logPart);
                }
            } else {
                logsView.setLogText(Messages.LOG_DOES_NOT_EXIST);
            }
        } else {
            logsView.setLogText("");
            if (scenData != null) {
                logsView.setLogsComboEnabled(!scenData.showAllLogs());
            }
        }
    }
}

