/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.mem.validation.lproviders;

import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.mem.validation.Activator;
import com.nxp.swtools.mem.validation.Messages;
import com.nxp.swtools.mem.validation.model.IProgressIndicator;
import com.nxp.swtools.mem.validation.model.scenarios.IScenarioElement;
import com.nxp.swtools.mem.validation.model.scenarios.VScenario;
import com.nxp.swtools.mem.validation.model.scenarios.VScenarioGroup;
import com.nxp.swtools.mem.validation.utils.MathUtils;
import java.util.Objects;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.swt.graphics.Image;

public class StageTreeLabelProvider
implements ITableLabelProvider {
    @Nullable
    private IProgressIndicator progressIndicator;

    public void addListener(@Nullable ILabelProviderListener listener) {
    }

    public void dispose() {
    }

    public @Nullable Image getColumnImage(@Nullable Object element, int columnIndex) {
        if (columnIndex == 0) {
            if (element instanceof VScenario) {
                VScenario scenario = (VScenario)element;
                if (scenario.isSingleTableScenario()) {
                    return Activator.getDefault().getImage("platform:/plugin/org.eclipse.ui/icons/full/eview16/prop_ps.png");
                }
                return Activator.getDefault().getImage("datasheetx_s.gif");
            }
            if (element instanceof VScenarioGroup) {
                return Activator.getDefault().getImage("platform:/plugin/org.eclipse.ui/icons/full/obj16/fldr_obj.png");
            }
        }
        if (columnIndex == 1 && element instanceof VScenario) {
            VScenario scenario = (VScenario)element;
            switch (scenario.getCompoundState()) {
                case FAILED: 
                case CANCELLED: {
                    return Activator.getDefault().getImage("fail.png");
                }
                case PASSED: {
                    return Activator.getDefault().getImage("ok.png");
                }
                case PAUSED: {
                    return Activator.getDefault().getImage("platform:/plugin/org.eclipse.ui.navigator/icons/full/clcl16/pause.png");
                }
                case RUNNING: {
                    return Activator.getDefault().getImage("running.png");
                }
                case CLEAN: 
                case NOT_QUEUED: {
                    return null;
                }
            }
            assert (false) : Messages.StageTreeLabelProvider_UnexpectedScenario;
        }
        return null;
    }

    public String getColumnText(@Nullable Object element, int columnIndex) {
        VScenario scenario;
        if (columnIndex == 0 && element != null && element instanceof IScenarioElement) {
            return Objects.requireNonNull(((IScenarioElement)element).getName());
        }
        if (columnIndex == 1 && element != null && element instanceof VScenario && (scenario = (VScenario)element).isSelected()) {
            switch (scenario.getCompoundState()) {
                case CLEAN: {
                    return Messages.StageTreeLabelProvider_ZeroPercent;
                }
                case NOT_QUEUED: {
                    return Messages.StageTreeLabelProvider_ZeroPercent;
                }
                case FAILED: {
                    return Messages.StageTreeLabelProvider_HundredPercent;
                }
                case PASSED: {
                    return Messages.StageTreeLabelProvider_HundredPercent;
                }
                case RUNNING: 
                case CANCELLED: 
                case PAUSED: {
                    double crtPercent = 0.0;
                    if (this.progressIndicator != null) {
                        crtPercent = MathUtils.round(this.progressIndicator.getProgress(), 2);
                    }
                    return String.valueOf(crtPercent) + Messages.StageTreeLabelProvider_Percent;
                }
            }
        }
        return "";
    }

    public boolean isLabelProperty(@Nullable Object element, @Nullable String property) {
        return false;
    }

    public void removeListener(@Nullable ILabelProviderListener listener) {
    }

    public void setProgressIndicator(IProgressIndicator _progressIndicator) {
        this.progressIndicator = _progressIndicator;
    }
}

