/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.mem.validation.model.presenter;

import com.nxp.annotation.Nullable;
import com.nxp.swtools.common.utils.logging.LogManager;
import com.nxp.swtools.mem.validation.IDiagsProvider;
import com.nxp.swtools.mem.validation.Messages;
import com.nxp.swtools.mem.validation.config.ValidationContext;
import com.nxp.swtools.mem.validation.model.VRunResult;
import com.nxp.swtools.mem.validation.model.presenter.IDisplayFigure;
import com.nxp.swtools.mem.validation.model.presenter.VDiagsChartsFigure;
import com.nxp.swtools.mem.validation.model.presenter.VStagePresentation;
import com.nxp.swtools.mem.validation.model.presenter.VTableScenarioPresentation;
import com.nxp.swtools.mem.validation.model.scenarios.VScenario;
import com.nxp.swtools.mem.validation.model.scenarios.VTable;
import com.nxp.swtools.mem.validation.model.scenarios.VTableGroup;
import com.nxp.swtools.mem.validation.table.params.VParamVariation;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Canvas;

public class VDiagsPresentation
extends VTableScenarioPresentation {
    protected static final Logger LOGGER = LogManager.getLogger(VDiagsPresentation.class);
    protected Map<String, IDisplayFigure> diagFiguresMap = new HashMap<String, IDisplayFigure>();
    protected Map<String, Point> diagFiguresPosMap = new HashMap<String, Point>();
    protected IDisplayFigure @Nullable [][] diagFigures;
    protected IDisplayFigure @Nullable [][] diagOverFigures;
    protected Map<String, IDisplayFigure> diagOverFiguresMap = new HashMap<String, IDisplayFigure>();

    public VDiagsPresentation(VScenario _model, VStagePresentation _parent) {
        super(_model, _parent);
        IDiagsProvider diagsProvider;
        VTableGroup[] tableGroups = this.model.getTableGroups();
        if (tableGroups != null) {
            VDiagsChartsFigure[][] crtTableFigures = new VDiagsChartsFigure[tableGroups.length][];
            int i = 0;
            while (i < crtTableFigures.length) {
                VTableGroup tableGrp = tableGroups[i];
                VTable[] tables = tableGrp.getTables();
                crtTableFigures[i] = new VDiagsChartsFigure[tables.length];
                int j = 0;
                while (j < tables.length) {
                    VDiagsChartsFigure tableFigure;
                    crtTableFigures[i][j] = tableFigure = new VDiagsChartsFigure(tables[j]);
                    this.diagFiguresMap.put(tables[j].getId(), tableFigure);
                    this.diagFiguresPosMap.put(tables[j].getId(), new Point(i, j));
                    ++j;
                }
                ++i;
            }
            this.diagFigures = crtTableFigures;
        }
        if ((diagsProvider = ValidationContext.getInstance().getDiagsProvider()) != null) {
            diagsProvider.populateOverlappedChartsFigures(this.model, this);
        }
        try {
            this.makeDefaultSelections();
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, "Exception on <validation-stage> parsing.", e);
        }
    }

    @Override
    public void draw(PaintEvent e, boolean highlight) {
        String sourceTabName;
        Canvas source;
        if (e.getSource() instanceof Canvas && (source = (Canvas)e.getSource()).getData() instanceof String && (sourceTabName = (String)source.getData()) != null) {
            if (sourceTabName.equals(Messages.RESULTS_TAB_NAME)) {
                super.draw(e, highlight);
            } else {
                this.drawDiagCharts(e);
            }
        }
    }

    private void drawDiagCharts(PaintEvent e) {
        if (this.diagFigures != null) {
            IDisplayFigure[][] iDisplayFigureArray = this.diagFigures;
            int n = this.diagFigures.length;
            int n2 = 0;
            while (n2 < n) {
                IDisplayFigure[] tablesRow;
                IDisplayFigure[] iDisplayFigureArray2 = tablesRow = iDisplayFigureArray[n2];
                int n3 = tablesRow.length;
                int n4 = 0;
                while (n4 < n3) {
                    VRunResult[] res;
                    IDisplayFigure chart = iDisplayFigureArray2[n4];
                    Point selCell = new Point(-1, -1);
                    VParamVariation param = chart.getModel().getParamVariation(new Point(0, 0));
                    if (param != null && (res = param.getResults()) != null) {
                        chart.draw(e, selCell, this.parent.getParent().isHighlight(), res.length);
                    }
                    ++n4;
                }
                ++n2;
            }
        }
    }

    public @Nullable VDiagsChartsFigure getChartAt() {
        if (this.diagFigures != null) {
            IDisplayFigure[][] iDisplayFigureArray = this.diagFigures;
            int n = this.diagFigures.length;
            int n2 = 0;
            while (n2 < n) {
                IDisplayFigure[] diagFiguresRow;
                IDisplayFigure[] iDisplayFigureArray2 = diagFiguresRow = iDisplayFigureArray[n2];
                int n3 = diagFiguresRow.length;
                int n4 = 0;
                while (n4 < n3) {
                    IDisplayFigure diagFigure = iDisplayFigureArray2[n4];
                    if (diagFigure.getModel().isVisible()) {
                        return (VDiagsChartsFigure)diagFigure;
                    }
                    ++n4;
                }
                ++n2;
            }
        }
        return null;
    }

    public @Nullable IDisplayFigure getChart() {
        if (this.diagOverFigures != null) {
            IDisplayFigure[][] iDisplayFigureArray = this.diagOverFigures;
            int n = this.diagOverFigures.length;
            int n2 = 0;
            while (n2 < n) {
                IDisplayFigure[] diagFiguresRow;
                IDisplayFigure[] iDisplayFigureArray2 = diagFiguresRow = iDisplayFigureArray[n2];
                int n3 = diagFiguresRow.length;
                int n4 = 0;
                while (n4 < n3) {
                    IDisplayFigure diagFigure = iDisplayFigureArray2[n4];
                    if (diagFigure.getModel().isVisible()) {
                        return diagFigure;
                    }
                    ++n4;
                }
                ++n2;
            }
        }
        return null;
    }

    @Override
    public void updateCellContents(VParamVariation cell) {
        IDisplayFigure diagOverFig;
        super.updateCellContents(cell);
        IDisplayFigure diagFigure = this.diagFiguresMap.get(cell.getParent().getId());
        if (diagFigure != null) {
            diagFigure.updateCellContents(cell);
        }
        if ((diagOverFig = this.diagOverFiguresMap.get(cell.getParent().getId())) != null) {
            diagOverFig.updateCellContents(cell);
        }
    }

    @Override
    public void setRunningCell(VTable table, VParamVariation cell) {
        IDisplayFigure diagOverFig;
        super.setRunningCell(table, cell);
        IDisplayFigure diagFig = this.diagFiguresMap.get(table.getId());
        if (diagFig != null) {
            diagFig.setRunningCell(cell);
        }
        if ((diagOverFig = this.diagOverFiguresMap.get(table.getId())) != null) {
            diagOverFig.setRunningCell(cell);
        }
    }

    public void setDiagOverFigures(IDisplayFigure @Nullable [][] diagOverFig) {
        this.diagOverFigures = diagOverFig;
    }

    public Map<String, IDisplayFigure> getDiagOverFiguresMap() {
        return this.diagOverFiguresMap;
    }
}

