/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.mem.validation.model.presenter;

import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.common.utils.logging.LogManager;
import com.nxp.swtools.mem.validation.Activator;
import com.nxp.swtools.mem.validation.model.VPresentationModel;
import com.nxp.swtools.mem.validation.model.presenter.IDisplayFigure;
import com.nxp.swtools.mem.validation.model.presenter.JSPresentation;
import com.nxp.swtools.mem.validation.model.presenter.VDiagsPresentation;
import com.nxp.swtools.mem.validation.model.presenter.VScenarioPresentation;
import com.nxp.swtools.mem.validation.model.presenter.VTableScenarioPresentation;
import com.nxp.swtools.mem.validation.model.presenter.ValidationPresentationModel;
import com.nxp.swtools.mem.validation.model.scenarios.IScenarioElement;
import com.nxp.swtools.mem.validation.model.scenarios.VScenario;
import com.nxp.swtools.mem.validation.model.scenarios.VScenarioGroup;
import com.nxp.swtools.mem.validation.model.scenarios.VStage;
import com.nxp.swtools.mem.validation.model.scenarios.VTable;
import com.nxp.swtools.mem.validation.model.scenarios.VTableGroup;
import com.nxp.swtools.mem.validation.model.scripts.VScriptConfig;
import com.nxp.swtools.mem.validation.model.scripts.VScriptParamValue;
import com.nxp.swtools.mem.validation.table.params.VParamVariation;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class VStagePresentation {
    private static final Logger LOGGER = LogManager.getLogger(VStagePresentation.class);
    private ValidationPresentationModel parent;
    private VStage model;
    private Map<String, VScenarioPresentation> scenarioFigureMap = new HashMap<String, VScenarioPresentation>();
    @Nullable
    private IScenarioElement selElem = null;
    @Nullable
    private VScenario selScenario = null;
    @Nullable
    private VScenarioPresentation selScenarioFig = null;
    private boolean autoSelected = false;
    private boolean syncScriptConfigs = false;
    private int numSelections = 0;
    private AtomicBoolean countEditing = new AtomicBoolean(false);

    private static boolean hasVisibleScenarios(IScenarioElement[] elems) {
        if (elems == null) {
            return false;
        }
        IScenarioElement[] iScenarioElementArray = elems;
        int n = elems.length;
        int n2 = 0;
        while (n2 < n) {
            IScenarioElement elem = iScenarioElementArray[n2];
            if (elem instanceof VScenarioGroup && ((VScenarioGroup)elem).isVisible()) {
                return true;
            }
            if (elem instanceof VScenario && ((VScenario)elem).isVisible()) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private static void trace(String message) {
        LOGGER.warning(message);
    }

    public VStagePresentation(ValidationPresentationModel _parent, VStage _model) {
        IScenarioElement[] scenarioElems;
        this.parent = _parent;
        this.model = _model;
        IScenarioElement[] iScenarioElementArray = scenarioElems = this.model.getScenarioElements();
        int n = scenarioElems.length;
        int n2 = 0;
        while (n2 < n) {
            IScenarioElement scenarioElem = iScenarioElementArray[n2];
            this.createFigures(scenarioElem);
            ++n2;
        }
        this.setDefaultScenario();
    }

    public boolean cleanupAllScenarios() {
        return this.cleanupScenarios(this.model.getScenarios(), false, false);
    }

    public boolean cleanupScenarios(VScenario[] scenarios, boolean filterSelected, boolean filterVisible) {
        String logsDirPath = Activator.getDefault().getConfigManager().getLogsFolder();
        File logsDir = new File(Objects.requireNonNull(logsDirPath));
        if (!logsDir.exists()) {
            VStagePresentation.trace("WARNING: Missing logs dir for DDRV!!!");
            return false;
        }
        boolean success = true;
        VScenario[] vScenarioArray = scenarios;
        int n = scenarios.length;
        int n2 = 0;
        while (n2 < n) {
            VScenario scenario = vScenarioArray[n2];
            VTableGroup[] tableGroups = scenario.getTableGroups();
            if (tableGroups != null) {
                VTableGroup[] vTableGroupArray = tableGroups;
                int n3 = tableGroups.length;
                int n4 = 0;
                while (n4 < n3) {
                    VTable[] tables;
                    VTableGroup tableGroup = vTableGroupArray[n4];
                    VTable[] vTableArray = tables = tableGroup.getTables();
                    int n5 = tables.length;
                    int n6 = 0;
                    while (n6 < n5) {
                        VTable table = vTableArray[n6];
                        boolean canDelete = true;
                        canDelete = filterSelected ? table.isSelected() : canDelete;
                        boolean bl = canDelete = filterVisible ? table.isVisible() : canDelete;
                        if (canDelete) {
                            String tableId = table.getId();
                            Pattern tableIdPattern = Pattern.compile(tableId);
                            File[] logFiles = logsDir.listFiles();
                            if (logFiles != null) {
                                File[] fileArray = logFiles;
                                int n7 = logFiles.length;
                                int n8 = 0;
                                while (n8 < n7) {
                                    File logFile = fileArray[n8];
                                    Matcher m = tableIdPattern.matcher(logFile.getName());
                                    if (m.find()) {
                                        success = success && logFile.delete();
                                    }
                                    ++n8;
                                }
                            }
                        }
                        ++n6;
                    }
                    ++n4;
                }
            }
            ++n2;
        }
        return success;
    }

    public boolean cleanupSelectedScenarios() {
        VScenario[] selectedScenarios = this.model.extractSelectedScenarios();
        return this.cleanupScenarios(selectedScenarios, true, true);
    }

    private void createFigures(IScenarioElement elem) {
        if (elem instanceof VScenarioGroup) {
            IScenarioElement[] children;
            IScenarioElement[] iScenarioElementArray = children = elem.getChildren();
            int n = children.length;
            int n2 = 0;
            while (n2 < n) {
                IScenarioElement child = iScenarioElementArray[n2];
                if (child instanceof VScenarioGroup) {
                    this.createFigures(child);
                }
                if (child instanceof VScenario) {
                    this.createScenarioFigure((VScenario)child);
                }
                ++n2;
            }
        } else if (elem instanceof VScenario) {
            this.createScenarioFigure((VScenario)elem);
        }
    }

    private void createScenarioFigure(VScenario scenario) {
        VTableScenarioPresentation scenarioFigure = scenario.isDiagsEye() ? new VDiagsPresentation(scenario, this) : (scenario.getName().contains("Lane") ? new JSPresentation(scenario, this) : new VTableScenarioPresentation(scenario, this));
        this.scenarioFigureMap.put(scenario.getId(), scenarioFigure);
    }

    public void decrementNumSelections() {
        --this.numSelections;
    }

    public @Nullable VScenarioPresentation getFigure(@Nullable IScenarioElement scenarioElem) {
        if (scenarioElem instanceof VScenario) {
            return this.scenarioFigureMap.get(scenarioElem.getId());
        }
        return null;
    }

    public VStage getModel() {
        return this.model;
    }

    public String getName() {
        return this.model.getName();
    }

    public ValidationPresentationModel getParent() {
        return this.parent;
    }

    public VTableScenarioPresentation[] getScenarios() {
        return this.scenarioFigureMap.values().toArray(new VTableScenarioPresentation[this.scenarioFigureMap.values().size()]);
    }

    public @Nullable VScenarioPresentation getSelectedScenario() {
        boolean validSelectedScenario;
        VScenario curentSelScenario = this.selScenario;
        boolean bl = validSelectedScenario = curentSelScenario != null;
        if (curentSelScenario != null && !curentSelScenario.isVisible()) {
            if (curentSelScenario.isSelected() && this.selElem != null) {
                this.parent.setSelectedScenario(this.selElem, true, false);
            }
            validSelectedScenario = false;
        }
        if (!validSelectedScenario) {
            this.setDefaultScenario();
        }
        return this.selScenarioFig;
    }

    public @Nullable VTable getSelectedScenarioTable() {
        VTableGroup[] tableGroup;
        VScenarioPresentation scenario = this.getSelectedScenario();
        if (scenario != null && (tableGroup = scenario.getModel().getTableGroups()) != null) {
            return tableGroup[0].getTables()[0];
        }
        return null;
    }

    public @Nullable VScenarioPresentation getScenarioPresentation(String scenarioName) {
        return this.scenarioFigureMap.get(scenarioName);
    }

    public @Nullable IScenarioElement getSelectedScenarioElement() {
        return this.selElem;
    }

    public boolean getSyncScriptConfig() {
        return this.syncScriptConfigs;
    }

    public boolean hasSelections() {
        VScenario[] scenarios;
        if (this.numSelections == 0) {
            return false;
        }
        VScenario[] vScenarioArray = scenarios = this.model.extractSelectedScenarios();
        int n = scenarios.length;
        int n2 = 0;
        while (n2 < n) {
            VScenario scenario = vScenarioArray[n2];
            if (scenario.hasSelections()) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public void incrementNumSelections() {
        ++this.numSelections;
    }

    public boolean isAutoSelected() {
        return this.autoSelected;
    }

    public boolean isCountEditing() {
        return this.countEditing.get();
    }

    public boolean isVisible() {
        return this.model.isVisible() && VStagePresentation.hasVisibleScenarios(this.model.getScenarioElements());
    }

    public void onUpdateTableVisibility() {
        for (VScenarioPresentation scenData : this.scenarioFigureMap.values()) {
            scenData.onUpdateTableVisibility();
        }
    }

    public void resetScenario(VScenario scenario) {
        scenario.reset();
        VScenarioPresentation scenarioFig = this.scenarioFigureMap.get(scenario.getId());
        if (scenarioFig != null) {
            scenarioFig.reset();
        }
    }

    public void resetScenarios(VScenario[] scenarios) {
        VScenario[] vScenarioArray = scenarios;
        int n = scenarios.length;
        int n2 = 0;
        while (n2 < n) {
            VScenario scenario = vScenarioArray[n2];
            this.resetScenario(scenario);
            ++n2;
        }
    }

    public void resetSelectedScenarios() {
        VScenario[] selectedScenarios = this.model.extractSelectedScenarios();
        this.resetScenarios(selectedScenarios);
    }

    private boolean selectDefaultScenario(IScenarioElement elem) {
        if (elem instanceof VScenarioGroup && ((VScenarioGroup)elem).isVisible()) {
            IScenarioElement[] iScenarioElementArray = elem.getChildren();
            int n = iScenarioElementArray.length;
            int n2 = 0;
            while (n2 < n) {
                IScenarioElement child = iScenarioElementArray[n2];
                if (this.selectDefaultScenario(child)) {
                    return true;
                }
                ++n2;
            }
        }
        if (elem instanceof VScenario && ((VScenario)elem).isVisible()) {
            this.selElem = elem;
            this.selScenario = (VScenario)elem;
            this.selScenarioFig = this.scenarioFigureMap.get(this.selScenario.getId());
            return true;
        }
        return false;
    }

    public void selectFirstRunningCell() {
        IDisplayFigure selectedTable;
        VScenarioPresentation selectedScenario = this.getSelectedScenario();
        if (selectedScenario != null && (selectedTable = selectedScenario.getSelectedTable()) != null) {
            VParamVariation[][] paramVariations;
            VScriptConfig firstSelectedScriptsConfig = selectedTable.getModel().getSelectedScriptConfigs()[0];
            VParamVariation[][] vParamVariationArray = paramVariations = selectedTable.getModel().getParamVariations();
            int n = paramVariations.length;
            int n2 = 0;
            while (n2 < n) {
                VParamVariation[] row;
                VParamVariation[] vParamVariationArray2 = row = vParamVariationArray[n2];
                int n3 = row.length;
                int n4 = 0;
                while (n4 < n3) {
                    VParamVariation cell = vParamVariationArray2[n4];
                    if (firstSelectedScriptsConfig.equals(cell.getOperationalScriptConfig())) {
                        selectedScenario.setSelectedCell(cell);
                        return;
                    }
                    ++n4;
                }
                ++n2;
            }
        }
    }

    public void setCountEditing(boolean editing) {
        this.countEditing.set(editing);
    }

    public void setParent(ValidationPresentationModel _parent) {
        this.parent = _parent;
    }

    public void setScenarioAutoSelected(boolean _autoSelected) {
        this.autoSelected = _autoSelected;
    }

    public void setSelectedScenarioElement(IScenarioElement elem) {
        this.selElem = elem;
        if (elem instanceof VScenarioGroup) {
            this.selScenario = (VScenario)elem.getChildren()[0];
            if (this.selScenario != null) {
                this.selScenarioFig = this.scenarioFigureMap.get(this.selScenario.getId());
            }
        } else {
            this.selScenario = (VScenario)elem;
            this.selScenarioFig = this.scenarioFigureMap.get(this.selScenario.getId());
        }
    }

    public List<String> getScenarioFigureKeys() {
        return new ArrayList<String>(this.scenarioFigureMap.keySet());
    }

    public void setDefaultScenario() {
        IScenarioElement[] iScenarioElementArray = this.model.getScenarioElements();
        int n = iScenarioElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            IScenarioElement scenarioElem = iScenarioElementArray[n2];
            if (this.selectDefaultScenario(scenarioElem)) break;
            ++n2;
        }
    }

    public void syncAllParams(boolean _syncScriptConfig, VPresentationModel data) {
        VScriptConfig sc;
        this.syncScriptConfigs = _syncScriptConfig;
        if (this.syncScriptConfigs && this.selScenarioFig != null && (sc = this.selScenarioFig.getSelectedScriptConfig()) != null && sc.isSelected() && this.selScenario != null) {
            VScriptConfig[] selectedScripts = this.selScenario.getSelectedScriptConfigs();
            VScriptParamValue[] vScriptParamValueArray = sc.getParamValues();
            int n = vScriptParamValueArray.length;
            int n2 = 0;
            while (n2 < n) {
                VScriptParamValue param = vScriptParamValueArray[n2];
                String paramId = param.getParam().getId();
                Object paramValue = param.getValue();
                VScriptConfig[] vScriptConfigArray = selectedScripts;
                int n3 = selectedScripts.length;
                int n4 = 0;
                while (n4 < n3) {
                    VScriptParamValue[] scriptParams;
                    VScriptConfig script = vScriptConfigArray[n4];
                    VScriptParamValue[] vScriptParamValueArray2 = scriptParams = script.getParamValues();
                    int n5 = scriptParams.length;
                    int n6 = 0;
                    while (n6 < n5) {
                        VScriptParamValue scriptParam = vScriptParamValueArray2[n6];
                        String scriptParamId = scriptParam.getParam().getId();
                        if (scriptParamId.equals(paramId)) {
                            scriptParam.setValue(paramValue);
                            data.validateScript(script);
                        }
                        ++n6;
                    }
                    ++n4;
                }
                ++n2;
            }
            this.syncScriptsConfig(sc);
        }
    }

    public void syncModifiedParam(VScriptParamValue param, VPresentationModel data) {
        VScriptConfig sc;
        if (this.syncScriptConfigs && this.selScenarioFig != null && (sc = this.selScenarioFig.getSelectedScriptConfig()) != null && sc.isSelected() && this.selScenario != null) {
            VScriptConfig[] selectedScripts = this.selScenario.getSelectedScriptConfigs();
            String modParamId = param.getParam().getId();
            Object modParamValue = param.getValue();
            VScriptConfig[] vScriptConfigArray = selectedScripts;
            int n = selectedScripts.length;
            int n2 = 0;
            while (n2 < n) {
                VScriptParamValue[] scriptParams;
                VScriptConfig script = vScriptConfigArray[n2];
                VScriptParamValue[] vScriptParamValueArray = scriptParams = script.getParamValues();
                int n3 = scriptParams.length;
                int n4 = 0;
                while (n4 < n3) {
                    VScriptParamValue scriptParam = vScriptParamValueArray[n4];
                    String scriptParamId = scriptParam.getParam().getId();
                    if (scriptParamId.equals(modParamId)) {
                        scriptParam.setValue(modParamValue);
                        data.validateScript(script);
                    }
                    ++n4;
                }
                ++n2;
            }
            this.syncScriptsConfig(sc);
        }
    }

    private void syncScriptsConfig(IScenarioElement elem, VScriptConfig sc) {
        if (elem instanceof VScenarioGroup) {
            IScenarioElement[] iScenarioElementArray = elem.getChildren();
            int n = iScenarioElementArray.length;
            int n2 = 0;
            while (n2 < n) {
                IScenarioElement child = iScenarioElementArray[n2];
                this.syncScriptsConfig(child, sc);
                ++n2;
            }
        }
        if (elem instanceof VScenario) {
            VScenario scen = (VScenario)elem;
            scen.updateScriptConfig(sc);
        }
    }

    public void syncScriptsConfig(VScriptConfig sc) {
        IScenarioElement[] iScenarioElementArray = this.model.getScenarioElements();
        int n = iScenarioElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            IScenarioElement elem = iScenarioElementArray[n2];
            this.syncScriptsConfig(elem, sc);
            ++n2;
        }
    }

    public void updateScriptConfig(VScriptConfig sc, boolean selected) {
        sc.setSelected(selected);
        if (selected && sc.getNumRuns() < 1) {
            sc.setNumRuns(1);
        }
        if (this.syncScriptConfigs) {
            this.syncScriptsConfig(sc);
        }
    }

    public void updateScriptConfig(VScriptConfig sc, int numRuns) {
        sc.setNumRuns(numRuns);
        if (this.syncScriptConfigs) {
            this.syncScriptsConfig(sc);
        }
    }
}

