/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.mem.validation.model.scenarios;

import com.nxp.annotation.Nullable;
import com.nxp.swtools.common.utils.lang.CollectionsUtils;
import com.nxp.swtools.mem.validation.IConfigProvider;
import com.nxp.swtools.mem.validation.config.ValidationContext;
import com.nxp.swtools.mem.validation.model.scenarios.IScenarioElement;
import com.nxp.swtools.mem.validation.model.scenarios.VScenario;
import com.nxp.swtools.mem.validation.model.scenarios.VScenarioGroup;
import com.nxp.swtools.mem.validation.model.scripts.VScript;
import com.nxp.swtools.mem.validation.model.scripts.VScriptConfig;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;

public class VStage {
    private String name;
    private boolean visible;
    @Nullable
    private CollectionsUtils.Pair<String, String> visibleCondition;
    private IScenarioElement[] scenarios;
    private Map<VScenario.ScenarioType, VScenario> scenarioMap = new EnumMap<VScenario.ScenarioType, VScenario>(VScenario.ScenarioType.class);

    public VStage(String name, IScenarioElement[] scenarios, @Nullable String visibleCondition) {
        this.name = name;
        this.visible = true;
        this.setVisibleCondition(visibleCondition);
        this.scenarios = (IScenarioElement[])scenarios.clone();
    }

    public VStage(VStage proto) {
        this.name = proto.name;
        this.visible = proto.visible;
        this.visibleCondition = proto.visibleCondition;
        this.scenarios = new IScenarioElement[proto.scenarios.length];
        int i = 0;
        while (i < this.scenarios.length) {
            this.scenarios[i] = proto.scenarios[i].clone(proto.scenarios[i]);
            ++i;
        }
        ArrayList<VScenario> scenList = new ArrayList<VScenario>();
        Stack<IScenarioElement> st = new Stack<IScenarioElement>();
        IScenarioElement[] iScenarioElementArray = this.scenarios;
        int n = this.scenarios.length;
        int n2 = 0;
        while (n2 < n) {
            IScenarioElement iScenarioElement = iScenarioElementArray[n2];
            st.push(iScenarioElement);
            ++n2;
        }
        while (!st.isEmpty()) {
            IScenarioElement iScenarioElement = (IScenarioElement)st.pop();
            if (iScenarioElement instanceof VScenarioGroup) {
                IScenarioElement[] iScenarioElementArray2 = ((VScenarioGroup)iScenarioElement).children;
                int n3 = ((VScenarioGroup)iScenarioElement).children.length;
                n = 0;
                while (n < n3) {
                    IScenarioElement child = iScenarioElementArray2[n];
                    st.push(child);
                    ++n;
                }
                continue;
            }
            if (!(iScenarioElement instanceof VScenario)) continue;
            scenList.add((VScenario)iScenarioElement);
        }
        for (VScenario vScenario : scenList) {
            VScenario.ScenarioType[] scenarioTypeArray = VScenario.ScenarioType.values();
            int n3 = scenarioTypeArray.length;
            int n5 = 0;
            while (n5 < n3) {
                VScenario.ScenarioType type = scenarioTypeArray[n5];
                if (type.name.equals(vScenario.getName())) {
                    CollectionsUtils.Pair<String, String> condition = vScenario.getVisibleCondition();
                    if (condition != null) {
                        String propertyValue;
                        IConfigProvider configController = ValidationContext.getInstance().getConfigController();
                        if (configController != null && (propertyValue = configController.getPropertyEnumId((String)condition.getFirst())) != null && propertyValue.equals(condition.getSecond())) {
                            this.scenarioMap.put(type, vScenario);
                        }
                    } else {
                        this.scenarioMap.put(type, vScenario);
                    }
                }
                ++n5;
            }
        }
    }

    public VScenario[] extractSelectedScenarios() {
        ArrayList<VScenario> selScenList = new ArrayList<VScenario>();
        IScenarioElement[] iScenarioElementArray = this.scenarios;
        int n = this.scenarios.length;
        int n2 = 0;
        while (n2 < n) {
            IScenarioElement elem = iScenarioElementArray[n2];
            this.gatherSelectedScenarios(elem, selScenList);
            ++n2;
        }
        return selScenList.toArray(new VScenario[selScenList.size()]);
    }

    private void gatherSelectedScenarios(IScenarioElement elem, List<VScenario> scenarios) {
        VScenario scenario;
        if (elem instanceof VScenario && (scenario = (VScenario)elem).isSelected()) {
            scenarios.add((VScenario)elem);
        }
        if (elem instanceof VScenarioGroup) {
            IScenarioElement[] iScenarioElementArray = elem.getChildren();
            int n = iScenarioElementArray.length;
            int n2 = 0;
            while (n2 < n) {
                IScenarioElement child = iScenarioElementArray[n2];
                this.gatherSelectedScenarios(child, scenarios);
                ++n2;
            }
        }
    }

    public String getName() {
        return this.name;
    }

    public @Nullable VScenario getScenario(VScenario.ScenarioType type) {
        return this.scenarioMap.get((Object)type);
    }

    public IScenarioElement[] getScenarioElements() {
        return (IScenarioElement[])this.scenarios.clone();
    }

    public VScenario[] getScenarios() {
        return this.getScenarios(false);
    }

    public VScenario[] getScenarios(boolean onlyVisibleOnes) {
        ArrayList<VScenario> sList = new ArrayList<VScenario>();
        IScenarioElement[] iScenarioElementArray = this.scenarios;
        int n = this.scenarios.length;
        int n2 = 0;
        while (n2 < n) {
            IScenarioElement scenElem = iScenarioElementArray[n2];
            if (scenElem instanceof VScenario) {
                if (!onlyVisibleOnes || ((VScenario)scenElem).isVisible()) {
                    sList.add((VScenario)scenElem);
                }
            } else if (scenElem instanceof VScenarioGroup && (!onlyVisibleOnes || ((VScenarioGroup)scenElem).isVisible())) {
                VScenario[] scens;
                VScenario[] vScenarioArray = scens = this.getScenarios((VScenarioGroup)scenElem, onlyVisibleOnes);
                int n3 = scens.length;
                int n4 = 0;
                while (n4 < n3) {
                    VScenario scen = vScenarioArray[n4];
                    sList.add(scen);
                    ++n4;
                }
            }
            ++n2;
        }
        return sList.toArray(new VScenario[sList.size()]);
    }

    private VScenario[] getScenarios(VScenarioGroup parent, boolean onlyVisibleOnes) {
        ArrayList<VScenario> sList = new ArrayList<VScenario>();
        IScenarioElement[] iScenarioElementArray = parent.getChildren();
        int n = iScenarioElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            IScenarioElement scenElem = iScenarioElementArray[n2];
            if (scenElem instanceof VScenario) {
                if (!onlyVisibleOnes || ((VScenario)scenElem).isVisible()) {
                    sList.add((VScenario)scenElem);
                }
            } else if (scenElem instanceof VScenarioGroup && (!onlyVisibleOnes || ((VScenarioGroup)scenElem).isVisible())) {
                VScenario[] scens;
                VScenario[] vScenarioArray = scens = this.getScenarios((VScenarioGroup)scenElem, onlyVisibleOnes);
                int n3 = scens.length;
                int n4 = 0;
                while (n4 < n3) {
                    VScenario scen = vScenarioArray[n4];
                    sList.add(scen);
                    ++n4;
                }
            }
            ++n2;
        }
        return sList.toArray(new VScenario[sList.size()]);
    }

    public IScenarioElement[] getVisibleScenarioElements() {
        ArrayList<IScenarioElement> sList = new ArrayList<IScenarioElement>();
        IScenarioElement[] iScenarioElementArray = this.scenarios;
        int n = this.scenarios.length;
        int n2 = 0;
        while (n2 < n) {
            IScenarioElement elem = iScenarioElementArray[n2];
            if (elem.isVisible()) {
                sList.add(elem);
            }
            ++n2;
        }
        return sList.toArray(new IScenarioElement[sList.size()]);
    }

    public VScenario[] getVisibleScenarios() {
        return this.getScenarios(true);
    }

    public boolean isVisible() {
        return this.visible;
    }

    private boolean safeToDelete(IScenarioElement elem, VScript script) {
        if (elem instanceof VScenario) {
            VScenario scenario = (VScenario)elem;
            for (VScriptConfig sc : scenario.getScriptsConfig()) {
                if (sc.getScript() != script || !sc.isSelected()) continue;
                return false;
            }
        }
        if (elem instanceof VScenarioGroup) {
            boolean safeToDelete = true;
            IScenarioElement[] iScenarioElementArray = elem.getChildren();
            int n = iScenarioElementArray.length;
            int n2 = 0;
            while (n2 < n) {
                IScenarioElement child = iScenarioElementArray[n2];
                boolean bl = safeToDelete = safeToDelete && this.safeToDelete(child, script);
                if (!safeToDelete) break;
                ++n2;
            }
            return safeToDelete;
        }
        return true;
    }

    public boolean safeToDelete(VScript script) {
        boolean safeToDelete = true;
        IScenarioElement[] iScenarioElementArray = this.scenarios;
        int n = this.scenarios.length;
        int n2 = 0;
        while (n2 < n) {
            IScenarioElement elem = iScenarioElementArray[n2];
            boolean bl = safeToDelete = safeToDelete && this.safeToDelete(elem, script);
            if (!safeToDelete) {
                return safeToDelete;
            }
            ++n2;
        }
        return safeToDelete;
    }

    public void setVisible(boolean visible) {
        this.visible = visible;
    }

    public void setVisibleCondition(@Nullable String visibleCond) {
        this.visibleCondition = null;
        if (visibleCond != null) {
            String[] visibleCondArray = visibleCond.split("=");
            if (visibleCondArray == null || visibleCondArray.length != 2) {
                return;
            }
            this.visibleCondition = new CollectionsUtils.Pair((Object)visibleCondArray[0], (Object)visibleCondArray[1]);
        }
    }

    public // Could not load outer class - annotation placement on inner may be incorrect
     @Nullable CollectionsUtils.Pair<String, String> getVisibleCondition() {
        return this.visibleCondition;
    }

    public boolean isShmooType() {
        return this.name.equals(StageType.SHMOO.getName());
    }

    public static enum StageType {
        VALIDATION("Validation"),
        MARGINS("Margins"),
        UBOOT("U-Boot"),
        DIAGS("Diags"),
        SHMOO("Shmoo");

        public final String name;

        private StageType(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }
    }
}

