/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.mem.validation.model.scenarios;

import com.nxp.swtools.common.utils.NonNull;
import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.common.utils.logging.LogManager;
import com.nxp.swtools.mem.validation.IConfigProvider;
import com.nxp.swtools.mem.validation.config.ValidationContext;
import com.nxp.swtools.mem.validation.model.ParserUtility;
import com.nxp.swtools.mem.validation.model.scenarios.Tables;
import com.nxp.swtools.mem.validation.model.scenarios.VTable;
import com.nxp.swtools.mem.validation.model.scenarios.VTableOptions;
import com.nxp.swtools.mem.validation.model.scripts.Scripts;
import com.nxp.swtools.mem.validation.model.scripts.VScript;
import com.nxp.swtools.mem.validation.model.scripts.VScriptConfig;
import com.nxp.swtools.mem.validation.model.scripts.VScriptConfigBuilder;
import com.nxp.swtools.mem.validation.table.params.BeanPropertyParam;
import com.nxp.swtools.mem.validation.table.params.ParamBuilder;
import com.nxp.swtools.mem.validation.table.params.VParam;
import com.nxp.swtools.mem.validation.table.params.VPrerequisiteSetting;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class VTableParser {
    protected static final Logger LOGGER = LogManager.getLogger(VTableParser.class);
    public static final String TAG_VTABLES = "validation-tables";
    public static final String TAG_VTABLE = "validation-table";
    public static final String TAG_OPTIONS = "options";
    public static final String TAG_ID = "id";
    public static final String TAG_NAME = "name";
    public static final String TAG_DESCRIPTION = "description";
    public static final String TAG_HORIZONTAL_LABEL = "horizontal-label";
    public static final String TAG_VERTICAL_LABEL = "vertical-label";
    public static final String TAG_CONDITION = "condition";
    public static final String TAG_SHOW_SCRIPTS = "show-scripts";
    public static final String TAG_SHOW_LOGS = "show-logs";
    public static final String TAG_SHOW_EXTRA = "show-extra";
    public static final String TAG_SHOW_OPTIONS = "show-options";
    public static final String TAG_ALLOW_USER_VARIATION = "allow-user-variation";
    public static final String TAG_ALLOW_CELL_SKIP = "allow-cell-skip";
    public static final String TAG_ALLOW_TABLE_SKIP = "allow-table-skip";
    public static final String TAG_PRECOMPUTE_GOLDEN_CELL = "precompute-golden-cell";
    public static final String TAG_DISPLAY_RESULTS_TYPE = "display-results-type";
    public static final String TAG_APPLY_DEFAULT_VALUES = "apply-default-param-values";
    public static final String TAG_APPLY_CELL_CUSTOM_DATA = "apply-cell-custom-data";
    public static final String TAG_PARAMS = "params";
    public static final String TAG_PARAM = "param";
    public static final String TAG_TYPE = "type";
    public static final String TAG_ORIENTATION = "orientation";
    public static final String TAG_DYNAMIC = "dynamic";
    public static final String TAG_PATTERN = "pattern";
    public static final String TAG_PREFIX = "prefix";
    public static final String TAG_POSTFIX = "postfix";
    public static final String TAG_SYMBOLS = "symbols";
    public static final String TAG_SYMBOL = "symbol";
    public static final String TAG_MEM_TYPE = "selected_mode";
    public static final String TAG_VALUES = "values";
    public static final String TAG_VALUE = "value";
    public static final String TAG_EXCLUDE_VALUE = "exclude-value";
    public static final String TAG_UNIT = "unit";
    public static final String TAG_REGISTER = "register";
    public static final String TAG_TEST_SCRIPTS = "tests";
    public static final String TAG_INCLUDE_TESTS = "include-tests";
    public static final String TAG_EXCLUDE_TESTS = "exclude-tests";
    public static final String TAG_TEST_ID = "test-id";
    public static final String TAG_SPECIFIC_TESTS = "specific-tests";
    public static final String TAG_DEFAULT_TESTS = "default-tests";
    public static final String TAG_DEFAULT_TEST = "default-test";
    public static final String TAG_COUNT = "count";
    public static final String TAG_OPTION = "option";
    public static final String TAG_MASK = "mask";
    public static final String TAG_OFFSET = "offset";
    public static final String TAG_MIN_VALUE = "min-value";
    public static final String TAG_MAX_VALUE = "max-value";
    public static final String TAG_ITERATOR = "iterator";
    public static final String TAG_MODE = "mode";
    public static final String TAG_ADDRESS = "address";
    public static final String TAG_PREREQUISITES = "prerequisites";
    public static final String TAG_PREREQUISITE = "prerequisite";
    public static final String TAG_TABLE_PARAMS = "table-params";
    public static final String TAG_TABLE_PARAM = "table-param";
    public static final String TAG_GENERATE_CODE = "generate-code";
    public static final String TAG_SHOW_MENU = "show-menu";
    public static final String TAG_RESTORE_CONFIG = "restore-config";
    public static final String ATTR_MIN = "min";
    public static final String ATTR_MAX = "max";
    public static final String ATTR_STEP = "step";
    public static final String VALUE_ORIENTATION_HORIZONTAL = "horizontal";
    public static final String VALUE_ORIENTATION_VERTICAL = "vertical";
    public static final String VALUE_PARAM_TYPE_PEX = "PEX";
    public static final String VALUE_PARAM_TYPE_SCRIPT = "SCRIPT";
    public static final String VALUE_PARAM_TYPE_TEST = "TEST";
    public static final String VALUE_PARAM_TYPE_CUSTOM = "CUSTOM";
    public static final String VALUE_ITERATOR_STANDARD = "standard";
    public static final String VALUE_ITERATOR_CUSTOM = "custom";
    public static final String MODE_X2 = "2x";
    @Nullable
    private static Scripts scripts;
    @Nullable
    private static String selectedMode;

    private static List<VScriptConfig> assembleAllScriptConfigs() throws Exception {
        return VTableParser.assembleAllScriptConfigs(null, null, null);
    }

    private static List<VScriptConfig> assembleAllScriptConfigs(@Nullable List<String> includes, @Nullable List<String> excludes, @Nullable List<VScriptConfig> defaultScriptConfigs) throws Exception {
        if (includes != null && excludes != null && includes.size() > 0 && excludes.size() > 0) {
            throw new Exception("Exception when parsing ...<tests><specific-tests>: tags <include-tests> and <exclude-tests> are mutually exclusive");
        }
        ArrayList<VScript> allScripts = new ArrayList<VScript>();
        HashSet<String> scriptIds = new HashSet<String>();
        if (includes == null || includes.isEmpty()) {
            if (scripts != null) {
                for (VScript script : scripts.getScripts()) {
                    if (script.isSpecific()) continue;
                    scriptIds.add(script.getId());
                }
            }
        } else {
            scriptIds.addAll(includes);
        }
        if (excludes != null) {
            scriptIds.removeAll(excludes);
        }
        if (scripts != null) {
            for (VScript script : scripts.getScripts()) {
                if (!scriptIds.contains(script.getId())) continue;
                allScripts.add(script);
            }
        }
        if (defaultScriptConfigs != null) {
            for (VScriptConfig defaultScriptConfig : defaultScriptConfigs) {
                if (allScripts.contains(defaultScriptConfig.getScript())) continue;
                throw new Exception("Exception when parsing ...<tests><default-tests><default-test>: can't have an excluded script as default script: " + defaultScriptConfig.getScript().getName());
            }
        }
        ArrayList<VScriptConfig> allConfigs = new ArrayList<VScriptConfig>();
        for (VScript script : allScripts) {
            boolean isDefault = false;
            if (defaultScriptConfigs != null) {
                for (VScriptConfig defaultScriptConfig : defaultScriptConfigs) {
                    if (defaultScriptConfig.getScript() != script) continue;
                    isDefault = true;
                    allConfigs.add(defaultScriptConfig);
                    break;
                }
            }
            if (isDefault) continue;
            allConfigs.add(VScriptConfigBuilder.assembleDefaultScriptConfig(script));
        }
        return allConfigs;
    }

    private static VParam assembleParam(Map<String, String> properties, BeanPropertyParam.BeanSymbol[] symbols, String[] values, String[] excludedValues, @Nullable List<VScriptConfig> scriptConfigs) throws Exception {
        String type = properties.get(TAG_TYPE);
        if (VALUE_PARAM_TYPE_PEX.equalsIgnoreCase(type)) {
            return ParamBuilder.assembleBeanPropertyParam(properties, symbols, values, excludedValues);
        }
        if (VALUE_PARAM_TYPE_SCRIPT.equalsIgnoreCase(type) && scripts != null) {
            return ParamBuilder.assembleTestScriptParam(properties, scripts);
        }
        if (VALUE_PARAM_TYPE_TEST.equalsIgnoreCase(type) && scripts != null) {
            return ParamBuilder.assembleTestTestsParam(properties, scripts, scriptConfigs);
        }
        if (VALUE_PARAM_TYPE_CUSTOM.equalsIgnoreCase(type)) {
            return ParamBuilder.assembleRegFieldParam(properties);
        }
        throw new Exception(String.format("Invalid parameter type: %s! Select between PEX, SCRIPT or CUSTOM!", type));
    }

    private static BeanPropertyParam.BeanSymbol parseBeanSymbol(Node node) throws Exception {
        String name = "";
        ArrayList<String> regNameList = new ArrayList<String>();
        NodeList childNodes = node.getChildNodes();
        int i = 0;
        while (i < childNodes.getLength()) {
            Node childNode = childNodes.item(i);
            if (childNode != null && TAG_NAME.equalsIgnoreCase(childNode.getNodeName())) {
                name = ParserUtility.getNodeTextContent(childNode);
            } else if (childNode != null && TAG_REGISTER.equalsIgnoreCase(childNode.getNodeName())) {
                String regName = ParserUtility.getNodeTextContent(childNode);
                if (regName.equals("")) {
                    throw new Exception("Exception when parsing ...<param><symbols><symbol><register>!");
                }
                regNameList.add(regName);
            }
            ++i;
        }
        String[] regNames = regNameList.toArray(new String[regNameList.size()]);
        return new BeanPropertyParam.BeanSymbol(name, regNames);
    }

    private static BeanPropertyParam.BeanSymbol[] parseBeanSymbols(NodeList nodes) throws Exception {
        ArrayList<BeanPropertyParam.BeanSymbol> symbols = new ArrayList<BeanPropertyParam.BeanSymbol>();
        int i = 0;
        while (i < nodes.getLength()) {
            block5: {
                BeanPropertyParam.BeanSymbol symbol;
                Node childNode;
                block6: {
                    childNode = nodes.item(i);
                    if (childNode == null || !TAG_SYMBOL.equalsIgnoreCase(childNode.getNodeName())) break block5;
                    if (!childNode.hasAttributes()) break block6;
                    String mode = ParserUtility.getAttribValue(childNode, TAG_MEM_TYPE, false);
                    if (selectedMode != null && !selectedMode.equals(mode)) break block5;
                }
                if ((symbol = VTableParser.parseBeanSymbol(childNode)).getSymbol().equals("") && symbol.getRegNames().length == 0) {
                    throw new Exception("Exception when parsing ...<param><symbols>!");
                }
                symbols.add(symbol);
            }
            ++i;
        }
        return symbols.toArray(new BeanPropertyParam.BeanSymbol[symbols.size()]);
    }

    private static String[] parseExcludeValues(NodeList nodes) throws Exception {
        ArrayList<String> excludedValues = new ArrayList<String>();
        int i = 0;
        while (i < nodes.getLength()) {
            Node childNode = nodes.item(i);
            if (childNode != null && TAG_EXCLUDE_VALUE.equalsIgnoreCase(childNode.getNodeName())) {
                String excludedValue = ParserUtility.getNodeTextContent(childNode);
                if (excludedValue.equals("")) {
                    throw new Exception("Exception on ...<param><values><exclude-value>!");
                }
                excludedValues.add(excludedValue);
            }
            ++i;
        }
        return excludedValues.toArray(new String[excludedValues.size()]);
    }

    private static VTable parseTable(Node node) throws Exception {
        Node childNode;
        VTableOptions options = null;
        VParam[] params = null;
        List<VScriptConfig> scriptConfigs = null;
        List<VPrerequisiteSetting> prerequisites = null;
        boolean hasCustomDefaults = false;
        NodeList childNodes = node.getChildNodes();
        int i = 0;
        while (i < childNodes.getLength()) {
            childNode = childNodes.item(i);
            if (childNode != null && TAG_TEST_SCRIPTS.equalsIgnoreCase(childNode.getNodeName())) {
                scriptConfigs = VTableParser.parseTableScriptConfigs(childNode);
                hasCustomDefaults = true;
            }
            ++i;
        }
        i = 0;
        while (i < childNodes.getLength()) {
            childNode = childNodes.item(i);
            if (childNode != null && TAG_OPTIONS.equalsIgnoreCase(childNode.getNodeName())) {
                options = VTableParser.parseTableOptions(childNode);
            } else if (childNode != null && TAG_PARAMS.equalsIgnoreCase(childNode.getNodeName())) {
                params = VTableParser.parseTableParams(childNode, scriptConfigs);
            } else if (childNode != null && TAG_PREREQUISITES.equalsIgnoreCase(childNode.getNodeName())) {
                prerequisites = VTableParser.parseTablePrerequisites(childNode);
            }
            ++i;
        }
        if (options == null || params == null) {
            throw new Exception("Exception when parsing <validation-table> element!");
        }
        if (scriptConfigs == null) {
            scriptConfigs = VTableParser.assembleAllScriptConfigs();
        }
        return new VTable(options, params, prerequisites, scriptConfigs, hasCustomDefaults);
    }

    private static Map<String, @Nullable Object> parseTableOptionParams(Node node) throws Exception {
        HashMap<String, @Nullable Object> paramMap = new HashMap<String, Object>();
        NodeList childNodes = node.getChildNodes();
        int j = 0;
        while (j < childNodes.getLength()) {
            String childNodeName;
            Node childNode = childNodes.item(j);
            if (childNode != null && TAG_TABLE_PARAM.equalsIgnoreCase(childNodeName = childNode.getNodeName())) {
                String name = null;
                String value = null;
                NodeList paramProps = childNode.getChildNodes();
                int k = 0;
                while (k < paramProps.getLength()) {
                    Node paramProp = paramProps.item(k);
                    if (paramProp != null) {
                        String paramPropName = paramProp.getNodeName();
                        if (TAG_NAME.equalsIgnoreCase(paramPropName)) {
                            name = ParserUtility.getNodeTextContent(paramProp);
                        } else if (TAG_VALUE.equalsIgnoreCase(paramPropName)) {
                            value = ParserUtility.getNodeTextContent(paramProp);
                        }
                    }
                    ++k;
                }
                if (name != null && value != null) {
                    paramMap.put(name, value);
                }
            }
            ++j;
        }
        return paramMap;
    }

    private static VTableOptions parseTableOptions(Node node) throws Exception {
        VTableOptions options = new VTableOptions();
        NodeList childNodes = node.getChildNodes();
        int i = 0;
        while (i < childNodes.getLength()) {
            String showLogsStr;
            Node childNode = childNodes.item(i);
            String childName = "";
            if (childNode != null) {
                childName = childNode.getNodeName();
            }
            if (childNode != null && TAG_ID.equalsIgnoreCase(childName)) {
                options.id = ParserUtility.getNodeTextContent(childNode);
            } else if (childNode != null && TAG_NAME.equalsIgnoreCase(childName)) {
                options.name = ParserUtility.getNodeTextContent(childNode);
            } else if (childNode != null && TAG_DESCRIPTION.equalsIgnoreCase(childName)) {
                options.description = ParserUtility.getNodeTextContent(childNode);
            } else if (childNode != null && TAG_HORIZONTAL_LABEL.equalsIgnoreCase(childName)) {
                options.hLabel = ParserUtility.getNodeTextContent(childNode);
            } else if (childNode != null && TAG_VERTICAL_LABEL.equalsIgnoreCase(childName)) {
                options.vLabel = ParserUtility.getNodeTextContent(childNode);
            } else if (childNode != null && TAG_SHOW_SCRIPTS.equalsIgnoreCase(childName)) {
                String showScriptStr = ParserUtility.getNodeTextContent(childNode);
                options.showScripts = Boolean.valueOf(showScriptStr);
            } else if (childNode != null && TAG_SHOW_LOGS.equalsIgnoreCase(childName)) {
                showLogsStr = ParserUtility.getNodeTextContent(childNode);
                options.showLogs = Boolean.valueOf(showLogsStr);
            } else if (childNode != null && TAG_SHOW_EXTRA.equalsIgnoreCase(childName)) {
                showLogsStr = ParserUtility.getNodeTextContent(childNode);
                options.showExtra = Boolean.valueOf(showLogsStr);
            } else if (childNode != null && TAG_SHOW_OPTIONS.equalsIgnoreCase(childName)) {
                String showConfigStr = ParserUtility.getNodeTextContent(childNode);
                options.showConfig = Boolean.valueOf(showConfigStr);
            } else if (childNode != null && TAG_ALLOW_USER_VARIATION.equalsIgnoreCase(childName)) {
                String allowUserVarStr = ParserUtility.getNodeTextContent(childNode);
                options.allowUserVariation = Boolean.valueOf(allowUserVarStr);
            } else if (childNode != null && TAG_ALLOW_CELL_SKIP.equalsIgnoreCase(childName)) {
                String allowCellSkip = ParserUtility.getNodeTextContent(childNode);
                options.allowCellSkip = Boolean.valueOf(allowCellSkip);
            } else if (childNode != null && TAG_ALLOW_TABLE_SKIP.equalsIgnoreCase(childName)) {
                String allowTableSkip = ParserUtility.getNodeTextContent(childNode);
                options.allowTableSkip = Boolean.valueOf(allowTableSkip);
            } else if (childNode != null && TAG_PRECOMPUTE_GOLDEN_CELL.equalsIgnoreCase(childName)) {
                String preComputeGoldStr = ParserUtility.getNodeTextContent(childNode);
                options.precomputeGoldenVariation = Boolean.valueOf(preComputeGoldStr);
            } else if (childNode != null && TAG_DISPLAY_RESULTS_TYPE.equalsIgnoreCase(childName)) {
                String displayResultsStr = ParserUtility.getNodeTextContent(childNode);
                options.displayResultsType = VTable.TableResultsType.valueOf(displayResultsStr.toUpperCase());
            } else if (childNode != null && TAG_APPLY_DEFAULT_VALUES.equalsIgnoreCase(childName)) {
                String applyDefaultStr = ParserUtility.getNodeTextContent(childNode);
                options.applyDefaultParamValues = Boolean.parseBoolean(applyDefaultStr);
            } else if (childNode != null && TAG_APPLY_CELL_CUSTOM_DATA.equalsIgnoreCase(childName)) {
                String applyCustomStr = ParserUtility.getNodeTextContent(childNode);
                options.applyCellCustomData = Boolean.parseBoolean(applyCustomStr);
            } else if (childNode != null && TAG_TABLE_PARAMS.equalsIgnoreCase(childName)) {
                options.params = VTableParser.parseTableOptionParams(childNode);
            } else {
                if (childNode != null && TAG_GENERATE_CODE.equalsIgnoreCase(childName)) {
                    String genCodeEnabledStr = ParserUtility.getNodeTextContent(childNode);
                    options.genCodeEnabled = Boolean.parseBoolean(genCodeEnabledStr);
                }
                if (childNode != null && TAG_SHOW_MENU.equalsIgnoreCase(childName)) {
                    String showMenuStr = ParserUtility.getNodeTextContent(childNode);
                    options.showMenuEnabled = Boolean.parseBoolean(showMenuStr);
                }
                if (childNode != null && TAG_RESTORE_CONFIG.equalsIgnoreCase(childName)) {
                    String restorConfigStr = ParserUtility.getNodeTextContent(childNode);
                    options.restoreConfigEnabled = Boolean.parseBoolean(restorConfigStr);
                }
            }
            ++i;
        }
        return options;
    }

    private static VParam parseTableParam(Node node, @Nullable List<VScriptConfig> scriptConfigs) throws Exception {
        HashMap<String, String> propertiesMap = new HashMap<String, String>();
        BeanPropertyParam.BeanSymbol[] beanSymbols = new BeanPropertyParam.BeanSymbol[]{};
        String[] values = new String[]{};
        String[] excludedValues = new String[]{};
        NodeList childNodes = node.getChildNodes();
        int i = 0;
        while (i < childNodes.getLength()) {
            Node childNode = childNodes.item(i);
            String childName = "";
            if (childNode != null) {
                childName = childNode.getNodeName();
            }
            if (childNode != null && TAG_ID.equalsIgnoreCase(childName)) {
                propertiesMap.put(TAG_ID, ParserUtility.getNodeTextContent(childNode));
            } else if (childNode != null && TAG_NAME.equalsIgnoreCase(childName)) {
                propertiesMap.put(TAG_NAME, ParserUtility.getNodeTextContent(childNode));
            } else if (childNode != null && TAG_TYPE.equalsIgnoreCase(childName)) {
                propertiesMap.put(TAG_TYPE, ParserUtility.getNodeTextContent(childNode));
            } else if (childNode != null && TAG_ORIENTATION.equalsIgnoreCase(childName)) {
                propertiesMap.put(TAG_ORIENTATION, ParserUtility.getNodeTextContent(childNode));
            } else if (childNode != null && TAG_PATTERN.equalsIgnoreCase(childName)) {
                propertiesMap.put(TAG_PATTERN, ParserUtility.getNodeTextContent(childNode));
            } else if (childNode != null && TAG_PREFIX.equalsIgnoreCase(childName)) {
                propertiesMap.put(TAG_PREFIX, ParserUtility.getNodeTextContent(childNode));
            } else if (childNode != null && TAG_POSTFIX.equalsIgnoreCase(childName)) {
                propertiesMap.put(TAG_POSTFIX, ParserUtility.getNodeTextContent(childNode));
            } else if (childNode != null && TAG_DYNAMIC.equalsIgnoreCase(childName)) {
                propertiesMap.put(TAG_DYNAMIC, ParserUtility.getNodeTextContent(childNode));
            } else if (childNode != null && TAG_ADDRESS.equalsIgnoreCase(childName)) {
                propertiesMap.put(TAG_ADDRESS, ParserUtility.getNodeTextContent(childNode));
            } else if (childNode != null && TAG_MASK.equalsIgnoreCase(childName)) {
                propertiesMap.put(TAG_MASK, ParserUtility.getNodeTextContent(childNode));
            } else if (childNode != null && TAG_OFFSET.equalsIgnoreCase(childName)) {
                propertiesMap.put(TAG_OFFSET, ParserUtility.getNodeTextContent(childNode));
            } else if (childNode != null && TAG_MIN_VALUE.equalsIgnoreCase(childName)) {
                propertiesMap.put(TAG_MIN_VALUE, ParserUtility.getNodeTextContent(childNode));
            } else if (childNode != null && TAG_MAX_VALUE.equalsIgnoreCase(childName)) {
                propertiesMap.put(TAG_MAX_VALUE, ParserUtility.getNodeTextContent(childNode));
            } else if (childNode != null && TAG_ITERATOR.equalsIgnoreCase(childName)) {
                propertiesMap.put(TAG_ITERATOR, ParserUtility.getNodeTextContent(childNode));
            } else if (childNode != null && TAG_MODE.equalsIgnoreCase(childName)) {
                propertiesMap.put(TAG_MODE, ParserUtility.getNodeTextContent(childNode));
            } else if (childNode != null && TAG_SYMBOLS.equalsIgnoreCase(childName)) {
                beanSymbols = VTableParser.parseBeanSymbols(childNode.getChildNodes());
            } else if (childNode != null && TAG_UNIT.equalsIgnoreCase(childName)) {
                propertiesMap.put(TAG_UNIT, ParserUtility.getNodeTextContent(childNode));
            } else if (childNode != null && TAG_VALUES.equalsIgnoreCase(childName)) {
                if (childNode.hasAttributes()) {
                    NamedNodeMap nodeMap = childNode.getAttributes();
                    if (nodeMap != null) {
                        Node attribMin = nodeMap.getNamedItem(ATTR_MIN);
                        String minValue = attribMin.getNodeValue();
                        Node attribMax = nodeMap.getNamedItem(ATTR_MAX);
                        String maxValue = attribMax.getNodeValue();
                        Node attribStep = nodeMap.getNamedItem(ATTR_STEP);
                        String stepValue = attribStep.getNodeValue();
                        int min = 0;
                        int max = 0;
                        int step = 0;
                        try {
                            min = Integer.parseInt(minValue);
                            max = Integer.parseInt(maxValue);
                            step = Integer.parseInt(stepValue);
                            ArrayList<String> values1 = new ArrayList<String>();
                            int j = min;
                            while (j < max) {
                                values1.add(String.valueOf(j));
                                j += step;
                            }
                            values = values1.toArray(new String[values1.size()]);
                        }
                        catch (Exception e) {
                            LOGGER.log(Level.INFO, e.getMessage());
                        }
                    }
                } else {
                    values = VTableParser.parseValues(childNode.getChildNodes());
                    excludedValues = VTableParser.parseExcludeValues(childNode.getChildNodes());
                }
            }
            ++i;
        }
        return VTableParser.assembleParam(propertiesMap, beanSymbols, values, excludedValues, scriptConfigs);
    }

    private static VParam[] parseTableParams(Node node, @Nullable List<VScriptConfig> scriptConfigs) throws Exception {
        ArrayList<VParam> paramList = new ArrayList<VParam>();
        NodeList childNodes = node.getChildNodes();
        int i = 0;
        while (i < childNodes.getLength()) {
            Node childNode = childNodes.item(i);
            if (childNode != null && TAG_PARAM.equalsIgnoreCase(childNode.getNodeName())) {
                VParam param = VTableParser.parseTableParam(childNode, scriptConfigs);
                paramList.add(param);
            }
            ++i;
        }
        return paramList.toArray(new VParam[paramList.size()]);
    }

    private static @Nullable VPrerequisiteSetting parseTablePrerequisite(Node node) {
        try {
            String id = ParserUtility.getAttribValue(node, TAG_ID);
            String name = ParserUtility.getAttribValue(node, TAG_NAME);
            String symbol = ParserUtility.getAttribValue(node, TAG_SYMBOL);
            String value = ParserUtility.getAttribValue(node, TAG_VALUE);
            if (id != null && name != null && symbol != null && value != null) {
                return new VPrerequisiteSetting(name, id, symbol, value);
            }
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, String.format("Exception on <%s> parsing.", node.getNodeName()), e);
            return null;
        }
        return null;
    }

    private static @Nullable List<@NonNull VPrerequisiteSetting> parseTablePrerequisites(Node node) {
        ArrayList<VPrerequisiteSetting> prerequisiteList = new ArrayList<VPrerequisiteSetting>();
        NodeList childNodes = node.getChildNodes();
        int i = 0;
        while (i < childNodes.getLength()) {
            VPrerequisiteSetting prerequisite;
            Node childNode = childNodes.item(i);
            if (childNode != null && TAG_PREREQUISITE.equalsIgnoreCase(childNode.getNodeName()) && (prerequisite = VTableParser.parseTablePrerequisite(childNode)) != null) {
                prerequisiteList.add(prerequisite);
            }
            ++i;
        }
        return prerequisiteList.isEmpty() ? null : prerequisiteList;
    }

    public static @Nullable Tables parseTables(String configFile, Scripts _scripts) {
        scripts = _scripts;
        ArrayList<VTable> tableList = new ArrayList<VTable>();
        IConfigProvider configController = ValidationContext.getInstance().getConfigController();
        if (configController != null) {
            selectedMode = configController.getPropertyEnumId(TAG_MEM_TYPE);
        }
        try {
            Node rootNode = ParserUtility.extractRootXmlNode(configFile);
            NodeList childNodes = rootNode.getChildNodes();
            int i = 0;
            while (i < childNodes.getLength()) {
                Node childNode = childNodes.item(i);
                if (childNode != null && TAG_VTABLE.equalsIgnoreCase(childNode.getNodeName())) {
                    VTable table = VTableParser.parseTable(childNode);
                    tableList.add(table);
                }
                ++i;
            }
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, "Exception when parsing XML configuration file: " + configFile, e);
            return null;
        }
        return new Tables(tableList);
    }

    private static VScriptConfig parseTableScriptConfig(Node node) throws Exception {
        NodeList childNodes = node.getChildNodes();
        int numRuns = -1;
        String testId = null;
        HashMap<String, String> testOptions = new HashMap<String, String>();
        int i = 0;
        while (i < childNodes.getLength()) {
            Node childNode = childNodes.item(i);
            if (childNode != null && TAG_TEST_ID.equalsIgnoreCase(childNode.getNodeName())) {
                testId = ParserUtility.getNodeTextContent(childNode);
            } else if (childNode != null && TAG_COUNT.equalsIgnoreCase(childNode.getNodeName())) {
                numRuns = Integer.parseInt(ParserUtility.getNodeTextContent(childNode));
            } else if (childNode != null && TAG_OPTIONS.equalsIgnoreCase(childNode.getNodeName())) {
                NodeList optNodes = childNode.getChildNodes();
                int j = 0;
                while (j < optNodes.getLength()) {
                    Node optNode = optNodes.item(j);
                    if (optNode != null && TAG_OPTION.equalsIgnoreCase(optNode.getNodeName())) {
                        NodeList optProperties = optNode.getChildNodes();
                        String name = null;
                        String value = null;
                        int k = 0;
                        while (k < optProperties.getLength()) {
                            Node optProperty = optProperties.item(k);
                            if (optProperty != null && TAG_NAME.equalsIgnoreCase(optProperty.getNodeName())) {
                                name = ParserUtility.getNodeTextContent(optProperty);
                            } else if (optProperty != null && TAG_VALUE.equalsIgnoreCase(optProperty.getNodeName())) {
                                value = ParserUtility.getNodeTextContent(optProperty);
                            }
                            ++k;
                        }
                        if (name == null || value == null) {
                            throw new Exception("Exception on parsing ...<default-test><options><option>");
                        }
                        testOptions.put(name, value);
                    }
                    ++j;
                }
            }
            ++i;
        }
        if (testId == null) {
            throw new Exception("Exception when parsing ...<default-test>: missing mandatory <test-id> tag!");
        }
        if (numRuns < 1) {
            throw new Exception("Exception when parsing ...<default-test>: missing or invalid <count> tag (should be positive)!");
        }
        if (scripts == null) {
            throw new Exception("Exception when parsing ...<default-test>: invalid <test-name> tag contents: script with the id '" + testId + "' does not exist!");
        }
        Scripts _scripts = Objects.requireNonNull(scripts);
        VScript script = _scripts.getScript(testId);
        if (script == null) {
            throw new Exception("Exception when parsing ...<default-test>: invalid <test-name> tag contents: script with the id '" + testId + "' does not exist!");
        }
        return VScriptConfigBuilder.assembleScriptConfig(script, numRuns, testOptions);
    }

    private static List<VScriptConfig> parseTableScriptConfigs(Node node) throws Exception {
        List<String> includes = new ArrayList<String>();
        List<String> excludes = new ArrayList<String>();
        ArrayList<VScriptConfig> defaultScriptConfigs = new ArrayList<VScriptConfig>();
        NodeList nodes = node.getChildNodes();
        int i = 0;
        while (i < nodes.getLength()) {
            int j;
            Node childNode = nodes.item(i);
            if (childNode != null && TAG_SPECIFIC_TESTS.equalsIgnoreCase(childNode.getNodeName())) {
                NodeList specificTestNodes = childNode.getChildNodes();
                j = 0;
                while (j < specificTestNodes.getLength()) {
                    Node specificTestNode = specificTestNodes.item(j);
                    if (specificTestNode != null && TAG_INCLUDE_TESTS.equalsIgnoreCase(specificTestNode.getNodeName())) {
                        includes = VTableParser.parseTestNames(specificTestNode.getChildNodes());
                    } else if (specificTestNode != null && TAG_EXCLUDE_TESTS.equalsIgnoreCase(specificTestNode.getNodeName())) {
                        excludes = VTableParser.parseTestNames(specificTestNode.getChildNodes());
                    }
                    ++j;
                }
            } else if (childNode != null && TAG_DEFAULT_TESTS.equalsIgnoreCase(childNode.getNodeName())) {
                NodeList defaultTestNodes = childNode.getChildNodes();
                j = 0;
                while (j < defaultTestNodes.getLength()) {
                    Node defaultTestNode = defaultTestNodes.item(j);
                    if (defaultTestNode != null && TAG_DEFAULT_TEST.equalsIgnoreCase(defaultTestNode.getNodeName())) {
                        defaultScriptConfigs.add(VTableParser.parseTableScriptConfig(defaultTestNode));
                    }
                    ++j;
                }
            }
            ++i;
        }
        return VTableParser.assembleAllScriptConfigs(includes, excludes, defaultScriptConfigs);
    }

    private static List<String> parseTestNames(NodeList nodes) throws Exception {
        ArrayList<String> testNameList = new ArrayList<String>();
        int i = 0;
        while (i < nodes.getLength()) {
            Node node = nodes.item(i);
            if (node != null && TAG_TEST_ID.equalsIgnoreCase(node.getNodeName())) {
                String testId = ParserUtility.getNodeTextContent(node);
                testNameList.add(testId);
            }
            ++i;
        }
        return testNameList;
    }

    private static String[] parseValues(NodeList nodes) throws Exception {
        ArrayList<String> values = new ArrayList<String>();
        int i = 0;
        while (i < nodes.getLength()) {
            Node childNode = nodes.item(i);
            if (childNode != null && TAG_VALUE.equalsIgnoreCase(childNode.getNodeName())) {
                if (childNode.hasAttributes()) {
                    String mode = ParserUtility.getAttribValue(childNode, TAG_MEM_TYPE, false);
                    if (mode != null && !mode.isEmpty()) {
                        String[] modes;
                        String[] stringArray = modes = mode.split(";");
                        int n = modes.length;
                        int n2 = 0;
                        while (n2 < n) {
                            String memType = stringArray[n2];
                            if (selectedMode != null && selectedMode.equals(memType)) {
                                String value = ParserUtility.getNodeTextContent(childNode);
                                values.add(value);
                                break;
                            }
                            ++n2;
                        }
                    }
                } else {
                    String value = ParserUtility.getNodeTextContent(childNode);
                    values.add(value);
                }
            }
            ++i;
        }
        return values.toArray(new String[values.size()]);
    }
}

