/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.mem.validation.model.scripts;

import com.nxp.swtools.common.utils.text.UtilsText;
import com.nxp.swtools.mem.validation.Messages;
import com.nxp.swtools.mem.validation.model.scripts.VScriptParam;
import org.eclipse.osgi.util.NLS;

public class VScript {
    public static final String GTA_CONDITION_ID = "core: ARMv8, access: GTA";
    private String id;
    private String name;
    private boolean specific;
    private VScriptTemplate[] templates;
    private VScriptParam[] params;
    private boolean userScript;
    private String testDescription;

    public static VScript createUserScript(String id, String name, VScriptTemplate template) {
        return new VScript(id, name, template);
    }

    public VScript(String id, String name, boolean specific, String testDescription, VScriptParam[] params, boolean userScript) {
        this.id = id;
        this.name = name;
        this.specific = specific;
        this.templates = new VScriptTemplate[0];
        this.params = (VScriptParam[])params.clone();
        this.testDescription = testDescription;
        this.userScript = userScript;
    }

    private VScript(String _id, String _name, VScriptTemplate template) {
        this.id = _id;
        this.name = _name;
        this.specific = false;
        this.templates = new VScriptTemplate[]{template};
        this.params = new VScriptParam[0];
        this.userScript = true;
        this.testDescription = "";
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public VScriptParam[] getParams() {
        return (VScriptParam[])this.params.clone();
    }

    public VScriptTemplate[] getTemplates() {
        return (VScriptTemplate[])this.templates.clone();
    }

    public String getTestDescription() {
        return this.testDescription;
    }

    public boolean hasParams() {
        return this.params.length > 0;
    }

    public boolean hasVisibleParams() {
        VScriptParam[] vScriptParamArray = this.params;
        int n = this.params.length;
        int n2 = 0;
        while (n2 < n) {
            VScriptParam param = vScriptParamArray[n2];
            if (!param.isHidden()) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public boolean isSpecific() {
        return this.specific;
    }

    public boolean isUserScript() {
        return this.userScript;
    }

    public void setName(String _name) {
        this.name = _name;
    }

    public void setTestDescription(String testDescription) {
        this.testDescription = testDescription;
    }

    public String toString() {
        return UtilsText.safeString((String)NLS.bind((String)Messages.VScript_0, (Object)this.id, (Object)this.name));
    }

    public static class VScriptTemplate {
        protected String filePath;

        public VScriptTemplate(String _filePath) {
            this.filePath = _filePath;
        }

        public VScriptTemplate(VScriptTemplate proto) {
            this.filePath = proto.filePath;
        }

        public String getFilePath() {
            return this.filePath;
        }

        public void setFilePath(String _filePath) {
            this.filePath = _filePath;
        }
    }
}

