/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.mem.validation.reports;

import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.common.utils.logging.LogManager;
import com.nxp.swtools.common.utils.text.UtilsText;
import com.nxp.swtools.mem.validation.IDiagsProvider;
import com.nxp.swtools.mem.validation.Messages;
import com.nxp.swtools.mem.validation.model.VPresentationModel;
import com.nxp.swtools.mem.validation.model.VRunResult;
import com.nxp.swtools.mem.validation.model.presenter.VScenarioPresentation;
import com.nxp.swtools.mem.validation.model.presenter.VStagePresentation;
import com.nxp.swtools.mem.validation.model.scenarios.VScenario;
import com.nxp.swtools.mem.validation.model.scenarios.VTable;
import com.nxp.swtools.mem.validation.model.scripts.VScriptConfig;
import com.nxp.swtools.mem.validation.model.scripts.VScriptParam;
import com.nxp.swtools.mem.validation.model.scripts.VScriptParamValue;
import com.nxp.swtools.mem.validation.reports.IReportGenerator;
import com.nxp.swtools.mem.validation.table.params.VParam;
import com.nxp.swtools.mem.validation.table.params.VParamValue;
import com.nxp.swtools.mem.validation.table.params.VParamVariation;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.nio.charset.StandardCharsets;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.logging.Logger;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Canvas;

public class HtmlReportGenerator
implements IReportGenerator {
    private static final Logger LOGGER = LogManager.getLogger(HtmlReportGenerator.class);
    VPresentationModel model;
    public static final String HTML = "html";
    public static final String HEAD = "head";
    public static final String TITLE = "title";
    public static final String BODY = "body";
    public static final String H3 = "h3";
    public static final String H4 = "h4";
    public static final String H5 = "h5";
    public static final String H6 = "h6";
    public static final String TABLE = "table";
    public static final String TR = "tr";
    public static final String TH = "th";
    public static final String TD = "td";
    public static final String CENTER = "center";
    public static final String ATTRIB_BORDER = "border";
    public static final String ATTRIB_COLSPAN = "colspan";
    public static final String ATTRIB_ROWSPAN = "rowspan";
    public static final String ATTRIB_BGCOLOR = "bgcolor";
    public static final String BREAK_LINE = "</br>";
    public static final String HORIZONTAL_LINE = "<hr>";
    public static final String CORNER_TEXT = UtilsText.safeString((String)Messages.HtmlReportGenerator_0);
    public static final String DOC_TITLE = UtilsText.safeString((String)Messages.HtmlReportGenerator_1);
    public static final String MAIN_HEADER_PREFIX = UtilsText.safeString((String)Messages.HtmlReportGenerator_2);
    static final String[][] TABLE_ATTRIBS = new String[][]{{"border", "1"}};
    static final String[][] VPARAM_VALUE_ATTRIBS = new String[][]{{"bgcolor", "#B8CCE4"}, {"rowspan", "1"}, {"colspan", "1"}};
    static final String[][] VPARAM_NAME_ATTRIBS = new String[][]{{"bgcolor", "#95B3D7"}, {"rowspan", "1"}, {"colspan", "1"}};
    static final String[][] HPARAM_VALUE_ATTRIBS = new String[][]{{"bgcolor", "#E6B9B8"}, {"rowspan", "1"}, {"colspan", "1"}};
    static final String[][] HPARAM_NAME_ATTRIBS = new String[][]{{"bgcolor", "#D99795"}, {"rowspan", "1"}, {"colspan", "1"}};
    static final String[][] TABLE_CORNER_ATTRIBS = new String[][]{{"bgcolor", "#FFFFFF"}, {"rowspan", "1"}, {"colspan", "1"}};
    static final String[][] STANDARD_ATTRIBS = new String[][]{{"bgcolor", "#DDDDFF"}, {"rowspan", "1"}, {"colspan", "1"}};
    public static final String PASSED_CELL_PREFIX = "<td bgcolor=\"#00FF00\">";
    public static final String GOLD_CELL_PREFIX = "<td bgcolor=\"#D9CB07\">";
    public static final String USER_CELL_PREFIX = "<td bgcolor=\"#85A856\">";
    public static final String PFAILED_CELL_PREFIX = "<td bgcolor=\"#FFA500\">";
    public static final String FAILED_CELL_PREFIX = "<td>";
    public static final String PAUSED_CELL_PREFIX = "<td bgcolor=\"#88EEFF\">";
    public static final String CELL_POSTFIX = "</td>";
    public static final String NQUEUED_CELL_TEXT = "<td bgcolor=\"#CCCCCC\">///</td>";
    public static final String SKIPPED_CELL_TEXT = "<td><font color=\"#CCCCCC\">Skipped</font></td>";
    public static final String ERROR_CELL_TEXT = "<td><font color=\"#FF0000\">Error</font></td>";
    public static final String TODO_CELL_TEXT = "<td><center>...</center></td>";
    private static final int ROWSPAN_IDX = 1;
    private static final int COLSPAN_IDX = 2;
    private static final int VALUE_IDX = 1;
    private static final String CELL_TESTS_SUMMARY_HEADER = UtilsText.safeString((String)Messages.HtmlReportGenerator_3);
    private static final String SCRIPT_NAME_SUMMARY_HEADER = UtilsText.safeString((String)Messages.HtmlReportGenerator_4);
    private static final String ITERATION_SUMMARY_HEADER = UtilsText.safeString((String)Messages.HtmlReportGenerator_5);
    private static final String RESULT_SUMMARY_HEADER = UtilsText.safeString((String)Messages.HtmlReportGenerator_6);
    private static final String PARAM_VARIATION_HEADER = UtilsText.safeString((String)Messages.HtmlReportGenerator_7);
    private static final String REGISTER_VARIATION_HEADER = UtilsText.safeString((String)Messages.HtmlReportGenerator_8);
    private static final String INITIAL_DDR_CONFIG_HEADER = UtilsText.safeString((String)Messages.HtmlReportGenerator_9);
    private static final String SMOKE_TABLE_DDR_CONFIG_HEADER = UtilsText.safeString((String)Messages.HtmlReportGenerator_10);
    private static final String REGISTER_NAME_HEADER = UtilsText.safeString((String)Messages.HtmlReportGenerator_11);
    private static final String REGISTER_VALUE_HEADER = UtilsText.safeString((String)Messages.HtmlReportGenerator_12);
    private static final String DETAILED_CELL_RESULTS_HEADER = UtilsText.safeString((String)Messages.HtmlReportGenerator_13);
    public static final String SELECTED_SCRIPTS_HEADER = UtilsText.safeString((String)Messages.HtmlReportGenerator_14);
    public static final String SCRIPT_HEADER = UtilsText.safeString((String)Messages.HtmlReportGenerator_15);
    public static final String ITERATION_HEADER = UtilsText.safeString((String)Messages.HtmlReportGenerator_16);
    private static final String LESS_THAN = "<";
    private static final String HIGHER_THAN = ">";
    private IReportGenerator.ReportType type = IReportGenerator.ReportType.HTML;

    public HtmlReportGenerator(VPresentationModel vPresModel) {
        this.model = vPresModel;
    }

    private static @Nullable String cellTag(@Nullable VParamVariation cell, boolean isGoldenCell, boolean isUserCell) {
        if (cell != null) {
            int totalTests = cell.getNumPasses() + cell.getNumFails() + cell.getNumSkips();
            int passedTests = cell.getNumPasses();
            if (!cell.isSelected()) {
                return NQUEUED_CELL_TEXT;
            }
            String strPassedTests = passedTests + "/" + totalTests;
            if (cell.isSelected()) {
                switch (cell.getState()) {
                    case ERR_CONFIG: {
                        return ERROR_CELL_TEXT;
                    }
                    case ERR_CODEGEN: {
                        return ERROR_CELL_TEXT;
                    }
                    case FAILED: {
                        return FAILED_CELL_PREFIX + strPassedTests + CELL_POSTFIX;
                    }
                    case PARTIALY_PASSED: {
                        return PFAILED_CELL_PREFIX + strPassedTests + CELL_POSTFIX;
                    }
                    case PASSED: {
                        if (isGoldenCell) {
                            return GOLD_CELL_PREFIX + strPassedTests + CELL_POSTFIX;
                        }
                        if (isUserCell) {
                            return USER_CELL_PREFIX + strPassedTests + CELL_POSTFIX;
                        }
                        return PASSED_CELL_PREFIX + strPassedTests + CELL_POSTFIX;
                    }
                    case DEFAULT: {
                        if (totalTests > 0) {
                            return PAUSED_CELL_PREFIX + strPassedTests + CELL_POSTFIX;
                        }
                        return TODO_CELL_TEXT;
                    }
                    case SKIPPED: {
                        return SKIPPED_CELL_TEXT;
                    }
                    case PAUSED: {
                        return PAUSED_CELL_PREFIX + strPassedTests + CELL_POSTFIX;
                    }
                }
            }
        }
        return null;
    }

    public static String emptyTag(String name) {
        return LESS_THAN + name + "/>";
    }

    private static void generateComplexTestExecSummary(PrintWriter out, VTable paramTable, VParamVariation cell) {
        VRunResult[] trrs = cell.getResults();
        if (trrs == null || trrs.length == 0) {
            return;
        }
        out.println(BREAK_LINE);
        out.println(HtmlReportGenerator.tagAttribs(TABLE, TABLE_ATTRIBS));
        out.println(HtmlReportGenerator.tagBegin(TR));
        out.println(HtmlReportGenerator.headerTag(HeaderType.STANDARD, CELL_TESTS_SUMMARY_HEADER, 1, 3));
        out.println(HtmlReportGenerator.tagEnd(TR));
        out.println(HtmlReportGenerator.tagBegin(TR));
        out.println(HtmlReportGenerator.headerTag(HeaderType.STANDARD, SCRIPT_NAME_SUMMARY_HEADER, 1, 1));
        out.println(HtmlReportGenerator.headerTag(HeaderType.STANDARD, ITERATION_SUMMARY_HEADER, 1, 1));
        out.println(HtmlReportGenerator.headerTag(HeaderType.STANDARD, RESULT_SUMMARY_HEADER, 1, 1));
        out.println(HtmlReportGenerator.tagEnd(TR));
        VRunResult[] vRunResultArray = trrs;
        int n = trrs.length;
        int n2 = 0;
        while (n2 < n) {
            VRunResult trr = vRunResultArray[n2];
            out.println(HtmlReportGenerator.tagBegin(TR));
            out.println(String.valueOf(HtmlReportGenerator.tagBegin(TD)) + trr.getScriptConfig().getScript().getName() + HtmlReportGenerator.tagEnd(TD));
            int iteration = trr.getNumRun();
            out.println(String.valueOf(HtmlReportGenerator.tagBegin(TD)) + iteration + HtmlReportGenerator.tagEnd(TD));
            out.println(String.valueOf(HtmlReportGenerator.tagBegin(TD)) + trr.getType().uiName() + HtmlReportGenerator.tagEnd(TD));
            out.println(HtmlReportGenerator.tagEnd(TR));
            ++n2;
        }
        out.println(HtmlReportGenerator.tagEnd(TABLE));
    }

    private static void generateDetailedResults(PrintWriter out, VTable paramTable, boolean addUpdatedRegs, boolean addErrCaptRegs) {
        VParamVariation[][] cells;
        out.println(BREAK_LINE);
        out.println(String.valueOf(HtmlReportGenerator.tagBegin(H3)) + DETAILED_CELL_RESULTS_HEADER + HtmlReportGenerator.tagEnd(H3));
        VParamVariation[][] vParamVariationArray = cells = paramTable.getParamVariations();
        int n = cells.length;
        int n2 = 0;
        while (n2 < n) {
            VParamVariation[] cellRow;
            VParamVariation[] vParamVariationArray2 = cellRow = vParamVariationArray[n2];
            int n3 = cellRow.length;
            int n4 = 0;
            while (n4 < n3) {
                VParamVariation cell = vParamVariationArray2[n4];
                VParamVariation.VState state = cell.getState();
                if (cell.isSelected() && (state != VParamVariation.VState.SKIPPED && state != VParamVariation.VState.DEFAULT || cell.getNumFails() + cell.getNumPasses() != 0)) {
                    out.println(BREAK_LINE);
                    out.println(HORIZONTAL_LINE);
                    out.println(String.valueOf(HtmlReportGenerator.tagBegin(H3)) + "Cell (" + cell.getPos().x + ", " + cell.getPos().y + ")" + HtmlReportGenerator.tagEnd(H3));
                    if (addUpdatedRegs && !paramTable.hasScriptParam()) {
                        HtmlReportGenerator.generateParamVariationTable(out, paramTable, cell);
                    }
                    if (addErrCaptRegs) {
                        HtmlReportGenerator.generateComplexTestExecSummary(out, paramTable, cell);
                    } else {
                        HtmlReportGenerator.generateSimpleTestExecSummary(out, paramTable, cell);
                    }
                }
                ++n4;
            }
            ++n2;
        }
    }

    private static void generateInitialConfiguration(PrintWriter out, VTable paramTable) {
        out.println(BREAK_LINE);
        out.println(HtmlReportGenerator.tagAttribs(TABLE, TABLE_ATTRIBS));
        out.println(HtmlReportGenerator.tagBegin(TR));
        if (paramTable.hasScriptParam()) {
            out.println(HtmlReportGenerator.headerTag(HeaderType.STANDARD, SMOKE_TABLE_DDR_CONFIG_HEADER, 1, 2));
        } else {
            out.println(HtmlReportGenerator.headerTag(HeaderType.STANDARD, INITIAL_DDR_CONFIG_HEADER, 1, 2));
        }
        out.println(HtmlReportGenerator.tagEnd(TR));
        out.println(HtmlReportGenerator.tagBegin(TR));
        out.println(HtmlReportGenerator.headerTag(HeaderType.STANDARD, REGISTER_NAME_HEADER, 1, 1));
        out.println(HtmlReportGenerator.headerTag(HeaderType.STANDARD, REGISTER_VALUE_HEADER, 1, 1));
        out.println(HtmlReportGenerator.tagEnd(TR));
        out.println(HtmlReportGenerator.tagEnd(TABLE));
    }

    private static void generateParamTableReport_H0_V1(PrintWriter out, VTable paramTable) {
        String[] optNamesLoc;
        out.println(HtmlReportGenerator.tagAttribs(TABLE, TABLE_ATTRIBS));
        VParam vparam = paramTable.getVParams()[0];
        int numCols = vparam.getNumOptions();
        String hLabel = paramTable.getOptions().gethLabel();
        out.println(HtmlReportGenerator.tagBegin(TR));
        if (hLabel != null) {
            out.println(HtmlReportGenerator.headerTag(HeaderType.CORNER, CORNER_TEXT, 2, 2));
        } else {
            out.println(HtmlReportGenerator.headerTag(HeaderType.CORNER, CORNER_TEXT, 3, 2));
        }
        out.println(HtmlReportGenerator.headerTag(HeaderType.VPARAM_NAME, vparam.getName(), 1, vparam.getNumOptions()));
        out.println(HtmlReportGenerator.tagEnd(TR));
        VParamVariation goldCell = paramTable.getGoldenVariation();
        Point goldCellPos = goldCell == null ? new Point(-1, -1) : goldCell.getPos();
        VParamVariation userCell = paramTable.getUserVariation();
        Point userCellPos = userCell == null ? new Point(-1, -1) : userCell.getPos();
        out.println(HtmlReportGenerator.tagBegin(TR));
        if (hLabel != null) {
            out.println(HtmlReportGenerator.headerTag(HeaderType.HPARAM_NAME, hLabel, 2, 1));
        }
        if ((optNamesLoc = vparam.getOptNames()) != null) {
            int i = 0;
            while (i < vparam.getNumOptions()) {
                out.println(HtmlReportGenerator.headerTag(HeaderType.VPARAM_VALUE, UtilsText.safeString((String)optNamesLoc[i]), 1, 1));
                ++i;
            }
        }
        out.println(HtmlReportGenerator.tagEnd(TR));
        out.println(HtmlReportGenerator.tagBegin(TR));
        int j = 0;
        while (j < numCols) {
            boolean isGoldCell = goldCellPos.x == 0 && goldCellPos.y == j;
            boolean isUserCell = userCellPos.x == 0 && userCellPos.y == j;
            out.println(HtmlReportGenerator.cellTag(paramTable.getParamVariation(new Point(0, j)), isGoldCell, isUserCell));
            ++j;
        }
        out.println(HtmlReportGenerator.tagEnd(TR));
        out.println(HtmlReportGenerator.tagEnd(TABLE));
    }

    private static void generateParamTableReport_H1_V0(PrintWriter out, VTable paramTable) {
        out.println(HtmlReportGenerator.tagAttribs(TABLE, TABLE_ATTRIBS));
        VParam hparam = paramTable.getHParams()[0];
        int numRows = hparam.getNumOptions();
        out.println(HtmlReportGenerator.tagBegin(TR));
        out.println(HtmlReportGenerator.headerTag(HeaderType.CORNER, CORNER_TEXT, 1, 2));
        String vLabel = paramTable.getOptions().getvLabel();
        if (vLabel != null) {
            out.println(HtmlReportGenerator.headerTag(HeaderType.VPARAM_NAME, vLabel, 1, 1));
        }
        out.println(HtmlReportGenerator.tagEnd(TR));
        VParamVariation goldCell = paramTable.getGoldenVariation();
        Point goldCellPos = goldCell == null ? new Point(-1, -1) : goldCell.getPos();
        VParamVariation userCell = paramTable.getUserVariation();
        Point userCellPos = userCell == null ? new Point(-1, -1) : userCell.getPos();
        int i = 0;
        while (i < numRows) {
            String[] optNamesLoc;
            out.println(HtmlReportGenerator.tagBegin(TR));
            if (i == 0) {
                out.println(HtmlReportGenerator.headerTag(HeaderType.HPARAM_NAME, hparam.getName(), hparam.getNumOptions(), 1));
            }
            if ((optNamesLoc = hparam.getOptNames()) != null) {
                out.println(HtmlReportGenerator.headerTag(HeaderType.HPARAM_VALUE, UtilsText.safeString((String)optNamesLoc[i]), 1, 1));
            }
            boolean isGoldCell = goldCellPos.x == i && goldCellPos.y == 0;
            boolean isUserCell = goldCellPos.x == i && userCellPos.y == 0;
            out.println(HtmlReportGenerator.cellTag(paramTable.getParamVariation(new Point(i, 0)), isGoldCell, isUserCell));
            out.println(HtmlReportGenerator.tagEnd(TR));
            ++i;
        }
        out.println(HtmlReportGenerator.tagEnd(TABLE));
    }

    private static void generateParamTableReport_H1_V1(PrintWriter out, VTable paramTable) {
        out.println(HtmlReportGenerator.tagAttribs(TABLE, TABLE_ATTRIBS));
        VParam hparam = paramTable.getHParams()[0];
        VParam vparam = paramTable.getVParams()[0];
        int numRows = hparam.getNumOptions();
        int numCols = vparam.getNumOptions();
        out.println(HtmlReportGenerator.tagBegin(TR));
        out.println(HtmlReportGenerator.headerTag(HeaderType.CORNER, CORNER_TEXT, 2, 2));
        out.println(HtmlReportGenerator.headerTag(HeaderType.VPARAM_NAME, vparam.getName(), 1, vparam.getNumOptions()));
        out.println(HtmlReportGenerator.tagEnd(TR));
        out.println(HtmlReportGenerator.tagBegin(TR));
        String[] optNamesLoc = vparam.getOptNames();
        if (optNamesLoc != null) {
            int i = 0;
            while (i < vparam.getNumOptions()) {
                out.println(HtmlReportGenerator.headerTag(HeaderType.VPARAM_VALUE, UtilsText.safeString((String)optNamesLoc[i]), 1, 1));
                ++i;
            }
        }
        out.println(HtmlReportGenerator.tagEnd(TR));
        VParamVariation goldCell = paramTable.getGoldenVariation();
        Point goldCellPos = goldCell == null ? new Point(-1, -1) : goldCell.getPos();
        VParamVariation userCell = paramTable.getUserVariation();
        Point userCellPos = userCell == null ? new Point(-1, -1) : userCell.getPos();
        optNamesLoc = hparam.getOptNames();
        if (optNamesLoc != null) {
            int i = 0;
            while (i < numRows) {
                out.println(HtmlReportGenerator.tagBegin(TR));
                if (i == 0) {
                    out.println(HtmlReportGenerator.headerTag(HeaderType.HPARAM_NAME, hparam.getName(), hparam.getNumOptions(), 1));
                }
                out.println(HtmlReportGenerator.headerTag(HeaderType.HPARAM_VALUE, UtilsText.safeString((String)optNamesLoc[i]), 1, 1));
                int j = 0;
                while (j < numCols) {
                    boolean isGoldCell = goldCellPos.x == i && goldCellPos.y == j;
                    boolean isUserCell = userCellPos.x == i && userCellPos.y == j;
                    out.println(HtmlReportGenerator.cellTag(paramTable.getParamVariation(new Point(i, j)), isGoldCell, isUserCell));
                    ++j;
                }
                out.println(HtmlReportGenerator.tagEnd(TR));
                ++i;
            }
        }
        out.println(HtmlReportGenerator.tagEnd(TABLE));
    }

    private static void generateParamTableReport_Hn_V1(PrintWriter out, VTable paramTable) {
        out.println(HtmlReportGenerator.tagAttribs(TABLE, TABLE_ATTRIBS));
        VParam[] hparams = paramTable.getHParams();
        VParam vparam = paramTable.getVParams()[0];
        int numRows = 1;
        VParam[] vParamArray = hparams;
        int n = hparams.length;
        int n2 = 0;
        while (n2 < n) {
            VParam hparam = vParamArray[n2];
            numRows *= hparam.getNumOptions();
            ++n2;
        }
        int numCols = vparam.getNumOptions();
        out.println(HtmlReportGenerator.tagBegin(TR));
        out.println(HtmlReportGenerator.headerTag(HeaderType.CORNER, CORNER_TEXT, 1, hparams.length));
        out.println(HtmlReportGenerator.headerTag(HeaderType.VPARAM_NAME, vparam.getName(), 1, vparam.getNumOptions()));
        out.println(HtmlReportGenerator.tagEnd(TR));
        out.println(HtmlReportGenerator.tagBegin(TR));
        VParam[] vParamArray2 = hparams;
        int n3 = hparams.length;
        n = 0;
        while (n < n3) {
            VParam hparam = vParamArray2[n];
            out.println(HtmlReportGenerator.headerTag(HeaderType.HPARAM_NAME, hparam.getName(), 1, 1));
            ++n;
        }
        String[] optNamesLoc = vparam.getOptNames();
        if (optNamesLoc != null) {
            int i = 0;
            while (i < vparam.getNumOptions()) {
                out.println(HtmlReportGenerator.headerTag(HeaderType.VPARAM_VALUE, UtilsText.safeString((String)optNamesLoc[i]), 1, 1));
                ++i;
            }
        }
        out.println(HtmlReportGenerator.tagEnd(TR));
        int[] hSpans = new int[hparams.length];
        hSpans[hparams.length - 1] = 1;
        int i = hparams.length - 2;
        while (i >= 0) {
            hSpans[i] = hSpans[i + 1] * hparams[i + 1].getNumOptions();
            --i;
        }
        VParamVariation goldCell = paramTable.getGoldenVariation();
        Point goldCellPos = goldCell == null ? new Point(-1, -1) : goldCell.getPos();
        VParamVariation userCell = paramTable.getUserVariation();
        Point userCellPos = userCell == null ? new Point(-1, -1) : userCell.getPos();
        int i2 = 0;
        while (i2 < numRows) {
            out.println(HtmlReportGenerator.tagBegin(TR));
            int j = 0;
            while (j < numCols) {
                int k = 0;
                while (k < hparams.length) {
                    if (i2 % hSpans[k] == 0) {
                        int numOpts = hparams[k].getNumOptions();
                        optNamesLoc = hparams[k].getOptNames();
                        if (optNamesLoc != null && numOpts > 0) {
                            String optName = optNamesLoc[i2 / hSpans[k] % numOpts];
                            out.println(HtmlReportGenerator.headerTag(HeaderType.HPARAM_VALUE, UtilsText.safeString((String)optName), hSpans[k], 1));
                        }
                    }
                    ++k;
                }
                boolean isGoldCell = goldCellPos.x == i2 && goldCellPos.y == j;
                boolean isUserCell = userCellPos.x == i2 && userCellPos.y == j;
                out.println(HtmlReportGenerator.cellTag(paramTable.getParamVariation(new Point(i2, j)), isGoldCell, isUserCell));
                ++j;
            }
            out.println(HtmlReportGenerator.tagEnd(TR));
            ++i2;
        }
        out.println(HtmlReportGenerator.tagEnd(TABLE));
    }

    private static void generateParamVariationTable(PrintWriter out, VTable paramTable, VParamVariation cell) {
        VParamValue[] hparamValues = cell.getHValues();
        VParamValue[] vparamValues = cell.getVValues();
        int numH = hparamValues.length;
        int numV = vparamValues.length;
        String[] paramNames = new String[numH + numV];
        String[] paramValues = new String[numH + numV];
        int i = 0;
        while (i < numH) {
            paramNames[i] = hparamValues[i].getParam().getName();
            paramValues[i] = hparamValues[i].getValue().toString();
            ++i;
        }
        int startIdx = numH;
        int i2 = 0;
        while (i2 < numV) {
            paramNames[startIdx + i2] = vparamValues[i2].getParam().getName();
            paramValues[startIdx + i2] = vparamValues[i2].getValue().toString();
            ++i2;
        }
        out.println(BREAK_LINE);
        out.println(HtmlReportGenerator.tagAttribs(TABLE, TABLE_ATTRIBS));
        out.println(HtmlReportGenerator.tagBegin(TR));
        out.println(HtmlReportGenerator.headerTag(HeaderType.STANDARD, PARAM_VARIATION_HEADER, 1, 2));
        out.println(HtmlReportGenerator.tagEnd(TR));
        i2 = 0;
        while (i2 < paramNames.length) {
            out.println(HtmlReportGenerator.tagBegin(TR));
            out.println(String.valueOf(HtmlReportGenerator.tagBegin(TD)) + paramNames[i2] + HtmlReportGenerator.tagEnd(TD));
            out.println(String.valueOf(HtmlReportGenerator.tagBegin(TD)) + paramValues[i2] + HtmlReportGenerator.tagEnd(TD));
            out.println(HtmlReportGenerator.tagEnd(TR));
            ++i2;
        }
        out.println(HtmlReportGenerator.tagBegin(TR));
        out.println(HtmlReportGenerator.headerTag(HeaderType.STANDARD, REGISTER_VARIATION_HEADER, 1, 2));
        out.println(HtmlReportGenerator.tagEnd(TR));
        out.println(HtmlReportGenerator.tagEnd(TABLE));
    }

    private static void generateSelectedTestScripts(PrintWriter out, VTable paramTable) {
        VScriptConfig[] scs;
        out.println(BREAK_LINE);
        out.println(HtmlReportGenerator.tagAttribs(TABLE, TABLE_ATTRIBS));
        out.println(HtmlReportGenerator.tagBegin(TR));
        out.println(HtmlReportGenerator.headerTag(HeaderType.STANDARD, SELECTED_SCRIPTS_HEADER, 1, 2));
        out.println(HtmlReportGenerator.tagEnd(TR));
        out.println(HtmlReportGenerator.tagBegin(TR));
        out.println(HtmlReportGenerator.headerTag(HeaderType.STANDARD, SCRIPT_HEADER, 1, 1));
        out.println(HtmlReportGenerator.headerTag(HeaderType.STANDARD, ITERATION_HEADER, 1, 1));
        out.println(HtmlReportGenerator.tagEnd(TR));
        VScriptConfig[] vScriptConfigArray = scs = paramTable.getSelectedScriptConfigs();
        int n = scs.length;
        int n2 = 0;
        while (n2 < n) {
            VScriptConfig sc = vScriptConfigArray[n2];
            out.println(HtmlReportGenerator.tagBegin(TR));
            out.println(String.valueOf(HtmlReportGenerator.tagBegin(TD)) + sc.getScript().getName() + HtmlReportGenerator.tagEnd(TD));
            out.println(String.valueOf(HtmlReportGenerator.tagBegin(TD)) + sc.getPrevNumRuns() + HtmlReportGenerator.tagEnd(TD));
            out.println(HtmlReportGenerator.tagBegin(TR));
            ++n2;
        }
        out.println(HtmlReportGenerator.tagEnd(TABLE));
    }

    private static void generateSimpleTestExecSummary(PrintWriter out, VTable paramTable, VParamVariation cell) {
        VRunResult[] trrs = cell.getResults();
        out.println(BREAK_LINE);
        out.println(HtmlReportGenerator.tagAttribs(TABLE, TABLE_ATTRIBS));
        out.println(HtmlReportGenerator.tagBegin(TR));
        out.println(HtmlReportGenerator.headerTag(HeaderType.STANDARD, CELL_TESTS_SUMMARY_HEADER, 1, 3));
        out.println(HtmlReportGenerator.tagEnd(TR));
        out.println(HtmlReportGenerator.tagBegin(TR));
        out.println(HtmlReportGenerator.headerTag(HeaderType.STANDARD, SCRIPT_NAME_SUMMARY_HEADER, 1, 1));
        out.println(HtmlReportGenerator.headerTag(HeaderType.STANDARD, ITERATION_SUMMARY_HEADER, 1, 1));
        out.println(HtmlReportGenerator.headerTag(HeaderType.STANDARD, RESULT_SUMMARY_HEADER, 1, 1));
        out.println(HtmlReportGenerator.tagEnd(TR));
        if (trrs != null) {
            VRunResult[] vRunResultArray = trrs;
            int n = trrs.length;
            int n2 = 0;
            while (n2 < n) {
                VRunResult trr = vRunResultArray[n2];
                out.println(HtmlReportGenerator.tagBegin(TR));
                out.println(String.valueOf(HtmlReportGenerator.tagBegin(TD)) + trr.getScriptConfig().getScript().getName() + HtmlReportGenerator.tagEnd(TD));
                int iteration = trr.getNumRun() + 1;
                out.println(String.valueOf(HtmlReportGenerator.tagBegin(TD)) + iteration + HtmlReportGenerator.tagEnd(TD));
                out.println(String.valueOf(HtmlReportGenerator.tagBegin(TD)) + trr.getType().uiName() + HtmlReportGenerator.tagEnd(TD));
                out.println(HtmlReportGenerator.tagEnd(TR));
                ++n2;
            }
        }
        out.println(HtmlReportGenerator.tagEnd(TABLE));
    }

    private static void generateSmokeTableReport(PrintWriter out, VTable smokeTable, IReportGenerator.ReportData data) {
        out.println(HtmlReportGenerator.tagAttribs(TABLE, TABLE_ATTRIBS));
        List<VScriptConfig> tsus = smokeTable.getScriptsConfig();
        ArrayList<VScriptConfig> availableTsus = new ArrayList<VScriptConfig>();
        for (VScriptConfig tsu : tsus) {
            if (tsu == null || tsu.getScript().isSpecific()) continue;
            availableTsus.add(tsu);
        }
        int numRows = availableTsus.size();
        out.println(HtmlReportGenerator.tagBegin(TR));
        out.println(HtmlReportGenerator.headerTag(HeaderType.CORNER, CORNER_TEXT, 1, 1));
        String vLabel = smokeTable.getOptions().getvLabel();
        if (vLabel != null) {
            out.println(HtmlReportGenerator.headerTag(HeaderType.VPARAM_NAME, vLabel, 1, 1));
        }
        out.println(HtmlReportGenerator.tagEnd(TR));
        int i = 0;
        while (i < numRows) {
            out.println(HtmlReportGenerator.tagBegin(TR));
            out.println(HtmlReportGenerator.headerTag(HeaderType.HPARAM_VALUE, UtilsText.safeString((String)((VScriptConfig)availableTsus.get(i)).getScript().getName()), 1, 1));
            out.println(HtmlReportGenerator.cellTag(smokeTable.getParamVariation(new Point(i, 0)), false, false));
            out.println(HtmlReportGenerator.tagEnd(TR));
            ++i;
        }
        out.println(HtmlReportGenerator.tagEnd(TABLE));
        if (data.addInitConfigs) {
            HtmlReportGenerator.generateInitialConfiguration(out, smokeTable);
        }
        HtmlReportGenerator.generateSelectedTestScripts(out, smokeTable);
        if (data.addDetailedCellResults) {
            HtmlReportGenerator.generateDetailedResults(out, smokeTable, data.addUpdatedRegs, data.addErrCaptRegs);
        }
    }

    public static String headerTag(HeaderType type, String name, int rowspan, int colspan) {
        String[][] attribs = null;
        switch (type) {
            case HPARAM_NAME: {
                attribs = (String[][])HPARAM_NAME_ATTRIBS.clone();
                break;
            }
            case HPARAM_VALUE: {
                attribs = (String[][])HPARAM_VALUE_ATTRIBS.clone();
                break;
            }
            case VPARAM_NAME: {
                attribs = (String[][])VPARAM_NAME_ATTRIBS.clone();
                break;
            }
            case VPARAM_VALUE: {
                attribs = (String[][])VPARAM_VALUE_ATTRIBS.clone();
                break;
            }
            case CORNER: {
                attribs = (String[][])TABLE_CORNER_ATTRIBS.clone();
                break;
            }
            default: {
                attribs = (String[][])STANDARD_ATTRIBS.clone();
            }
        }
        attribs[1][1] = "" + rowspan;
        attribs[2][1] = "" + colspan;
        return String.valueOf(HtmlReportGenerator.tagAttribs(TH, attribs)) + name + HtmlReportGenerator.tagEnd(TH);
    }

    public static String tagAttribs(String name, String[][] attribs) {
        StringBuilder buff = new StringBuilder();
        buff.append(LESS_THAN).append(name).append(" ");
        int i = 0;
        while (i < attribs.length) {
            buff.append(attribs[i][0]);
            buff.append("=\"").append(attribs[i][1]).append("\" ");
            ++i;
        }
        buff.append(HIGHER_THAN);
        return buff.toString();
    }

    public static String tagBegin(String name) {
        return LESS_THAN + name + HIGHER_THAN;
    }

    public static String tagEnd(String name) {
        return "</" + name + HIGHER_THAN;
    }

    private void generateParamTableReport(PrintWriter out, VTable paramTable, IReportGenerator.ReportData data) {
        VParam[] hparams = paramTable.getHParams();
        VParam[] vparams = paramTable.getVParams();
        int numH = hparams.length;
        int numV = vparams.length;
        if (numH == 0 && numV == 1) {
            HtmlReportGenerator.generateParamTableReport_H0_V1(out, paramTable);
        }
        if (numH == 0 && numV > 1) {
            this.generateParamTableReport_H0_Vn(out, paramTable);
        }
        if (numH == 1 && numV == 0) {
            HtmlReportGenerator.generateParamTableReport_H1_V0(out, paramTable);
        }
        if (numH == 1 && numV == 1) {
            HtmlReportGenerator.generateParamTableReport_H1_V1(out, paramTable);
        }
        if (numH == 1 && numV > 1) {
            this.generateParamTableReport_H1_Vn(out, paramTable);
        }
        if (numH > 1 && numV == 0) {
            this.generateParamTableReport_Hn_V0(out, paramTable);
        }
        if (numH > 1 && numV == 1) {
            HtmlReportGenerator.generateParamTableReport_Hn_V1(out, paramTable);
        }
        if (numH > 1 && numV > 1) {
            this.generateParamTableReport_Hn_Vn(out, paramTable);
        }
        if (data.addInitConfigs) {
            HtmlReportGenerator.generateInitialConfiguration(out, paramTable);
        }
        HtmlReportGenerator.generateSelectedTestScripts(out, paramTable);
        if (data.addDetailedCellResults) {
            HtmlReportGenerator.generateDetailedResults(out, paramTable, data.addUpdatedRegs, data.addErrCaptRegs);
        }
    }

    private void generateParamTableReport_H0_Vn(PrintWriter out, VTable paramTable) {
    }

    private void generateParamTableReport_H1_Vn(PrintWriter out, VTable paramTable) {
    }

    private void generateParamTableReport_Hn_V0(PrintWriter out, VTable paramTable) {
    }

    private void generateParamTableReport_Hn_Vn(PrintWriter out, VTable paramTable) {
    }

    @Override
    public boolean generateReport(VTable[] tables, IReportGenerator.ReportData data) {
        if (tables.length == 0) {
            return false;
        }
        IDiagsProvider diagsProvider = this.model.getView().getScenarioView().getDiagsProvider();
        if (diagsProvider != null && this.exportOverlayReport(diagsProvider, data)) {
            return true;
        }
        try {
            Throwable throwable = null;
            Object var5_8 = null;
            try (PrintWriter pw = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(data.getConcreteFilePath()), StandardCharsets.UTF_8));){
                pw.println(HtmlReportGenerator.tagBegin(HTML));
                pw.println(HtmlReportGenerator.tagBegin(HEAD));
                pw.print(HtmlReportGenerator.tagBegin(TITLE));
                pw.print(DOC_TITLE);
                pw.print(HtmlReportGenerator.tagEnd(TITLE));
                pw.println(HtmlReportGenerator.tagEnd(HEAD));
                pw.println(HtmlReportGenerator.tagBegin(BODY));
                pw.print(HtmlReportGenerator.tagBegin(H3));
                pw.print(MAIN_HEADER_PREFIX);
                String dateString = DateFormat.getDateInstance(0, Locale.getDefault()).format(new Date());
                pw.print(dateString);
                pw.print(HtmlReportGenerator.tagEnd(H3));
                VTable[] vTableArray = tables;
                int n = tables.length;
                int n2 = 0;
                while (n2 < n) {
                    VTable table = vTableArray[n2];
                    if (table.getState() != VTable.TableState.CLEAN) {
                        this.generateTableReport(pw, table, data);
                    }
                    ++n2;
                }
                pw.println(HtmlReportGenerator.tagEnd(BODY));
                pw.println(HtmlReportGenerator.tagEnd(HTML));
                pw.flush();
                pw.close();
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (SecurityException noWriteAccess) {
            throw noWriteAccess;
        }
        catch (Exception e) {
            LOGGER.severe(String.valueOf(UtilsText.safeString((String)Messages.HtmlReportGenerator_17)) + e.getMessage());
            return false;
        }
        return true;
    }

    public boolean exportOverlayReport(IDiagsProvider diagsProvider, IReportGenerator.ReportData data) {
        VScenarioPresentation vScenario;
        VStagePresentation stage;
        Canvas canvas = this.model.getView().getScenarioView().getCanvas();
        if (canvas != null && diagsProvider.isOverlayCanvas(canvas) && (stage = this.model.getSelectedStage()) != null && (vScenario = stage.getSelectedScenario()) != null) {
            VScriptParam.Options options;
            VScriptParamValue scriptParamValue;
            VScenario scenario = vScenario.getModel();
            VScriptConfig selectedScriptConfig = vScenario.getSelectedScriptConfig();
            if (selectedScriptConfig != null && (scriptParamValue = selectedScriptConfig.getParamValue("diag_lane")) != null && (options = scriptParamValue.getParam().getOptions()) != null) {
                Integer dqPerByte = Arrays.asList(options.getNames()).stream().filter(s -> s.startsWith("DRAM DQ")).toArray().length;
                dqPerByte = dqPerByte != 0 ? dqPerByte : Integer.valueOf(options.getNames().length - 1);
                diagsProvider.exportCharts(data.getConcreteFilePath(), scenario.getName(), scenario.getId(), dqPerByte);
                return true;
            }
        }
        return false;
    }

    private void generateTableReport(PrintWriter out, VTable table, IReportGenerator.ReportData data) {
        out.print(HtmlReportGenerator.tagBegin(H4));
        out.print(table.getQualifiedName());
        out.print(HtmlReportGenerator.tagEnd(H4));
        if (table.hasScriptParam()) {
            HtmlReportGenerator.generateSmokeTableReport(out, table, data);
        } else {
            this.generateParamTableReport(out, table, data);
        }
    }

    @Override
    public IReportGenerator.ReportType getReportType() {
        return this.type;
    }

    private static enum HeaderType {
        HPARAM_VALUE,
        HPARAM_NAME,
        VPARAM_VALUE,
        VPARAM_NAME,
        CORNER,
        STANDARD;

    }
}

