/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.mem.validation.reports;

import com.nxp.swtools.common.utils.files.UtilsFile;
import com.nxp.swtools.common.utils.logging.LogManager;
import com.nxp.swtools.mem.validation.Messages;
import com.nxp.swtools.mem.validation.model.VPresentationModel;
import com.nxp.swtools.mem.validation.model.scenarios.IScenarioElement;
import com.nxp.swtools.mem.validation.model.scenarios.VScenario;
import com.nxp.swtools.mem.validation.model.scenarios.VTable;
import com.nxp.swtools.mem.validation.reports.IReportGenerator;
import com.nxp.swtools.mem.validation.table.params.VParamVariation;
import com.nxp.swtools.mem.validation.utils.TestResultsLogger;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.util.logging.Logger;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.ImageLoader;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Canvas;

public class ImageReportGenerator
implements IReportGenerator {
    private static final Logger LOGGER = LogManager.getLogger(ImageReportGenerator.class);
    private IReportGenerator.ReportType type = IReportGenerator.ReportType.JPG;
    private VPresentationModel model;

    public ImageReportGenerator(VPresentationModel model, IReportGenerator.ReportType type) {
        this.type = type;
        this.model = model;
    }

    @Override
    public IReportGenerator.ReportType getReportType() {
        return this.type;
    }

    @Override
    public boolean generateReport(VTable[] tables, IReportGenerator.ReportData data) {
        IScenarioElement vScenario;
        boolean isCAEye = false;
        VTable table = tables[0];
        IScenarioElement scenario = table.getParent();
        if (scenario != null && (vScenario = scenario.getParent()) instanceof VScenario) {
            VScenario validationScenario = (VScenario)vScenario;
            isCAEye = validationScenario.isCAEye();
        }
        if (isCAEye) {
            String figureFilePath;
            VParamVariation cell = table.getParamVariation(new Point(0, 0));
            if (cell != null && Files.exists(Paths.get(figureFilePath = TestResultsLogger.getFigureLogFilePath(cell), new String[0]), new LinkOption[0])) {
                File src = new File(figureFilePath);
                File dest = new File(data.getConcreteFilePath());
                try {
                    UtilsFile.copy((File)src, (File)dest, (boolean)true);
                }
                catch (IOException e) {
                    LOGGER.severe(e.getLocalizedMessage());
                    return false;
                }
                return true;
            }
            return false;
        }
        Canvas canvas = this.model.getView().getScenarioView().getCanvas();
        if (canvas != null) {
            Image img = null;
            GC imageGC = null;
            try {
                try {
                    img = new Image((Device)canvas.getDisplay(), canvas.getSize().x, canvas.getSize().y);
                    imageGC = new GC((Drawable)img);
                    canvas.print(imageGC);
                    ImageLoader imgLoader = new ImageLoader();
                    imgLoader.data = new ImageData[]{img.getImageData()};
                    imgLoader.save(data.getConcreteFilePath(), 4);
                }
                catch (Exception e) {
                    LOGGER.warning(Messages.ReportGeneratorcannotGenerate);
                    LOGGER.warning(e.getLocalizedMessage());
                    if (img != null) {
                        img.dispose();
                    }
                    if (imageGC != null) {
                        imageGC.dispose();
                    }
                }
            }
            finally {
                if (img != null) {
                    img.dispose();
                }
                if (imageGC != null) {
                    imageGC.dispose();
                }
            }
            return true;
        }
        return false;
    }
}

