/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.mem.validation.ui;

import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.mem.validation.Messages;
import com.nxp.swtools.mem.validation.ui.ByteConverter;
import com.nxp.swtools.mem.validation.ui.EnableEnumeration;
import com.nxp.swtools.mem.validation.ui.NumberVerifier;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;

public class CustomText
extends Composite {
    private Text text;
    @Nullable
    private ToolBar toolBar;
    @Nullable
    private ToolItem toolItem;
    @Nullable
    Menu radixMenu = null;
    private int buttonStyle = 0;
    private transient EnableEnumeration bases = new EnableEnumeration(new String[]{Messages.UnitKB, Messages.UnitMB, Messages.UnitGB}, Messages.UnitKB);
    @Nullable
    private Listener oldVerifier = null;
    @Nullable
    private transient ByteConverter t2mConv;
    @Nullable
    private transient ByteConverter m2tConv;
    @Nullable
    private transient ByteConverter textConv;
    private int id = 0;

    public CustomText(Composite parent, int style) {
        super(parent, style);
        GridLayout gridLayout = new GridLayout(2, false);
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        this.setLayout((Layout)gridLayout);
        this.text = new Text((Composite)this, 2048);
        this.text.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.toolBar = new ToolBar((Composite)this, 0x820000);
        this.toolBar.setLayoutData((Object)new GridData(0x1000000, 0x1000000, false, false, 1, 1));
        this.toolItem = null;
    }

    public CustomText(Composite parent, int style, boolean withToolbar) {
        super(parent, style);
        GridLayout gridLayout = new GridLayout(2, false);
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        this.setLayout((Layout)gridLayout);
        this.text = new Text((Composite)this, 2048);
        this.text.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        if (withToolbar) {
            this.toolBar = new ToolBar((Composite)this, 0x820000);
            this.toolBar.setLayoutData((Object)new GridData(0x1000000, 0x1000000, false, false, 1, 1));
        } else {
            this.toolBar = null;
        }
        this.toolItem = null;
    }

    public void addController(EnableEnumeration basesEnum) {
        this.bases = basesEnum;
        this.t2mConv = new ByteConverter();
        this.m2tConv = new ByteConverter();
        this.textConv = new ByteConverter();
        if (this.toolBar == null) {
            this.setState();
            return;
        }
        if (this.bases.getEnabledValues().length <= 1) {
            this.createButton(8);
        } else {
            this.createButton(4);
        }
        this.setState();
        if (this.toolItem != null) {
            this.toolItem.addSelectionListener(new SelectionListener(){

                public void widgetDefaultSelected(SelectionEvent e) {
                }

                public void widgetSelected(SelectionEvent e) {
                    if (e.detail == 4) {
                        if (CustomText.this.radixMenu == null) {
                            CustomText.this.createMenu();
                        }
                        if (CustomText.this.radixMenu != null) {
                            CustomText.this.radixMenu.setVisible(true);
                        }
                    } else {
                        CustomText.this.switchState();
                        CustomText.this.convert();
                    }
                }
            });
        }
    }

    protected void checkSubclass() {
    }

    public void convert() {
        String newBase = this.bases.getCurrentValue();
        ByteConverter textConvLoc = this.textConv;
        if (textConvLoc != null && newBase != null) {
            String newVal = (String)textConvLoc.convert(this.text.getText());
            assert (newVal != null);
            this.text.setText(newVal);
            textConvLoc.setBases(newBase, Messages.UnitB);
        }
    }

    public ToolItem createButton(int style) {
        ToolItem toolItemLoc = this.toolItem;
        if (toolItemLoc != null) {
            if (this.buttonStyle == style) {
                return toolItemLoc;
            }
            toolItemLoc.dispose();
            toolItemLoc = new ToolItem(this.toolBar, style);
            return toolItemLoc;
        }
        this.toolItem = new ToolItem(this.toolBar, style);
        return this.toolItem;
    }

    void createMenu() {
        this.radixMenu = new Menu((Control)this.text.getParent());
        String[] basesNames = this.bases.getEnabledValues();
        if (basesNames.length <= 1) {
            return;
        }
        int i = 0;
        while (i < basesNames.length) {
            MenuItem menuItem = new MenuItem(this.radixMenu, 0);
            menuItem.setText(basesNames[i].toUpperCase());
            final String baseName = basesNames[i];
            menuItem.addSelectionListener(new SelectionListener(){

                public void widgetDefaultSelected(SelectionEvent e) {
                }

                public void widgetSelected(SelectionEvent e) {
                    if (CustomText.this.switchState(baseName)) {
                        CustomText.this.convert();
                    }
                }
            });
            ++i;
        }
    }

    public @Nullable ToolItem getButton() {
        return this.toolItem;
    }

    public int getID() {
        return this.id;
    }

    public @Nullable Menu getMenu() {
        return this.radixMenu;
    }

    public @Nullable String getState() {
        return this.bases.getCurrentValue();
    }

    public Text getText() {
        return this.text;
    }

    public void hideButton() {
        if (this.toolBar != null) {
            this.toolBar.setVisible(false);
        }
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.text.setEnabled(enabled);
        if (this.toolBar != null) {
            this.toolBar.setEnabled(enabled);
        }
    }

    public void setID(int nID) {
        this.id = nID;
    }

    public void setState() {
        String val = this.bases.getCurrentValue();
        if (val == null) {
            return;
        }
        if (this.toolItem != null) {
            this.toolItem.setText(val.toUpperCase());
        }
        NumberVerifier newVerifier = new NumberVerifier(val);
        if (this.oldVerifier != null) {
            this.text.removeListener(25, this.oldVerifier);
        }
        this.text.addListener(25, (Listener)newVerifier);
        this.oldVerifier = newVerifier;
        if (this.t2mConv != null) {
            this.t2mConv.setBases(val, Messages.UnitKB);
        }
        if (this.m2tConv != null) {
            this.m2tConv.setBases(Messages.UnitKB, val);
        }
        ToolItem toolItemLoc = this.toolItem;
        if (this.toolBar != null && toolItemLoc != null) {
            if (val.equals(Messages.UnitKB)) {
                toolItemLoc.setToolTipText(Messages.TooltipKB);
            } else if (val.equals(Messages.UnitMB)) {
                toolItemLoc.setToolTipText(Messages.TooltipMB);
            } else if (val.equals(Messages.UnitGB)) {
                toolItemLoc.setToolTipText(Messages.TooltipGB);
            } else {
                this.text.setText(Messages.Err);
                toolItemLoc.setToolTipText(String.format(Messages.TooltipRadixErr, val));
            }
        }
        this.layout();
    }

    public void setText(String _text) {
        this.text.setText(_text);
    }

    public void switchState() {
        String oldBase = this.bases.getCurrentValue();
        this.bases.nextValue();
        String newBase = this.bases.getCurrentValue();
        if (oldBase != null && newBase != null) {
            if (this.textConv != null) {
                this.textConv.setBases(oldBase, newBase);
            }
            if (oldBase.equals(newBase)) {
                return;
            }
        }
        this.setState();
    }

    public boolean switchState(String newBase) {
        String oldBase = this.bases.getCurrentValue();
        if (oldBase != null && oldBase.equals(newBase)) {
            return false;
        }
        this.bases.setCurrentValue(newBase);
        if (this.textConv != null && oldBase != null) {
            this.textConv.setBases(oldBase, newBase);
        }
        this.setState();
        return true;
    }
}

