/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.ext.ide.ui.dialogs;

import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.TableColumnLayout;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;

public abstract class AbstractTableDialog
extends TitleAreaDialog {
    private final int defaultRowsNumber;
    protected TableViewer tableViewer;
    private String title;
    private String message;

    public AbstractTableDialog(Shell shell, String title, String message, int rows) {
        super(shell);
        this.title = title;
        this.message = message;
        this.defaultRowsNumber = rows;
    }

    protected Control createDialogArea(Composite parent) {
        this.setTitle(this.title);
        this.setMessage(this.message);
        this.setHelpAvailable(false);
        Composite content = (Composite)super.createDialogArea(parent);
        Composite composite = new Composite(content, 0);
        GridDataFactory.fillDefaults().applyTo((Control)composite);
        this.createTableViewer(composite);
        this.createTableColumns(composite);
        this.setLayout(composite);
        this.setContentProvider(this.tableViewer);
        this.setContent(this.tableViewer);
        this.tableViewer.refresh();
        return parent;
    }

    private void setLayout(Composite composite) {
        GridData data = new GridData(4, 4, true, false);
        data.heightHint = (this.defaultRowsNumber + 2) * this.tableViewer.getTable().getItemHeight();
        composite.setLayoutData((Object)data);
    }

    protected void createTableViewer(Composite composite) {
        this.tableViewer = new TableViewer(composite, 68096);
        this.tableViewer.getTable().setHeaderVisible(true);
        this.tableViewer.getTable().setLinesVisible(true);
    }

    public TableViewerColumn createColumn(TableColumnLayout tableLayout, ColumnWeightData columnData, int style, String message) {
        TableViewerColumn column = new TableViewerColumn(this.tableViewer, style);
        column.getColumn().setText(message);
        tableLayout.setColumnData((Widget)column.getColumn(), (ColumnLayoutData)columnData);
        return column;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(this.title);
    }

    protected abstract void setContent(TableViewer var1);

    protected abstract void setContentProvider(TableViewer var1);

    protected abstract void createTableColumns(Composite var1);
}

