/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.cle.cdt.migration.actions.project.configuration;

import com.nxp.s32ds.cle.cdt.project.configuration.core.ProjectConfigurationUtils;
import com.nxp.s32ds.cle.cdt.project.configuration.core.updaters.ProjectSettingsUpdater;
import com.nxp.s32ds.cle.cdt.project.configuration.core.updaters.ProjectSettingsUpdaters;
import com.nxp.s32ds.cle.cdt.project.configuration.core.updaters.UpdateOperation;
import com.nxp.s32ds.cle.runtime.migration.action.MigrationAction;
import com.nxp.s32ds.cle.runtime.migration.annotation.MigrationEntityAnnotation;
import com.nxp.s32ds.cle.runtime.migration.annotation.MigrationPropertyAnnotation;
import com.nxp.s32ds.cle.runtime.migration.core.MigrationsAssert;
import java.util.List;
import java.util.stream.Stream;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;

@MigrationEntityAnnotation(name="Replace the values of the source entry for CDT toolchains and tools.", description="Replace source entry values for CDT toolchains and tools.\nIt is shortcut for ModifySourceEntry that performs the 'remove' operation for old values and 'add' operation for new ones.")
public class ReplaceSourceEntryValueAction
implements MigrationAction {
    @MigrationPropertyAnnotation(name="oldEntryValue", description="The old value of entry.")
    private List<String> oldEntryValues;
    @MigrationPropertyAnnotation(name="newEntryValue", description="The new value of entry.")
    private List<String> newEntryValues;

    public void perform(IProject project, IProgressMonitor monitor) throws CoreException {
        ProjectSettingsUpdater optionUpdater = ProjectSettingsUpdaters.getOptionUpdater();
        MigrationsAssert.assertIsOk(ProjectConfigurationUtils.getProjectConfigurations((IProject)project).stream().flatMap(c -> Stream.of(optionUpdater.update(c, null, this.oldEntryValues, UpdateOperation.REMOVE), optionUpdater.update(c, null, this.newEntryValues, UpdateOperation.ADD))));
    }
}

