/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.ext.rcp.internal.variables;

import com.nxp.s32ds.ext.rcp.internal.variables.VariableMessages;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.eclipse.core.internal.localstore.SafeChunkyInputStream;
import org.eclipse.osgi.util.NLS;

public class WorkspaceProjectLocations {
    private static String PROJECTS = ".metadata/.plugins/org.eclipse.core.resources/.projects";
    private static String LOCATION = ".location";
    private static String URI_PREFIX = "URI//";

    public static String getProjectPath(String wsPath, String projectName) throws IOException {
        if (wsPath == null) {
            throw new IllegalArgumentException("Argument wsPath is null.");
        }
        if (projectName == null) {
            throw new IllegalArgumentException("Argument projectName is null.");
        }
        Path projectLocation = Paths.get(wsPath, new String[0]).resolve(PROJECTS).resolve(projectName).resolve(LOCATION);
        if (!Files.exists(projectLocation, new LinkOption[0])) {
            throw new FileNotFoundException(projectLocation.toString());
        }
        SafeChunkyInputStream input = new SafeChunkyInputStream(projectLocation.toFile(), 500);
        Throwable throwable = null;
        Object var5_6 = null;
        try (DataInputStream dataIn = new DataInputStream((InputStream)input);){
            String location = dataIn.readUTF();
            if (location.length() > 0) {
                if (location.startsWith(URI_PREFIX)) {
                    URI uri = URI.create(location.substring(URI_PREFIX.length()));
                    return new File(uri).toString();
                }
                return location;
            }
            throw new IOException(NLS.bind((String)VariableMessages.WorkspaceProjectLocations_error_of_reading_the_project_0_location, (Object)projectName));
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }
}

