/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.ext.ide.validation.core;

import com.nxp.s32ds.ext.ide.core.internal.ExtIdeCoreActivator;
import com.nxp.s32ds.ext.ide.internal.validation.core.Messages;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.NLS;

public class ToolChainVersionValidationMarker {
    public static final String MARKER_ID = "com.nxp.s32ds.ext.ide.validation.core.toolchain.version.validation.marker";

    public static IStatus createMarker(IProject project) {
        try {
            IMarker marker = project.createMarker(MARKER_ID);
            if (marker.exists()) {
                marker.setAttribute("severity", 2);
                String fixMsg = NLS.bind((String)Messages.ToolChainVersionValidationMarker_UpdateToolchainVersionMessage, (Object)project.getName());
                marker.setAttribute("message", (Object)fixMsg);
                marker.setAttribute("location", (Object)project.getName());
            }
        }
        catch (CoreException ce) {
            ExtIdeCoreActivator.getInstance().logError(Messages.ToolChainVersionValidationMarker_error_during_marker_initialization_process, ce);
            return ce.getStatus();
        }
        return Status.OK_STATUS;
    }

    public static IStatus delete(IProject project) {
        try {
            project.deleteMarkers(MARKER_ID, true, 2);
        }
        catch (CoreException ce) {
            ExtIdeCoreActivator.getInstance().logError(Messages.ToolChainVersionValidationMarker_error_during_marker_deletion_process, ce);
            return ce.getStatus();
        }
        return Status.OK_STATUS;
    }

    public static boolean containsMarker(IProject project) {
        try {
            IMarker[] markers = project.findMarkers(MARKER_ID, true, 2);
            if (markers != null && markers.length > 0) {
                return true;
            }
        }
        catch (CoreException e) {
            ExtIdeCoreActivator.getInstance().logError(Messages.ToolChainVersionValidationMarker_error_during_marker_search_process, e);
        }
        return false;
    }
}

