/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.rcp.modular.internal;

import com.nxp.s32ds.rcp.modular.HWFamily;
import com.nxp.s32ds.rcp.modular.ModularFeature;
import com.nxp.s32ds.rcp.modular.ModularLicense;
import com.nxp.s32ds.rcp.modular.ModularPack;
import com.nxp.s32ds.rcp.modular.internal.CompatibilitiesModularUtils;
import com.nxp.s32ds.rcp.modular.internal.Messages;
import com.nxp.s32ds.rcp.modular.internal.ModularObjectImplementation;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.metadata.ILicense;

public class ModularPackImplementation
extends ModularObjectImplementation
implements ModularPack {
    private static final String LICENSE_ITEM_SPLITTER = ";";
    private static final String LICENSE_GROUP_SPLITTER = "&";
    private Collection<ModularFeature> features;
    private Collection<ILicense> licenses = new ArrayList<ILicense>();
    private boolean isUninstalled = true;
    private String icon;
    private Set<String> thirdPartyIds;
    private final Set<ModularLicense> licenseData = new HashSet<ModularLicense>();
    private String p2featureId;
    private Collection<HWFamily> hWFamilies;
    private String p2featureVersion;
    private Map<String, Set<String>> supportProductName2Vesrions;
    private String errorMessage;
    private Set<IInstallableUnit> requirementUnits;
    private IInstallableUnit installableUnit;
    private Set<String> categories;
    private final HashMap<String, String> attributes = new HashMap();

    public ModularPackImplementation(String id, String name, String description, String version, URI uri) {
        super(id, name, description, version, uri);
        this.features = new ArrayList<ModularFeature>();
        this.thirdPartyIds = new HashSet<String>();
        this.hWFamilies = new ArrayList<HWFamily>();
        this.supportProductName2Vesrions = new HashMap<String, Set<String>>();
        this.requirementUnits = new HashSet<IInstallableUnit>();
        this.categories = new HashSet<String>();
    }

    public ModularPackImplementation(String id, String name, String description, String version, URI uri, Map<String, String> attributes) {
        this(id, name, description, version, uri);
        this.attributes.putAll(attributes);
    }

    public void addModularFeature(ModularFeature modularFeature) {
        this.features.add(modularFeature);
    }

    @Override
    public Collection<ModularFeature> getFeatures() {
        return Collections.unmodifiableCollection(this.features);
    }

    @Override
    public Collection<ILicense> getLicenses() {
        return Collections.unmodifiableCollection(this.licenses);
    }

    public void addLicense(ILicense license) {
        this.licenses.add(license);
    }

    public void setIcon(String icon) {
        this.icon = icon;
    }

    @Override
    public String getIcon() {
        return this.icon;
    }

    public void addModularLicense(String licenseParams, String title) {
        String[] licenses;
        String[] stringArray = licenses = licenseParams.split(LICENSE_GROUP_SPLITTER);
        int n = licenses.length;
        int n2 = 0;
        while (n2 < n) {
            int licenseParamSize;
            String licens = stringArray[n2];
            String[] split = licens.split(LICENSE_ITEM_SPLITTER);
            if (split.length == (licenseParamSize = 3)) {
                this.licenseData.add(new ModularLicense(split[0], split[1], split[2], title));
            }
            ++n2;
        }
    }

    @Override
    public Set<ModularLicense> getLicenseData() {
        return this.licenseData;
    }

    @Override
    public boolean isUninstallable() {
        return this.isUninstalled;
    }

    public void setUninstall(boolean isUninstalled) {
        this.isUninstalled = isUninstalled;
    }

    public void addAllThirdPartyIds(Collection<String> thirdPartyIds) {
        this.thirdPartyIds.addAll(thirdPartyIds);
    }

    @Override
    public Set<String> getThirdPartyIds() {
        return Collections.unmodifiableSet(this.thirdPartyIds);
    }

    public void setP2FeatureId(String featureId) {
        this.p2featureId = featureId;
    }

    @Override
    public String getP2featureId() {
        return this.p2featureId;
    }

    public void addHwFamily(HWFamily hwFamily) {
        this.hWFamilies.add(hwFamily);
    }

    @Override
    public Collection<HWFamily> getHWFamilies() {
        return Collections.unmodifiableCollection(this.hWFamilies);
    }

    @Override
    public String getP2featureVersion() {
        return this.p2featureVersion;
    }

    public void setP2featureVersion(String p2featureVersion) {
        this.p2featureVersion = p2featureVersion;
    }

    public void addSupportProduct(String productName, Set<String> productVersion) {
        this.supportProductName2Vesrions.put(productName, productVersion);
    }

    @Override
    public Map<String, Set<String>> getSupportProductName2Versions() {
        return this.supportProductName2Vesrions;
    }

    public String toString() {
        Object[] strings = new String[]{this.getId(), this.getName(), this.getVersion()};
        return Messages.bind((String)Messages.ModularPackImplementation_ToString, (Object[])strings);
    }

    @Override
    public boolean isSuitablePackage(String platformName, String version) {
        Map<String, Set<String>> supporProductName2Versions = this.getSupportProductName2Versions();
        if (this.supportProductName2Vesrions.isEmpty()) {
            return true;
        }
        Set<String> set = supporProductName2Versions.get(platformName);
        if (set == null) {
            return false;
        }
        if (set.contains(version)) {
            return true;
        }
        return CompatibilitiesModularUtils.isCompatiblePackForPlatform(this);
    }

    @Override
    public String getErrorMessage() {
        return this.errorMessage;
    }

    public void setErrorMessage(String errorMessage) {
        this.errorMessage = errorMessage;
    }

    public void addRequarmentUnits(Set<IInstallableUnit> installableUnits) {
        this.requirementUnits.addAll(installableUnits);
    }

    @Override
    public Set<IInstallableUnit> getRequirementUnits() {
        return this.requirementUnits;
    }

    public void setIInstallableUnit(IInstallableUnit installableUnit) {
        this.installableUnit = installableUnit;
    }

    @Override
    public IInstallableUnit getInstallableUnit() {
        return this.installableUnit;
    }

    @Override
    public Set<String> getCategories() {
        return Collections.unmodifiableSet(this.categories);
    }

    public void addCategory(String category) {
        this.categories.add(category);
    }

    @Override
    public int hashCode() {
        return Objects.hashCode(this.id);
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ModularPackImplementation)) {
            return false;
        }
        ModularPackImplementation modularPack = (ModularPackImplementation)o;
        return Objects.equals(this.id, modularPack.getId());
    }

    @Override
    public String getProperty(String key) {
        return this.attributes.getOrDefault(key, "");
    }
}

