/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.resourcetables.model.config;

import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.common.utils.lang.CollectionsUtils;
import com.nxp.swtools.common.utils.stream.CollectorsUtils;
import com.nxp.swtools.common.utils.text.UtilsText;
import com.nxp.swtools.resourcetables.model.config.ArrayConfig;
import com.nxp.swtools.resourcetables.model.config.CacheHelper;
import com.nxp.swtools.resourcetables.model.config.ChildContext;
import com.nxp.swtools.resourcetables.model.config.ComponentsProvider;
import com.nxp.swtools.resourcetables.model.config.ExpressionFunctions;
import com.nxp.swtools.resourcetables.model.config.ICacheable;
import com.nxp.swtools.resourcetables.model.config.IChild;
import com.nxp.swtools.resourcetables.model.config.IChildProvidable;
import com.nxp.swtools.resourcetables.model.config.IComponentConfig;
import com.nxp.swtools.resourcetables.model.config.IPresettable;
import com.nxp.swtools.resourcetables.model.config.ISettingConfig;
import com.nxp.swtools.resourcetables.model.config.IStructuredSettingConfig;
import com.nxp.swtools.resourcetables.model.config.ScalarConfig;
import com.nxp.swtools.resourcetables.model.config.StructConfig;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;

public class ChildProviderHelper {
    public static final String DOLLAR_ROOT = "$root";
    public static final String DOLLAR_GROUP = "$group";
    public static final String DOLLAR_COMPONENT = "$component";
    public static final String DOLLAR_GLOBAL = "$global";
    public static final String DOLLAR_INSTANCE = "$instance";
    public static final String DOLLAR_CONFIG_SET = "$configSet";
    public static final String DOLLAR_THIS = "$this";
    public static final String DOLLAR_PARENT = "$parent";

    public static @Nullable IChild getChildRelative(IChildProvidable providable, String id) {
        IChild child;
        int dotIdx = id.indexOf(".");
        String fstPart = id;
        String sndPart = "";
        if (dotIdx >= 0) {
            fstPart = id.substring(0, dotIdx);
            sndPart = id.substring(dotIdx + ".".length(), id.length());
        }
        if ((child = providable.getChild(fstPart)) instanceof IChildProvidable) {
            if (sndPart.isEmpty()) {
                return child;
            }
            return ChildProviderHelper.getChildRelative((IChildProvidable)child, sndPart);
        }
        return sndPart.isEmpty() && child != null ? child : null;
    }

    public static @Nullable IChild getChild(ChildContext context, String id) {
        int dotIdx = id.indexOf(".");
        String fstPart = id;
        String sndPart = "";
        if (dotIdx >= 0) {
            fstPart = id.substring(0, dotIdx);
            sndPart = id.substring(dotIdx + ".".length(), id.length());
        }
        IChild relativeParent = context.getCurrent();
        String relativeId = id;
        if (fstPart.startsWith("$")) {
            relativeId = sndPart;
            relativeParent = ChildProviderHelper.getValueOfDollarVariable(context, fstPart);
        }
        if (relativeId.isEmpty()) {
            return relativeParent;
        }
        return relativeParent instanceof IChildProvidable ? ChildProviderHelper.getChildRelative((IChildProvidable)relativeParent, relativeId) : null;
    }

    public static @Nullable IChild getSuccessor(IStructuredSettingConfig setting, String name) {
        IChild directSuccessor = ChildProviderHelper.getChild(setting.getChildContext(), name);
        if (directSuccessor != null) {
            return directSuccessor;
        }
        return (IChild)CollectionsUtils.nullableOptionalGet(ChildProviderHelper.getAllSettings(setting).stream().filter(child -> child.getName().equals(name)).findFirst());
    }

    public static List<IChild> getSuccessors(IStructuredSettingConfig setting, String name) {
        IChild directSuccessor = ChildProviderHelper.getChild(setting.getChildContext(), name);
        if (directSuccessor != null) {
            return Arrays.asList(directSuccessor);
        }
        return (List)ChildProviderHelper.getAllSettings(setting).stream().filter(child -> child.getName().equals(name)).collect(CollectorsUtils.toList());
    }

    public static @Nullable IChild getValueOfDollarVariable(ChildContext context, String dollarVariable) {
        IChild result = null;
        switch (dollarVariable) {
            case "$parent": {
                result = context.getParent();
                break;
            }
            case "$this": {
                result = context.getCurrent();
                break;
            }
            case "$configSet": {
                result = context.getConfigSetConfig();
                break;
            }
            case "$instance": {
                result = context.getComponentInstanceConfig();
                break;
            }
            case "$global": {
                IComponentConfig componentConfig = context.getComponentConfig();
                result = componentConfig != null ? componentConfig.getGlobalConfigSet() : null;
                break;
            }
            case "$component": {
                result = context.getComponentConfig();
                break;
            }
            case "$group": {
                result = context.getFunctionalGroup();
                break;
            }
            case "$root": {
                result = context.getRoot();
                break;
            }
            case "$components": {
                result = new ComponentsProvider(context.getRoot());
                break;
            }
        }
        return result;
    }

    public static boolean typesOfChildrenEquals(IStructuredSettingConfig left, StructConfig right) {
        List<String> leftPath = ChildProviderHelper.getTypesOfAllChildren(left);
        Iterator<String> leftPathIterator = leftPath.iterator();
        List<String> rightPath = ChildProviderHelper.getTypesOfAllChildren(right);
        Iterator<String> rightPathIterator = rightPath.iterator();
        while (leftPathIterator.hasNext() && rightPathIterator.hasNext()) {
            String rightItem;
            @Nullable String leftItem = leftPathIterator.next();
            if (Objects.equals(leftItem, rightItem = rightPathIterator.next())) continue;
            return false;
        }
        if (leftPathIterator.hasNext()) {
            return false;
        }
        return !rightPathIterator.hasNext();
    }

    public static List<ISettingConfig> getAllSettings(IChildProvidable root) {
        LinkedList<ISettingConfig> subPath = new LinkedList<ISettingConfig>();
        for (IChild iChild : root.getChildren()) {
            if (iChild instanceof ISettingConfig) {
                subPath.add((ISettingConfig)iChild);
            }
            if (!(iChild instanceof IStructuredSettingConfig)) continue;
            List<ISettingConfig> childrenOfChild = ChildProviderHelper.getAllSettings((IStructuredSettingConfig)iChild);
            subPath.addAll(childrenOfChild);
        }
        return subPath;
    }

    public static List<ISettingConfig> getAllSettings(IStructuredSettingConfig node) {
        LinkedList<ISettingConfig> subPath = new LinkedList<ISettingConfig>();
        for (ISettingConfig iSettingConfig : node.getChildren()) {
            subPath.add(iSettingConfig);
            if (!(iSettingConfig instanceof IStructuredSettingConfig)) continue;
            List<ISettingConfig> childrenOfChild = ChildProviderHelper.getAllSettings((IStructuredSettingConfig)iSettingConfig);
            subPath.addAll(childrenOfChild);
        }
        return subPath;
    }

    public static List<String> getTypesOfAllChildren(IStructuredSettingConfig node) {
        LinkedList<String> subPath = new LinkedList<String>();
        for (ISettingConfig iSettingConfig : node.getChildren()) {
            subPath.add(UtilsText.safeString((String)iSettingConfig.getTypeName()));
            if (iSettingConfig instanceof ArrayConfig) {
                ArrayConfig arrayConfig = (ArrayConfig)iSettingConfig;
                subPath.add(arrayConfig.getTypeName());
                continue;
            }
            if (!(iSettingConfig instanceof IStructuredSettingConfig)) continue;
            List<ISettingConfig> childrenOfChild = ChildProviderHelper.getAllSettings((IStructuredSettingConfig)iSettingConfig);
            childrenOfChild.forEach(childOfChild -> {
                boolean bl = subPath.add(UtilsText.safeString((String)childOfChild.getTypeName()));
            });
        }
        return subPath;
    }

    public static List<IChild> getAllChildren(IChild child) {
        if (child instanceof ICacheable) {
            return CacheHelper.getValueCaching((ICacheable)((Object)child), String.valueOf(child.getId()) + "*all_children", () -> ChildProviderHelper.getAllChildrenInternal(child));
        }
        return ChildProviderHelper.getAllChildrenInternal(child);
    }

    private static List<IChild> getAllChildrenInternal(IChild child) {
        if (child instanceof IChildProvidable) {
            IChildProvidable root = (IChildProvidable)child;
            ArrayList<IChild> subPath = new ArrayList<IChild>();
            for (IChild iChild : root.getChildren()) {
                subPath.add(iChild);
                if (!(iChild instanceof IChildProvidable)) continue;
                List<IChild> childrenOfChild = ChildProviderHelper.getAllChildren(iChild);
                subPath.addAll(childrenOfChild);
            }
            return subPath;
        }
        return Collections.emptyList();
    }

    public static void unsetParentQuickSelections(IChild child) {
        IChildProvidable parent = child.getChildContext().getParent();
        while (parent != null) {
            if (parent instanceof IPresettable) {
                ((IPresettable)((Object)parent)).setQuickSelection(null);
            }
            parent = parent.getChildContext().getParent();
        }
    }

    public static void handleUniqueIntegersInternal(List<ScalarConfig> settings) {
        HashMap<Object, List<ScalarConfig>> toSkip = new HashMap<Object, List<ScalarConfig>>();
        for (ScalarConfig scalar : settings) {
            Object optionValue = scalar.getOptionValue("UNIQUE_ID_GROUP");
            if (optionValue == null || toSkip.containsKey(optionValue) && ((List)toSkip.get(optionValue)).contains(scalar)) continue;
            String notUniqueValue = String.valueOf(scalar.getValue());
            String uniqueValue = String.valueOf(ExpressionFunctions.getUniqueInt64Internal());
            List<ScalarConfig> childrenWithSameValue = ChildProviderHelper.getScalarsWithUniqueGroupAndValue(settings, optionValue, notUniqueValue);
            toSkip.put(optionValue, childrenWithSameValue);
            for (ScalarConfig other : childrenWithSameValue) {
                other.setValue(uniqueValue);
            }
        }
    }

    public static List<ScalarConfig> getScalarsWithUniqueGroupAndValue(List<? extends IChild> settings, Object uniqueIdGroup, Object expectedValue) {
        return (List)settings.stream().filter(s -> s instanceof ScalarConfig).map(s -> (ScalarConfig)s).filter(s -> Objects.equals(s.getOptionValue("UNIQUE_ID_GROUP"), uniqueIdGroup) && Objects.equals(String.valueOf(expectedValue), String.valueOf(s.getValue()))).collect(CollectorsUtils.toList());
    }
}

