/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.resourcetables.model.config;

import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.common.utils.expression.Expression;
import com.nxp.swtools.common.utils.expression.IContext;
import com.nxp.swtools.common.utils.expression.IFunction;
import com.nxp.swtools.common.utils.expression.IValue;
import com.nxp.swtools.resourcetables.model.config.RegistersModelSingleton;
import com.nxp.swtools.resourcetables.model.data.Register;
import java.math.BigInteger;

public class RegisterConfig {
    private Register registerDefinition;

    public RegisterConfig(Register registerDefinition) {
        this.registerDefinition = registerDefinition;
    }

    public @Nullable String getPeripheral(IContext context) {
        Expression expr = this.registerDefinition.getPeripheralExpr();
        if (expr != null) {
            try {
                return expr.resolve(context).getString();
            }
            catch (Exception e) {
                throw new RegistersModelSingleton.RegisterNotFoundException(RegistersModelSingleton.RegisterNotFoundException.RegisterNotFoundType.PERIPHERAL, e);
            }
        }
        return this.registerDefinition.getPeripheral();
    }

    public String getName(IContext context) {
        Expression expr = this.registerDefinition.getNameExpr();
        if (expr != null) {
            try {
                return expr.resolve(context).getString();
            }
            catch (Exception e) {
                throw new RegistersModelSingleton.RegisterNotFoundException(RegistersModelSingleton.RegisterNotFoundException.RegisterNotFoundType.NAME, e);
            }
        }
        return this.registerDefinition.getName();
    }

    public String getBitfield(IContext context) {
        Expression expr = this.registerDefinition.getBitfieldExpr();
        if (expr != null) {
            try {
                return expr.resolve(context).getString();
            }
            catch (Exception e) {
                throw new RegistersModelSingleton.RegisterNotFoundException(RegistersModelSingleton.RegisterNotFoundException.RegisterNotFoundType.BITFIELD, e);
            }
        }
        return this.registerDefinition.getBitfield();
    }

    public @Nullable BigInteger getValue(IContext context) {
        Expression expr = this.registerDefinition.getValueExpr();
        if (expr != null) {
            try {
                return expr.resolve(context).getBigInteger();
            }
            catch (Exception e) {
                throw new RegistersModelSingleton.RegisterNotFoundException(RegistersModelSingleton.RegisterNotFoundException.RegisterNotFoundType.VALUE, e);
            }
        }
        return null;
    }

    public BigInteger getUnknownBitsMask(IContext context) {
        Expression expr = this.registerDefinition.getUknownBitsMaskExpr();
        if (expr != null) {
            try {
                return expr.resolve(context).getBigInteger();
            }
            catch (Exception e) {
                throw new RegistersModelSingleton.RegisterNotFoundException(RegistersModelSingleton.RegisterNotFoundException.RegisterNotFoundType.UNKNOWN_BITS, e);
            }
        }
        return BigInteger.ZERO;
    }

    public @Nullable String getReverseValue(IContext context, BigInteger bitfieldValue) {
        Expression expr = this.registerDefinition.getReverseValueExpr();
        if (this.isReverseValueEnabled(context) && expr != null) {
            try {
                IFunction functionReference = expr.resolve(context).getFunctionReference();
                IValue reverseValue = functionReference.invokeOn(context, new Object[]{bitfieldValue});
                return reverseValue.getString();
            }
            catch (Exception e) {
                throw new RegistersModelSingleton.RegisterNotFoundException(RegistersModelSingleton.RegisterNotFoundException.RegisterNotFoundType.REVERSE_VALUE, e);
            }
        }
        return null;
    }

    public boolean isReverseValueEnabled(IContext context) {
        Expression enableExpr = this.registerDefinition.getReverseValueEnableExpr();
        if (enableExpr != null) {
            return enableExpr.resolve(context).getBoolean();
        }
        return true;
    }

    public @Nullable BigInteger getMask(IContext context) {
        Expression maskExpr = this.registerDefinition.getMaskExpr();
        if (maskExpr != null) {
            return maskExpr.resolve(context).getBigInteger();
        }
        return null;
    }

    public String toString() {
        return String.valueOf(this.getClass().getSimpleName()) + "[" + this.registerDefinition.toString() + "]";
    }
}

