/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.resourcetables.model.data;

import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.common.utils.lang.CollectionsUtils;
import com.nxp.swtools.common.utils.logging.LogManager;
import com.nxp.swtools.common.utils.stream.CollectorsUtils;
import com.nxp.swtools.configuration.properties.SWToolsProperties;
import com.nxp.swtools.kex.selector.IMcuIdentification;
import com.nxp.swtools.provider.configuration.storage.periphs.AStoragePeriphsSetting;
import com.nxp.swtools.provider.features.McuDataId;
import com.nxp.swtools.resourcetables.model.config.ChildContext;
import com.nxp.swtools.resourcetables.model.config.IRoot;
import com.nxp.swtools.resourcetables.model.config.ISettingConfig;
import com.nxp.swtools.resourcetables.model.data.AvailableResourceTablesRefResolver;
import com.nxp.swtools.resourcetables.model.data.IActiveContextRefContainer;
import com.nxp.swtools.resourcetables.model.data.ResourceTable;
import com.nxp.swtools.resourcetables.model.data.ResourceTableInfo;
import com.nxp.swtools.resourcetables.model.data.ResourceTablesProvider;
import com.nxp.swtools.resourcetables.model.data.setting.ISetting;
import com.nxp.swtools.resourcetables.model.mcu.ICommonMcu;
import com.nxp.swtools.resourcetables.model.resources.AProcessorFilterForResourceTable;
import java.lang.ref.SoftReference;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;

public class McuResourceTables
implements IActiveContextRefContainer {
    public static final String RTID_DMA = "dma";
    public static final String RTID_INTERRUPTS = "interrupts";
    private static final Logger LOGGER = LogManager.getLogger(McuResourceTables.class);
    private Collection<ResourceTableInfo> resourceTableInfos;
    private static final Map<// Could not load outer class - annotation placement on inner may be incorrect
    CollectionsUtils.Pair<McuDataId, AProcessorFilterForResourceTable>, SoftReference<@Nullable McuResourceTables>> INSTANCES = new HashMap<CollectionsUtils.Pair<McuDataId, AProcessorFilterForResourceTable>, SoftReference<McuResourceTables>>();

    protected McuResourceTables(Collection<ResourceTableInfo> resourceTableInfos) {
        this.resourceTableInfos = resourceTableInfos;
        new AvailableResourceTablesRefResolver(this).resolve();
    }

    public static synchronized McuResourceTables getInstance(IMcuIdentification mcu, AProcessorFilterForResourceTable toolsFilter) {
        McuResourceTables mcuResourceTables;
        McuDataId mcuId = new McuDataId(mcu.getPackage(), null, mcu.getSdkVersion());
        CollectionsUtils.Pair keyPar = new CollectionsUtils.Pair((Object)mcuId, (Object)toolsFilter);
        SoftReference<@Nullable McuResourceTables> softReference = INSTANCES.get(keyPar);
        if (softReference != null && (mcuResourceTables = softReference.get()) != null) {
            return mcuResourceTables;
        }
        McuResourceTables result = new McuResourceTables(McuResourceTables.loadResourceTables(mcu, toolsFilter));
        INSTANCES.put((CollectionsUtils.Pair<McuDataId, AProcessorFilterForResourceTable>)keyPar, new SoftReference<McuResourceTables>(result));
        return result;
    }

    public static Map<String, Collection<ISettingConfig>> associateResources(ICommonMcu mcu, IRoot root, Collection<ResourceTableInfo> resourceTableInfos) {
        HashMap<String, Collection<ISettingConfig>> configs = new HashMap<String, Collection<ISettingConfig>>();
        for (ResourceTableInfo info : resourceTableInfos) {
            ArrayList<ISettingConfig> resources = new ArrayList<ISettingConfig>();
            McuResourceTables.associateResources(mcu, root, info, resources);
            configs.put(info.getResourceTable().getId(), resources);
        }
        return configs;
    }

    private static void associateResources(ICommonMcu mcu, IRoot root, ResourceTableInfo info, Collection<ISettingConfig> resources) {
        ChildContext emptyContext = new ChildContext(root);
        ResourceTable table = info.getResourceTable();
        for (ISetting setting : table.getDefinition().values()) {
            AStoragePeriphsSetting data = table.getData().find(setting.getId());
            if (data == null) {
                LOGGER.severe(String.format("[DATA] Missing resource setting data for ID '%1s' in %2s", setting.getId(), info.getFileName()));
                continue;
            }
            ISettingConfig config = root.getConfigFactory().createSettingConfig(setting.getId(), setting, emptyContext, data, mcu);
            resources.add(config);
        }
    }

    public @Nullable ResourceTable findResourceTable(String id) {
        for (ResourceTableInfo info : this.resourceTableInfos) {
            ResourceTable table = info.getResourceTable();
            if (!table.getId().equals(id)) continue;
            return table;
        }
        return null;
    }

    @Override
    public Collection<ResourceTableInfo> getResourceTableInfos() {
        return CollectionsUtils.unmodifiableCollection(this.resourceTableInfos);
    }

    @Override
    public Collection<ResourceTable> getResourceTables() {
        return CollectionsUtils.unmodifiableCollection((Collection)((Collection)this.resourceTableInfos.stream().map(ResourceTableInfo::getResourceTable).collect(CollectorsUtils.toList())));
    }

    protected static Collection<ResourceTableInfo> loadResourceTables(IMcuIdentification mcuIdent, AProcessorFilterForResourceTable toolsFilter) {
        ArrayList<ResourceTableInfo> result = new ArrayList<ResourceTableInfo>();
        if (!toolsFilter.isPeripheralsResourceTablesDirDefined(mcuIdent)) {
            if (SWToolsProperties.isVerificationOn()) {
                LOGGER.severe(() -> MessageFormat.format("[DATA] resource_tables not specified for selected part {0} and SDK {1}", mcuIdent.getPackage(), mcuIdent.getSdkVersion()));
            }
            return result;
        }
        return ResourceTablesProvider.getResourceTables(toolsFilter.getPeripheralsResourceTablesDir(mcuIdent));
    }
}

