/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.resourcetables.model.data.setting;

import com.nxp.swtools.common.utils.NonNull;
import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.common.utils.expression.Expression;
import com.nxp.swtools.common.utils.expression.FormatOptions;
import com.nxp.swtools.common.utils.lang.CollectionsUtils;
import com.nxp.swtools.common.utils.logging.LogManager;
import com.nxp.swtools.resourcetables.model.data.Description;
import com.nxp.swtools.resourcetables.model.data.IActiveContextRefResolver;
import com.nxp.swtools.resourcetables.model.data.IConfigurationComponent;
import com.nxp.swtools.resourcetables.model.data.IReferenceSettingResolver;
import com.nxp.swtools.resourcetables.model.data.OptionsExpr;
import com.nxp.swtools.resourcetables.model.data.setting.AMinMaxSetting;
import com.nxp.swtools.resourcetables.model.data.setting.ASetting;
import com.nxp.swtools.resourcetables.model.data.setting.ISetting;
import com.nxp.swtools.resourcetables.model.data.setting.IUIName;
import com.nxp.swtools.resourcetables.model.data.setting.ItemDefaults;
import com.nxp.swtools.resourcetables.model.data.setting.ReferenceSetting;
import java.text.MessageFormat;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.logging.Logger;
import org.simpleframework.xml.Attribute;
import org.simpleframework.xml.Element;
import org.simpleframework.xml.Order;
import org.simpleframework.xml.Root;
import org.simpleframework.xml.core.Commit;

@Root(name="array", strict=false)
@Order(attributes={"id", "label", "label_expr", "available", "public", "enable", "options", "type", "size", "key_selector_expr"})
public class ArraySetting
extends AMinMaxSetting
implements IReferenceSettingResolver {
    private static final Logger LOGGER = LogManager.getLogger(ArraySetting.class);
    @Attribute(name="type")
    private String referenceTypeID;
    @Attribute(name="base_type", required=false)
    @Nullable
    private @Attribute(name="base_type", required=false) @Nullable String baseTypeId;
    @Element(name="item_defaults", required=false)
    @Nullable
    private @Element(name="item_defaults", required=false) @Nullable ItemDefaults itemDefaults;
    @Nullable
    private Expression sizeExpression;
    @Nullable
    private Expression addOnIndexExpression;
    @Nullable
    private Expression removeFromIndexExpression;
    private ISetting referenceType;
    @Nullable
    private Expression keySelector;

    @Attribute(name="key_selector_expr", required=false)
    private @Attribute(name="key_selector_expr", required=false) @Nullable String getKeySelectorString() {
        return this.keySelector != null ? this.keySelector.formatOutput(FormatOptions.DEFAULT) : null;
    }

    @Attribute(name="key_selector_expr", required=false)
    private void setKeySelectorString(@Nullable String newExpr) {
        try {
            this.keySelector = newExpr != null && !newExpr.isEmpty() ? Expression.create((String)newExpr) : null;
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Key selector of array \"" + this.getId() + "\" caused exception: " + e.getLocalizedMessage());
        }
    }

    @Attribute(name="size", required=false)
    public void setSizeExpressionString(@Nullable String exprString) {
        if (exprString != null) {
            try {
                this.sizeExpression = Expression.create((String)exprString);
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Size expression of array \"" + this.getId() + "\" caused exception: " + e.getLocalizedMessage());
            }
        }
    }

    @Attribute(name="size", required=false)
    public @Attribute(name="size", required=false) @Nullable String getSizeExpressionString() {
        return this.sizeExpression != null ? this.sizeExpression.formatOutput(FormatOptions.DEFAULT) : null;
    }

    @Attribute(name="add_on_index", required=false)
    public void setAddOnIndexExpressionString(@Nullable String exprString) {
        if (exprString != null) {
            this.addOnIndexExpression = Expression.tryCreate((String)exprString);
        }
    }

    @Attribute(name="add_on_index", required=false)
    public @Attribute(name="add_on_index", required=false) @Nullable String getAddOnIndexExpressionString() {
        return this.addOnIndexExpression != null ? this.addOnIndexExpression.formatOutput(FormatOptions.DEFAULT) : null;
    }

    @Attribute(name="remove_from_index", required=false)
    public void setRemoveFromIndexExpressionString(@Nullable String exprString) {
        if (exprString != null) {
            this.removeFromIndexExpression = Expression.tryCreate((String)exprString);
        }
    }

    @Attribute(name="remove_from_index", required=false)
    public @Attribute(name="remove_from_index", required=false) @Nullable String getRemoveFromIndexExpressionString() {
        return this.removeFromIndexExpression != null ? this.removeFromIndexExpression.formatOutput(FormatOptions.DEFAULT) : null;
    }

    public @Nullable Expression getSizeExpr() {
        return this.sizeExpression;
    }

    public @Nullable Expression getAddOnIndexExpr() {
        return this.addOnIndexExpression;
    }

    public @Nullable Expression getRemoveFromIndexExpr() {
        return this.removeFromIndexExpression;
    }

    public ArraySetting(String id, @Nullable String uiName, @Nullable String uiNameExpr, @Nullable Description description, String refTypeID, @Nullable String availableCond, @Nullable String enableCond, @Nullable String publicCond, @Nullable String options, @Nullable OptionsExpr optionsExpression, @Nullable ItemDefaults itemDefaults, @Nullable Expression keySelector, @Nullable String minValue, @Nullable String maxValue, @Nullable String sizeExpression) {
        super(id, uiName, uiNameExpr, description, availableCond, enableCond, publicCond, options, optionsExpression, minValue, maxValue);
        this.referenceTypeID = refTypeID;
        this.referenceType = new ReferenceSetting(id, null, null, null, refTypeID, null, null, null, null, null, null, null);
        this.itemDefaults = itemDefaults;
        this.keySelector = keySelector;
        this.setSizeExpressionString(sizeExpression);
    }

    @Deprecated
    protected ArraySetting() {
        this("", null, null, null, "", null, null, null, null, null, null, null, null, null, null);
    }

    @Override
    @Commit
    public void commit() {
        this.referenceType = new ReferenceSetting(this.getId(), null, null, null, this.referenceTypeID, null, null, null, null, null, null, null);
        super.commit();
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + this.referenceTypeID.hashCode();
        result = 31 * result + Objects.hashCode(this.itemDefaults);
        result = 31 * result + Objects.hashCode(this.keySelector);
        result = 31 * result + Objects.hashCode(this.sizeExpression);
        result = 31 * result + Objects.hashCode(this.addOnIndexExpression);
        result = 31 * result + Objects.hashCode(this.removeFromIndexExpression);
        result = 31 * result + Objects.hashCode(this.baseTypeId);
        return result;
    }

    @Override
    public boolean equals(@Nullable Object obj) {
        if (!super.equals(obj)) {
            return false;
        }
        assert (obj != null);
        ArraySetting other = (ArraySetting)obj;
        if (!this.referenceTypeID.equals(other.referenceTypeID)) {
            return false;
        }
        if (!Objects.equals(this.itemDefaults, other.itemDefaults)) {
            return false;
        }
        if (!Objects.equals(this.keySelector, other.keySelector)) {
            return false;
        }
        if (!Objects.equals(this.sizeExpression, other.sizeExpression)) {
            return false;
        }
        if (!Objects.equals(this.addOnIndexExpression, other.addOnIndexExpression)) {
            return false;
        }
        if (!Objects.equals(this.removeFromIndexExpression, other.removeFromIndexExpression)) {
            return false;
        }
        return Objects.equals(this.baseTypeId, other.baseTypeId);
    }

    public String getReferenceID() {
        return this.referenceTypeID;
    }

    public ISetting getReferenceType() {
        return this.referenceType;
    }

    public @Nullable ItemDefaults getItemDefaults() {
        return this.itemDefaults;
    }

    public @Nullable Expression getKeySelector() {
        return this.keySelector;
    }

    @Override
    public String toString() {
        return String.valueOf(this.getClass().getSimpleName()) + " [" + super.toString() + ", " + "type" + "=" + this.getReferenceID() + ", " + "item_defaults" + "=" + Objects.toString(this.itemDefaults) + ", " + "key_selector_expr" + "=" + Objects.toString(this.keySelector) + "]";
    }

    @Override
    public ArraySetting fromReference(ReferenceSetting ref) {
        ArraySetting arraySetting = new ArraySetting(ref.getId(), (String)IUIName.getUiNames(ref, this).getFirst(), (String)IUIName.getUiNames(ref, this).getSecond(), this.getDescription(ref.getDescription()), this.referenceTypeID, ArraySetting.andConditions(ref.getAvailableExprString(), this.getAvailableExprString()), ArraySetting.andConditions(ref.getEnableExprString(), this.getEnableExprString()), ArraySetting.andConditions(ref.getPublicCondition(), this.getPublicCondition()), null, null, this.getItemDefaults(), this.getKeySelector(), this.getMinValueString(), this.getMaxValueString(), this.getSizeExpressionString());
        arraySetting.setOptionsMap(this.createOptionsMap(this.getOptionsMap(), ref.getOptionsMap()));
        arraySetting.referenceType = this.referenceType;
        arraySetting.setValidation(this.mergeValidations(ref.getValidation(), this.getValidation()));
        arraySetting.setMigrations(ref.getMigrations());
        arraySetting.setAddOnIndexExpressionString(this.getAddOnIndexExpressionString());
        arraySetting.setRemoveFromIndexExpressionString(this.getRemoveFromIndexExpressionString());
        arraySetting.relatedSettings = this.relatedSettings;
        arraySetting.setBaseTypeId(this.getBaseTypeId());
        arraySetting.verify();
        return arraySetting;
    }

    @Override
    public void resolve(IActiveContextRefResolver sdkRefResolver, @Nullable IConfigurationComponent comp, String setID) {
        ASetting baseTypeSetting;
        LinkedHashMap<String, ISetting> settings = new LinkedHashMap<String, ISetting>();
        settings.put(this.referenceType.getId(), this.referenceType);
        sdkRefResolver.resolve(this, settings, comp, setID);
        ISetting iSetting = (ISetting)settings.get(this.referenceType.getId());
        if (iSetting != null) {
            this.referenceType = iSetting;
        } else {
            LOGGER.severe(MessageFormat.format("[DATA] An array setting with ID \"{0}\" contains an unresolvable reference with ID \"{1}\" to a setting in component with ID \"{2}\" and config-set with ID \"{3}\"", this.getId(), this.referenceType.getId(), comp != null ? comp.getId() : null, setID));
        }
        if (this.baseTypeId != null && (baseTypeSetting = this.resolveBaseType(sdkRefResolver, comp, setID, this.baseTypeId)) instanceof ArraySetting) {
            ArraySetting arrayBaseType = (ArraySetting)baseTypeSetting;
            this.itemDefaults = this.mergeItemDefaults(this.getItemDefaults(), arrayBaseType.getItemDefaults());
        }
    }

    @Override
    public @NonNull String getTypeName() {
        return "array";
    }

    @Override
    public void resolveRelatedSettings(IActiveContextRefResolver sdkRefResolver, @Nullable IConfigurationComponent comp, String configSetID, Map<String, ISetting> allRelSettings) {
        super.resolveRelatedSettings(sdkRefResolver, comp, configSetID, allRelSettings);
        this.referenceType.resolveRelatedSettings(sdkRefResolver, comp, configSetID, allRelSettings);
    }

    public void setBaseTypeId(@Nullable String baseTypeId) {
        this.baseTypeId = baseTypeId;
    }

    public @Nullable String getBaseTypeId() {
        return this.baseTypeId;
    }

    protected @Nullable ItemDefaults mergeItemDefaults(@Nullable ItemDefaults itemDefaultsPrototype, @Nullable ItemDefaults itemDefaultsReference) {
        if (itemDefaultsPrototype != null && itemDefaultsReference != null) {
            LinkedHashMap<String, ItemDefaults.SetDefault> newDefaults = new LinkedHashMap<String, ItemDefaults.SetDefault>(itemDefaultsReference.getDefaults());
            newDefaults.putAll(itemDefaultsPrototype.getDefaults());
            ItemDefaults newItemDefaults = new ItemDefaults();
            newItemDefaults.setDefaultsList(CollectionsUtils.listFromMapValues(newDefaults));
            return newItemDefaults;
        }
        return itemDefaultsPrototype != null ? itemDefaultsPrototype : itemDefaultsReference;
    }
}

