/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.resourcetables.model.data.setting;

import com.nxp.swtools.common.utils.NonNull;
import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.common.utils.lang.CollectionsUtils;
import com.nxp.swtools.resourcetables.model.data.Description;
import com.nxp.swtools.resourcetables.model.data.OptionsExpr;
import com.nxp.swtools.resourcetables.model.data.setting.ASetting;
import com.nxp.swtools.resourcetables.model.data.setting.IUIName;
import com.nxp.swtools.resourcetables.model.data.setting.ReferenceSetting;
import java.util.Collection;
import org.simpleframework.xml.Attribute;
import org.simpleframework.xml.Order;
import org.simpleframework.xml.Root;

@Root(name="file", strict=false)
@Order(attributes={"id", "label", "label_expr", "available", "public", "enable", "options", "type"})
public class FileSetting
extends ASetting {
    public static final String SEPARATOR = "=";
    public static final String LINK = "LINK";
    public static final String CONTENT = "CONTENT";
    @Attribute(name="type")
    private FileType fileType;

    public FileSetting(String id, @Nullable String uiName, @Nullable String uiNameExpr, @Nullable Description description, FileType fileType, @Nullable String availableCond, @Nullable String enableCond, @Nullable String publicCond, @Nullable String options, @Nullable OptionsExpr optionsExpr) {
        super(id, uiName, uiNameExpr, description, availableCond, enableCond, publicCond, options, optionsExpr);
        this.fileType = fileType;
    }

    @Deprecated
    protected FileSetting() {
        this("", null, null, null, FileType.text, null, null, null, null, null);
    }

    public FileType getType() {
        return this.fileType;
    }

    @Override
    public String toString() {
        return String.valueOf(this.getClass().getSimpleName()) + " [" + super.toString() + "," + " " + "type" + SEPARATOR + (Object)((Object)this.getType()) + "]";
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + this.fileType.hashCode();
        return result;
    }

    @Override
    public boolean equals(@Nullable Object obj) {
        if (obj == null) {
            return false;
        }
        if (!super.equals(obj) || this.getClass() != obj.getClass()) {
            return false;
        }
        FileSetting other = (FileSetting)obj;
        return this.fileType == other.fileType;
    }

    @Override
    public FileSetting fromReference(ReferenceSetting ref) {
        FileSetting setting = new FileSetting(ref.getId(), (String)IUIName.getUiNames(ref, this).getFirst(), (String)IUIName.getUiNames(ref, this).getSecond(), this.getDescription(ref.getDescription()), this.fileType, FileSetting.andConditions(ref.getAvailableExprString(), this.getAvailableExprString()), FileSetting.andConditions(ref.getEnableExprString(), this.getEnableExprString()), FileSetting.andConditions(ref.getPublicCondition(), this.getPublicCondition()), null, null);
        setting.setOptionsMap(this.createOptionsMap(this.getOptionsMap(), ref.getOptionsMap()));
        setting.setValidation(this.mergeValidations(ref.getValidation(), this.getValidation()));
        setting.setMigrations(ref.getMigrations());
        setting.setAssigns(CollectionsUtils.mergeToList((Collection[])new Collection[]{ref.getAssigns(), this.getAssigns()}));
        setting.verify();
        return setting;
    }

    public static final String getContentPart(String string) {
        int separatorPosition = string.indexOf(SEPARATOR);
        if (separatorPosition == -1) {
            return "";
        }
        return string.substring(separatorPosition + 1);
    }

    public static final String getTypePart(String string) {
        int separatorPosition = string.indexOf(SEPARATOR);
        if (separatorPosition == -1) {
            return "";
        }
        return string.substring(0, separatorPosition);
    }

    @Override
    public @NonNull String getTypeName() {
        return "file";
    }

    public static enum FileType {
        binary,
        text,
        image,
        directory;

    }
}

