/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.debug.ide.s32debugger.validation;

import com.nxp.s32ds.debug.ide.core.AttributeReadingUtils;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.variables.VariablesPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;

public class S32DSMultipleElfParams {
    public static final String LOAD_MULTIPLE_ELF_ATTR = "com.nxp.s32ds.debug.ide.s32debugger.core.multiple.elf";
    public static final String MULTIPLE_OBJECTS_SEPARATOR = ";";
    public static final String MULTIPLE_OBJECTS_OFFSET_SEPARATOR = "#";
    public static final String[] MULTIPLE_OBJECTS_ELF_FORMAT_TYPES = new String[]{".elf", ".eld", ".out"};
    public static final String[] MULTIPLE_OBJECTS_BIN_FORMAT_TYPES = new String[]{".bin"};
    private static final String LOAD_ELF_COMMAND = "load \"%s\"";
    private static final String ADD_SYMBOLS_ELF_COMMAND = "add-symbol-file \"%s\"";
    private static final String LOAD_BIN_COMMAND = "restore %s binary 0x%s";
    private static final String EMPTY_STRING = "";
    private static final String FILE_ERROR = "File %s cannot be found";
    private ArrayList<String> multipleElfLoadCommands = new ArrayList();
    private ArrayList<String> multipleElfAddSymbolsCommands = new ArrayList();
    private ArrayList<IStatus> errors = new ArrayList();

    private S32DSMultipleElfParams() {
    }

    public List<String> getMultipleElfLoadCommands() {
        return this.multipleElfLoadCommands;
    }

    public List<String> getmultipleElfAddSymbolsCommands() {
        return this.multipleElfAddSymbolsCommands;
    }

    public List<IStatus> getErrors() {
        return this.errors;
    }

    public static S32DSMultipleElfParams getParams(ILaunchConfiguration lc) {
        S32DSMultipleElfParams params = new S32DSMultipleElfParams();
        params.parseMultipleElfFromLaunchConfig(lc);
        return params;
    }

    public MultipleELFOrderType getOrderType() {
        return MultipleELFOrderType.LOAD_BEFORE_DEBUG;
    }

    private void parseMultipleElfFromLaunchConfig(ILaunchConfiguration lc) {
        String[] split;
        String attribute = (String)AttributeReadingUtils.readAttribute(this.errors, (String)LOAD_MULTIPLE_ELF_ATTR, (Object)EMPTY_STRING, (ILaunchConfiguration)lc);
        String[] stringArray = split = attribute.split(MULTIPLE_OBJECTS_SEPARATOR);
        int n = split.length;
        int n2 = 0;
        while (n2 < n) {
            String[] argSplit;
            String path;
            String arg = stringArray[n2];
            if (!arg.isEmpty() && !(path = this.getPathFromString((argSplit = arg.split(MULTIPLE_OBJECTS_OFFSET_SEPARATOR))[0])).isEmpty()) {
                if (Arrays.stream(MULTIPLE_OBJECTS_ELF_FORMAT_TYPES).anyMatch(path::endsWith)) {
                    boolean loadSymbol = argSplit.length > 1 ? Boolean.parseBoolean(argSplit[1]) : false;
                    this.multipleElfLoadCommands.add(String.format(LOAD_ELF_COMMAND, path));
                    if (loadSymbol) {
                        this.multipleElfAddSymbolsCommands.add(String.format(ADD_SYMBOLS_ELF_COMMAND, path));
                    }
                } else if (Arrays.stream(MULTIPLE_OBJECTS_BIN_FORMAT_TYPES).anyMatch(path::endsWith)) {
                    String offset = argSplit[1];
                    Boolean loadSymbols = Boolean.parseBoolean(argSplit[2]);
                    offset = offset.replaceFirst("0x", EMPTY_STRING);
                    this.multipleElfLoadCommands.add(String.format(LOAD_BIN_COMMAND, path, offset));
                    if (Boolean.TRUE.equals(loadSymbols)) {
                        String loadSymbolsPath = this.getPathFromString(argSplit[3]);
                        this.multipleElfAddSymbolsCommands.add(String.format(ADD_SYMBOLS_ELF_COMMAND, loadSymbolsPath));
                    }
                }
            }
            ++n2;
        }
    }

    private String getPathFromString(String strPath) {
        try {
            strPath = VariablesPlugin.getDefault().getStringVariableManager().performStringSubstitution(strPath);
        }
        catch (CoreException err) {
            this.errors.add((IStatus)new Status(4, this.getClass(), err.getMessage()));
            return EMPTY_STRING;
        }
        File file = new File(strPath);
        if (!file.exists()) {
            this.errors.add((IStatus)new Status(4, this.getClass(), String.format(FILE_ERROR, strPath)));
            return EMPTY_STRING;
        }
        try {
            strPath = String.format("%s", file.getCanonicalPath().replace("\\", "\\\\"));
        }
        catch (IOException e) {
            this.errors.add((IStatus)new Status(4, this.getClass(), e.getMessage()));
            return EMPTY_STRING;
        }
        return strPath;
    }

    public static enum MultipleELFOrderType {
        LOAD_BEFORE_DEBUG;

    }
}

