/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.cle.ide.migration.internal.ui.wizard;

import com.nxp.s32ds.cle.ide.migration.internal.ui.Messages;
import com.nxp.s32ds.cle.ide.migration.internal.ui.MigrationUiActivator;
import com.nxp.s32ds.cle.ide.migration.internal.ui.wizard.Fonts;
import com.nxp.s32ds.cle.ide.migration.internal.ui.wizard.MigrationDescriptorsUtil;
import com.nxp.s32ds.cle.ide.migration.internal.ui.wizard.MigrationListComposite;
import com.nxp.s32ds.cle.ide.migration.internal.ui.wizard.MigrationWizardPageBase;
import com.nxp.s32ds.cle.ide.migration.internal.ui.wizard.ProjectListComposite;
import com.nxp.s32ds.cle.runtime.migration.sequence.MigrationSequenceDescriptor;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Text;

public class MigrateProjectComposite
extends Composite {
    private MigrationWizardPageBase page;
    private MigrationListComposite migrationListComposite;
    private ProjectListComposite projectListComposite;
    private Text migrationDescription;

    public MigrateProjectComposite(Composite parent, IStructuredSelection selection) {
        super(parent, 0);
        GridLayoutFactory.swtDefaults().numColumns(1).margins(0, 0).applyTo((Composite)this);
        GridDataFactory.swtDefaults().grab(true, true).align(4, 4).applyTo((Control)this);
        this.doCreateSelectors(this);
        this.doCreateMigrationDescription(this);
        this.projectListComposite.setSelection(selection);
    }

    public void setPage(MigrationWizardPageBase page) {
        this.page = page;
    }

    public List<IProject> getSelectedProjects() {
        return this.projectListComposite.getSelectedProjects();
    }

    public MigrationSequenceDescriptor getMigration() {
        return this.migrationListComposite.getMigration();
    }

    public IRunnableWithProgress getMigrationOperation() {
        return MigrationDescriptorsUtil.getMigrationOperation(this.getSelectedProjects(), this.migrationListComposite.getMigration());
    }

    public IStatus validate() {
        IStatus status = this.projectListComposite.validate();
        if (!status.isOK()) {
            return status;
        }
        if (this.migrationListComposite.isListEmpty()) {
            return MigrationUiActivator.getInstance().createStatus(4, Messages.MigrationComposite_there_are_no_suitable_migrations_for_this_project_s);
        }
        status = this.migrationListComposite.validate();
        if (!status.isOK()) {
            return status;
        }
        return Status.OK_STATUS;
    }

    private void doCreateSelectors(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayoutFactory.swtDefaults().numColumns(2).equalWidth(false).margins(0, 0).applyTo(composite);
        GridDataFactory.swtDefaults().grab(true, true).align(4, 4).applyTo((Control)composite);
        this.projectListComposite = new ProjectListComposite(composite, Messages.MigrationComposite_projects, true, projects -> this.updateMigrationsList((List<IProject>)projects));
        this.migrationListComposite = new MigrationListComposite(composite, Messages.MigrationComposite_available_migrations, migration -> this.updateMigrationDescription((MigrationSequenceDescriptor)migration));
    }

    private void updateMigrationsList(List<IProject> projects) {
        this.migrationListComposite.setProjects(projects);
        this.updatePageComplete();
    }

    private void doCreateMigrationDescription(Composite parent) {
        Group group = new Group(parent, 0);
        GridLayoutFactory.swtDefaults().numColumns(1).applyTo((Composite)group);
        GridDataFactory.swtDefaults().grab(true, false).span(2, 1).align(4, 4).applyTo((Control)group);
        group.setText(Messages.MigrationComposite_details);
        this.migrationDescription = new Text((Composite)group, 586);
        int fontHeight = Fonts.getFontMetrics((Drawable)this.migrationDescription).getHeight();
        GridDataFactory.swtDefaults().grab(true, false).align(4, 4).hint(-1, fontHeight * 2).applyTo((Control)this.migrationDescription);
    }

    private void updateMigrationDescription(MigrationSequenceDescriptor migration) {
        if (this.migrationDescription == null) {
            return;
        }
        if (migration == null) {
            this.migrationDescription.setText("");
        } else {
            this.migrationDescription.setText(migration.getDescription());
        }
        this.updatePageComplete();
    }

    private void updatePageComplete() {
        if (this.page != null) {
            this.page.updatePageComplete();
        }
    }
}

