/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.cle.ide.migration.internal.ui.wizard;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;

public abstract class MigrationWizardPageBase
extends WizardPage {
    private String defaultMessage = "";

    public MigrationWizardPageBase(String pageName, String title) {
        super(pageName, title, null);
    }

    public MigrationWizardPageBase(String pageName) {
        super(pageName);
    }

    public void setDefaultMessage(String defaultMessage) {
        this.defaultMessage = defaultMessage;
    }

    public String getDefaultMessage() {
        return this.defaultMessage;
    }

    public void saveWidgetState() {
        IDialogSettings settings = this.getDialogSettings();
        if (settings != null) {
            this.saveWidgetState(settings);
        }
    }

    public final void createControl(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout(1, false));
        composite.setLayoutData((Object)new GridData(4, 4, true, true));
        this.doCreateControl(composite);
        this.setControl((Control)composite);
        this.setPageComplete(false);
        this.setMessage(this.getDefaultMessage());
        IDialogSettings settings = this.getDialogSettings();
        if (settings != null) {
            this.restoreWidgetState(settings);
        }
        this.updatePageComplete();
        if (this.getErrorMessage() != null) {
            this.setMessage(this.getErrorMessage());
            this.setErrorMessage(null);
        }
        Dialog.applyDialogFont((Control)parent);
    }

    protected abstract void doCreateControl(Composite var1);

    protected void restoreWidgetState(IDialogSettings settings) {
    }

    protected void saveWidgetState(IDialogSettings settings) {
    }

    public void updatePageComplete() {
        this.setPageComplete(this.detectPageComplete());
    }

    private boolean detectPageComplete() {
        IStatus status = this.validate();
        switch (status.getSeverity()) {
            case 1: 
            case 2: {
                this.setErrorMessage(null);
                this.setMessage(status.getMessage());
                return false;
            }
            case 0: {
                this.setErrorMessage(null);
                this.setMessage(this.getDefaultMessage());
                return true;
            }
        }
        this.setErrorMessage(status.getMessage());
        return false;
    }

    protected abstract IStatus validate();
}

