/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.cle.ide.migration.internal.ui.wizard;

import com.nxp.s32ds.cle.ide.migration.internal.ui.Messages;
import com.nxp.s32ds.cle.ide.migration.internal.ui.MigrationUiActivator;
import com.nxp.s32ds.cle.ide.migration.internal.ui.wizard.ArrayTreeContentProvider;
import com.nxp.s32ds.cle.ide.migration.internal.ui.wizard.Fonts;
import com.nxp.s32ds.ext.rcp.jface.viewers.IgnoreCaseSubstringViewerFilter;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.viewers.ContentViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.ui.model.WorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;

public class ProjectListComposite
extends Composite {
    private static final int WIDTH_HINT = 50;
    private final String listLabel;
    private final boolean isMulty;
    private final Consumer<List<IProject>> projectsListChangedConsumer;
    private final ViewerFilter defaultProjectFilter;
    private Text projectsFilterText;
    private TreeViewer projectsTreeViewer;
    private List<IProject> currentProjectsSelection = Collections.emptyList();

    public ProjectListComposite(Composite parent, String listLabel, boolean isMulty, Consumer<List<IProject>> projectsListChangedConsumer) {
        super(parent, 0);
        this.listLabel = listLabel;
        this.isMulty = isMulty;
        this.projectsListChangedConsumer = projectsListChangedConsumer;
        this.defaultProjectFilter = new DefaultProjectFilter();
        GridLayoutFactory.swtDefaults().numColumns(1).margins(0, 0).applyTo((Composite)this);
        GridDataFactory.swtDefaults().grab(true, true).align(4, 4).applyTo((Control)this);
        this.doCreateProjectsSelector(this);
        this.updateFilter();
    }

    public void setSelection(IStructuredSelection selection) {
        if (selection != null && !selection.isEmpty()) {
            this.projectsTreeViewer.setSelection((ISelection)selection);
        } else {
            this.projectsListChangedConsumer.accept(this.currentProjectsSelection);
        }
    }

    public List<IProject> getSelectedProjects() {
        return Arrays.stream(((IStructuredSelection)this.projectsTreeViewer.getSelection()).toArray()).map(o -> (IProject)o).collect(Collectors.toList());
    }

    public IStatus validate() {
        if (this.getSelectedProjects().isEmpty()) {
            return MigrationUiActivator.getInstance().createStatus(1, this.isMulty ? Messages.MigrationProjectListComposite_select_one_or_more_projects : Messages.MigrationProjectListComposite_select_project);
        }
        return Status.OK_STATUS;
    }

    private void doCreateProjectsSelector(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayoutFactory.swtDefaults().margins(0, 0).equalWidth(false).applyTo(composite);
        GridDataFactory.swtDefaults().grab(true, true).align(4, 4).applyTo((Control)composite);
        Label label = new Label(composite, 0);
        GridDataFactory.swtDefaults().grab(true, false).align(1, 0x1000000).applyTo((Control)label);
        label.setText(this.listLabel);
        this.doCreateProjectsFilterText(composite);
        this.doCreateProjectsFilteredList(composite);
    }

    private void doCreateProjectsFilterText(Composite parent) {
        this.projectsFilterText = new Text(parent, 2048);
        GridDataFactory.swtDefaults().grab(true, false).align(4, 1).applyTo((Control)this.projectsFilterText);
        this.projectsFilterText.addListener(24, e -> this.updateFilter());
    }

    private void updateFilter() {
        this.projectsTreeViewer.setFilters(new ViewerFilter[]{this.defaultProjectFilter, new IgnoreCaseSubstringViewerFilter(this.projectsFilterText.getText())});
    }

    private void doCreateProjectsFilteredList(Composite parent) {
        this.projectsTreeViewer = new TreeViewer(parent, 0xB00 | (this.isMulty ? 2 : 0));
        this.projectsTreeViewer.setLabelProvider((IBaseLabelProvider)new WorkbenchLabelProvider());
        this.projectsTreeViewer.setContentProvider((IContentProvider)ArrayTreeContentProvider.INSTANCE);
        Object[] elements = new WorkbenchContentProvider().getElements((Object)ResourcesPlugin.getWorkspace().getRoot());
        this.projectsTreeViewer.setInput((Object)elements);
        Tree tree = this.projectsTreeViewer.getTree();
        int width = (int)Fonts.getFontMetrics((Drawable)tree).getAverageCharacterWidth();
        GridDataFactory.swtDefaults().grab(true, true).align(4, 4).hint(width * 50, tree.getItemHeight() * 10).applyTo((Control)tree);
        this.projectsTreeViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ProjectListComposite.this.updateProjectsList();
            }
        });
    }

    private void updateProjectsList() {
        List<IProject> selectedProjects = this.getSelectedProjects();
        if (selectedProjects.equals(this.currentProjectsSelection)) {
            return;
        }
        this.currentProjectsSelection = selectedProjects;
        this.projectsListChangedConsumer.accept(this.currentProjectsSelection);
    }

    private static class DefaultProjectFilter
    extends ViewerFilter {
        private DefaultProjectFilter() {
        }

        public boolean select(Viewer viewer, Object parentElement, Object element) {
            if (element instanceof IProject && !((IProject)element).isAccessible()) {
                return false;
            }
            String labelText = ((ILabelProvider)((ContentViewer)viewer).getLabelProvider()).getText(element);
            return !"remotesystemstempfiles".equalsIgnoreCase(labelText);
        }
    }
}

