/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.cle.cdt.sdk.internal.ui.action;

import com.nxp.s32ds.cle.cdt.sdk.action.SdkActionMessageType;
import com.nxp.s32ds.cle.cdt.sdk.internal.core.action.SdkActionMessage;
import com.nxp.s32ds.cle.cdt.sdk.internal.ui.Messages;
import com.nxp.s32ds.cle.cdt.sdk.internal.ui.SdkUiActivator;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class SdkMessageHandlerCallback {
    private SdkMessageHandlerCallback() {
    }

    public static IStatus showMessage(SdkActionMessage actionMessage) {
        String messageText;
        if (actionMessage != null && !(messageText = actionMessage.getText().trim()).isEmpty()) {
            SdkActionMessageType messageType = actionMessage.getType();
            switch (messageType) {
                case CONFIRM: {
                    return SdkMessageHandlerCallback.showConfirmMessage(messageText);
                }
                case ERROR: {
                    return SdkMessageHandlerCallback.showErrorMessage(messageText);
                }
                case INFO: {
                    return SdkMessageHandlerCallback.showInfoMessage(messageText);
                }
                case WARNING: {
                    return SdkMessageHandlerCallback.showWarningMessage(messageText);
                }
            }
            IStatus errorStatus = SdkUiActivator.getInstance().createError(NLS.bind((String)Messages.SdkMessageHandlerCallback_error_handle_message, (Object)messageType));
            SdkUiActivator.getInstance().log(errorStatus);
            return errorStatus;
        }
        return Status.OK_STATUS;
    }

    private static IStatus showConfirmMessage(String messageText) {
        boolean[] isConfirmed = new boolean[1];
        Display display = Display.getDefault();
        display.syncExec(() -> {
            boolean bl = MessageDialog.openConfirm((Shell)display.getActiveShell(), (String)Messages.SdkMessageHandlerCallback_message_confirm_title, (String)messageText);
        });
        return isConfirmed[0] ? Status.OK_STATUS : Status.CANCEL_STATUS;
    }

    private static IStatus showInfoMessage(String messageText) {
        Display display = Display.getDefault();
        display.syncExec(() -> MessageDialog.openInformation((Shell)display.getActiveShell(), (String)Messages.SdkMessageHandlerCallback_message_info_title, (String)messageText));
        return Status.OK_STATUS;
    }

    private static IStatus showWarningMessage(String messageText) {
        Display display = Display.getDefault();
        display.syncExec(() -> MessageDialog.openWarning((Shell)display.getActiveShell(), (String)Messages.SdkMessageHandlerCallback_message_warning_title, (String)messageText));
        return Status.OK_STATUS;
    }

    private static IStatus showErrorMessage(String messageText) {
        Display display = Display.getDefault();
        display.syncExec(() -> MessageDialog.openError((Shell)display.getActiveShell(), (String)Messages.SdkMessageHandlerCallback_message_error_title, (String)messageText));
        return Status.OK_STATUS;
    }
}

