/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.cle.cdt.sdk.internal.ui.attach;

import com.nxp.s32ds.cle.cdt.sdk.core.utils.SdkManagementUtils;
import com.nxp.s32ds.cle.cdt.sdk.internal.ui.Messages;
import com.nxp.s32ds.cle.cdt.sdk.internal.ui.SdkUiActivator;
import com.nxp.s32ds.cle.runtime.sdk.registry.SdkDescriptor;
import java.util.Arrays;
import java.util.Collection;
import java.util.Objects;
import org.eclipse.core.resources.IProject;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class DetachSdkActionsSelectionDialog
extends TitleAreaDialog {
    private static final String DEFAULT_BACKUP_FILE_EXTENSION = ".zip";
    private boolean isCreateProjectBackup;
    private String backupFilePath;
    private Composite backupFileComposite;
    private Collection<SdkDescriptor> sdksToDetach;
    private IProject project;

    public DetachSdkActionsSelectionDialog(Shell parentShell, Collection<SdkDescriptor> sdksToDetach, IProject project) {
        super(parentShell);
        this.project = Objects.requireNonNull(project);
        this.sdksToDetach = Objects.requireNonNull(sdksToDetach);
    }

    protected Control createDialogArea(Composite parent) {
        Composite content = (Composite)super.createDialogArea(parent);
        this.initializeDialogUnits((Control)parent);
        this.setTitle(Messages.DetachSdkActionsSelectionDialog_title);
        this.setMessage(Messages.DetachSdkActionsSelectionDialog_message);
        Composite container = new Composite(content, 0);
        GridLayoutFactory.swtDefaults().applyTo(container);
        GridDataFactory.swtDefaults().grab(true, false).align(4, 4).applyTo((Control)container);
        this.createInfoComposite(container);
        this.createBackupProjectFileComposite(container);
        this.setHelpAvailable(false);
        return content;
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(Messages.DetachSdkActionsSelectionDialog_title);
    }

    protected void createButtonsForButtonBar(Composite parent) {
        super.createButtonsForButtonBar(parent);
        this.getButton(0).setText(IDialogConstants.PROCEED_LABEL);
    }

    public boolean isCreateProjectBackup() {
        return this.isCreateProjectBackup;
    }

    public String getBackupFilePath() {
        return this.backupFilePath;
    }

    private void createInfoComposite(Composite container) {
        Composite sdksInfoComposite = new Composite(container, 0);
        GridLayoutFactory.swtDefaults().numColumns(2).applyTo(sdksInfoComposite);
        GridDataFactory.swtDefaults().grab(true, false).align(4, 4).applyTo((Control)sdksInfoComposite);
        Label headerLabel = new Label(sdksInfoComposite, 0);
        headerLabel.setText(Messages.DetachSdkActionsSelectionDialog_label_info_header);
        GridDataFactory.swtDefaults().span(2, 1).align(1, 0x1000000).applyTo((Control)headerLabel);
        Image image = SdkUiActivator.getInstance().getImage("SDK_CHECK_MARK_ICON");
        for (SdkDescriptor sdk : this.sdksToDetach) {
            Label iconLabel = new Label(sdksInfoComposite, 0);
            iconLabel.setImage(image);
            GridDataFactory.swtDefaults().align(1, 0x1000000).applyTo((Control)iconLabel);
            Label textLabel = new Label(sdksInfoComposite, 0);
            textLabel.setText(SdkManagementUtils.getSdkBriefInfo((SdkDescriptor)sdk, (boolean)false));
            GridDataFactory.swtDefaults().grab(true, false).align(4, 0x1000000).applyTo((Control)textLabel);
        }
        Label footerLabel = new Label(sdksInfoComposite, 0);
        footerLabel.setText(Messages.DetachSdkActionsSelectionDialog_label_info_footer);
        GridDataFactory.swtDefaults().span(2, 1).align(1, 0x1000000).applyTo((Control)footerLabel);
    }

    private void createBackupProjectFileComposite(Composite container) {
        Button backupButton = new Button(container, 32);
        backupButton.setText(Messages.DetachSdkActionsSelectionDialog_checkbox_backup_project_text);
        GridDataFactory.swtDefaults().span(3, 1).grab(true, false).align(4, 4).applyTo((Control)backupButton);
        backupButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                DetachSdkActionsSelectionDialog.this.isCreateProjectBackup = true;
                boolean isSelected = ((Button)event.getSource()).getSelection();
                DetachSdkActionsSelectionDialog.this.backupFileComposite.setEnabled(isSelected);
                if (!isSelected) {
                    DetachSdkActionsSelectionDialog.this.backupFilePath = null;
                } else {
                    DetachSdkActionsSelectionDialog.this.getButton(0).setEnabled(DetachSdkActionsSelectionDialog.this.backupFilePath != null);
                }
            }
        });
        this.backupFileComposite = new Composite(container, 0){

            public void setEnabled(boolean isEnabled) {
                super.setEnabled(isEnabled);
                Arrays.stream(this.getChildren()).filter(control -> !control.isDisposed()).forEach(control -> control.setEnabled(isEnabled));
            }
        };
        GridLayoutFactory.swtDefaults().numColumns(3).equalWidth(false).applyTo(this.backupFileComposite);
        GridDataFactory.swtDefaults().grab(true, false).align(4, 4).applyTo((Control)this.backupFileComposite);
        Label label = new Label(this.backupFileComposite, 0);
        label.setText(Messages.DetachSdkActionsSelectionDialog_label_backup_project_file);
        GridDataFactory.swtDefaults().align(1, 0x1000000).applyTo((Control)label);
        final Text fileLocationText = new Text(this.backupFileComposite, 2056);
        GridDataFactory.swtDefaults().grab(true, false).align(4, 0x1000000).applyTo((Control)fileLocationText);
        Button browseButton = new Button(this.backupFileComposite, 8);
        browseButton.setText(Messages.DetachSdkActionsSelectionDialog_button_browse_backup_project_file_text);
        GridDataFactory.swtDefaults().align(1, 0x1000000).applyTo((Control)browseButton);
        browseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                FileDialog saveFileDialog = new FileDialog(Display.getDefault().getActiveShell(), 8192);
                saveFileDialog.setFileName(DetachSdkActionsSelectionDialog.this.project.getName());
                saveFileDialog.setFilterExtensions(new String[]{"*.zip"});
                DetachSdkActionsSelectionDialog.this.backupFilePath = saveFileDialog.open();
                if (DetachSdkActionsSelectionDialog.this.backupFilePath != null) {
                    DetachSdkActionsSelectionDialog.this.backupFilePath = String.valueOf(DetachSdkActionsSelectionDialog.this.backupFilePath) + DetachSdkActionsSelectionDialog.DEFAULT_BACKUP_FILE_EXTENSION;
                    fileLocationText.setText(DetachSdkActionsSelectionDialog.this.backupFilePath);
                    DetachSdkActionsSelectionDialog.this.getButton(0).setEnabled(true);
                }
            }
        });
        this.setButtonLayoutData(browseButton);
        this.backupFileComposite.setEnabled(false);
    }
}

