/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.cle.cdt.sdk.internal.ui.attach;

import com.nxp.s32ds.cle.cdt.project.configuration.core.ProjectConfigurationUtils;
import com.nxp.s32ds.cle.cdt.sdk.core.attach.SdkAttachProcessor;
import com.nxp.s32ds.cle.cdt.sdk.core.attach.SdkAttachStatuses;
import com.nxp.s32ds.cle.cdt.sdk.core.attach.SdkAttachStatusesHolder;
import com.nxp.s32ds.cle.cdt.sdk.core.attach.checkers.SdkAttachConflictingProjectFilesCheckHandler;
import com.nxp.s32ds.cle.cdt.sdk.core.attach.checkers.SdkAttachConflictingProjectFilesChecker;
import com.nxp.s32ds.cle.cdt.sdk.core.utils.SdkManagementUtils;
import com.nxp.s32ds.cle.cdt.sdk.internal.core.SdkCoreActivator;
import com.nxp.s32ds.cle.cdt.sdk.internal.core.attach.ChangedAttachmentData;
import com.nxp.s32ds.cle.cdt.sdk.internal.core.attach.SdkAttachProjectResourcesOverrideData;
import com.nxp.s32ds.cle.cdt.sdk.internal.ui.Messages;
import com.nxp.s32ds.cle.cdt.sdk.internal.ui.SdkUiActivator;
import com.nxp.s32ds.cle.cdt.sdk.internal.ui.attach.SdkAttachConflictingFilesUiHandler;
import com.nxp.s32ds.cle.cdt.sdk.ui.attach.wizard.SdkAttachWizard;
import com.nxp.s32ds.cle.runtime.sdk.registry.SdkDescriptor;
import com.nxp.s32ds.cle.runtime.sdk.registry.core.SdkDescriptors;
import com.nxp.s32ds.cle.runtime.sdk.registry.core.module.ModuleSdkDescriptors;
import java.io.BufferedInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.eclipse.cdt.managedbuilder.core.IBuildObject;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.progress.IProgressService;

public class SdkAttachmentChangeHandler {
    private static Map<String, List<IStatus>> changedSDKAttachments = new LinkedHashMap<String, List<IStatus>>();
    private static SdkAttachWizard attachWizard;

    private SdkAttachmentChangeHandler() {
    }

    public static IStatus handleSdksAttachmentsChanges(IProject project, IProgressMonitor monitor) {
        if (project == null || !project.isAccessible() || changedSDKAttachments == null || changedSDKAttachments.isEmpty()) {
            return Status.CANCEL_STATUS;
        }
        SdkAttachmentChangeHandler.checkSdksForAttach(changedSDKAttachments, project);
        List<SdkDescriptor> sdkList = changedSDKAttachments.keySet().stream().filter(SdkManagementUtils::isSdkExists).collect(Collectors.mapping(SdkDescriptors::getSdkDescriptor, Collectors.toList()));
        LinkedHashMap<SdkDescriptor, Collection<IConfiguration>> sdksToAttach = new LinkedHashMap<SdkDescriptor, Collection<IConfiguration>>();
        LinkedHashMap<SdkDescriptor, Collection<IConfiguration>> sdksToDetach = new LinkedHashMap<SdkDescriptor, Collection<IConfiguration>>();
        SdkAttachmentChangeHandler.prepareAttachDetachData(sdkList, project, sdksToAttach, sdksToDetach);
        if (sdksToAttach.isEmpty() && sdksToDetach.isEmpty()) {
            changedSDKAttachments.clear();
            return Status.OK_STATUS;
        }
        MultiStatus resultStatus = SdkUiActivator.getInstance().createMultiStatus();
        if (monitor == null) {
            resultStatus.addAll(SdkAttachmentChangeHandler.detachSdks(project, sdksToDetach));
            resultStatus.addAll(SdkAttachmentChangeHandler.attachSdks(project, sdksToAttach));
        } else {
            resultStatus.addAll(SdkAttachmentChangeHandler.attachSdksToProjectConfigurations(project, sdksToAttach, monitor));
            resultStatus.addAll(SdkAttachmentChangeHandler.detachSdksFromProjectConfigurations(project, sdksToDetach, monitor));
        }
        if (attachWizard != null && attachWizard.getDetachPage().isCreateProjectBackup()) {
            SdkAttachmentChangeHandler.backupProject(project, attachWizard.getDetachPage().getBackupFilePath());
        }
        changedSDKAttachments.clear();
        SdkAttachStatusesHolder.INSTANCE.commitSDKsAttachStates();
        return resultStatus;
    }

    private static IStatus attachSdksToProjectConfigurations(IProject project, Map<SdkDescriptor, Collection<IConfiguration>> sdksToAttach, IProgressMonitor monitor) {
        if (sdksToAttach.isEmpty()) {
            return Status.OK_STATUS;
        }
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        MultiStatus resultStatus = SdkUiActivator.getInstance().createMultiStatus();
        SdkAttachConflictingProjectFilesChecker conflictingProjectFilesChecker = new SdkAttachConflictingProjectFilesChecker((SdkAttachConflictingProjectFilesCheckHandler)new SdkAttachConflictingFilesUiHandler(), project);
        Iterator<Map.Entry<SdkDescriptor, Collection<IConfiguration>>> it = sdksToAttach.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<SdkDescriptor, Collection<IConfiguration>> e = it.next();
            SdkDescriptor sdk = e.getKey();
            Collection<IConfiguration> configurations = e.getValue();
            SdkAttachProjectResourcesOverrideData overrideData = new SdkAttachProjectResourcesOverrideData();
            if (conflictingProjectFilesChecker.checkConflictingProjectFiles(sdk, overrideData).isOK()) {
                resultStatus.addAll(SdkAttachProcessor.attachSdkToProjectConfigurations((SdkDescriptor)sdk, configurations, (SdkAttachProjectResourcesOverrideData)overrideData, (boolean)true, (IProgressMonitor)monitor));
                continue;
            }
            it.remove();
            SdkAttachmentChangeHandler.undoSdkAttachStates(sdk.getId(), configurations, project);
        }
        SdkAttachmentChangeHandler.showAttachDetachMessage(sdksToAttach, project, true);
        return resultStatus;
    }

    private static IStatus detachSdksFromProjectConfigurations(IProject project, Map<SdkDescriptor, Collection<IConfiguration>> sdksToDetach, IProgressMonitor monitor) {
        if (sdksToDetach.isEmpty()) {
            return Status.OK_STATUS;
        }
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        MultiStatus resultStatus = SdkUiActivator.getInstance().createMultiStatus();
        resultStatus.addAll(SdkAttachProcessor.detachSdksFromProjectConfigurations(sdksToDetach, (IProject)project, (IProgressMonitor)monitor));
        SdkAttachmentChangeHandler.showAttachDetachMessage(sdksToDetach, project, false);
        return resultStatus;
    }

    public static Map<String, List<IStatus>> checkSdksForAttach(Map<String, List<IStatus>> sdksToAttachStates, IProject project) {
        Iterator<Map.Entry<String, List<IStatus>>> it = sdksToAttachStates.entrySet().iterator();
        while (it.hasNext()) {
            String sdkId = it.next().getKey();
            if (!SdkManagementUtils.isSdkExists((String)sdkId)) {
                it.remove();
                continue;
            }
            List actualStates = SdkAttachStatusesHolder.INSTANCE.getSDKAttachStates(SdkDescriptors.getSdkDescriptor((String)sdkId), project);
            if (actualStates.isEmpty() || !actualStates.stream().noneMatch(s -> s.getSeverity() == 0)) continue;
            SdkAttachStatusesHolder.INSTANCE.addSDKAttachStates(sdkId, actualStates);
            it.remove();
        }
        return sdksToAttachStates;
    }

    private static void prepareAttachDetachData(List<SdkDescriptor> sdkList, IProject project, Map<SdkDescriptor, Collection<IConfiguration>> sdksToAttach, Map<SdkDescriptor, Collection<IConfiguration>> sdksToDetach) {
        sdkList.stream().map(sdk -> ChangedAttachmentData.changeSdkAttachmentData((SdkDescriptor)sdk, (IProject)project)).filter(changeAttachmentData -> !changeAttachmentData.isEmpty()).forEach(changeAttachmentData -> {
            Collection detachConfigurations;
            boolean isSdkConflicting;
            SdkDescriptor sdkDescriptor = changeAttachmentData.getSdkDescriptor();
            Collection attachConfigurations = changeAttachmentData.getAttachConfigurations();
            if (!attachConfigurations.isEmpty() && (!(isSdkConflicting = SdkManagementUtils.isSdkConflicting((List)sdkList, (SdkDescriptor)sdkDescriptor, (IProject)project)) || isSdkConflicting && SdkManagementUtils.isAcceptWarning((SdkDescriptor)sdkDescriptor))) {
                sdksToAttach.put(sdkDescriptor, attachConfigurations);
            }
            if (!(detachConfigurations = changeAttachmentData.getDetachConfigurations()).isEmpty()) {
                sdksToDetach.put(sdkDescriptor, detachConfigurations);
            }
        });
    }

    private static IStatus attachSdks(IProject project, Map<SdkDescriptor, Collection<IConfiguration>> sdksToAttach) {
        if (sdksToAttach.isEmpty()) {
            return Status.OK_STATUS;
        }
        MultiStatus resultStatus = SdkUiActivator.getInstance().createMultiStatus();
        SdkAttachConflictingProjectFilesChecker conflictingProjectFilesChecker = new SdkAttachConflictingProjectFilesChecker((SdkAttachConflictingProjectFilesCheckHandler)new SdkAttachConflictingFilesUiHandler(), project);
        IProgressService progressService = PlatformUI.getWorkbench().getProgressService();
        try {
            progressService.run(false, false, monitor -> {
                Iterator it = sdksToAttach.entrySet().iterator();
                while (it.hasNext()) {
                    Map.Entry e = it.next();
                    SdkDescriptor sdk = (SdkDescriptor)e.getKey();
                    Collection configurations = (Collection)e.getValue();
                    SdkAttachProjectResourcesOverrideData overrideData = new SdkAttachProjectResourcesOverrideData();
                    if (conflictingProjectFilesChecker.checkConflictingProjectFiles(sdk, overrideData).isOK()) {
                        resultStatus.addAll(SdkAttachProcessor.attachSdkToProjectConfigurations((SdkDescriptor)sdk, (Collection)configurations, (SdkAttachProjectResourcesOverrideData)overrideData, (boolean)true, (IProgressMonitor)monitor));
                        continue;
                    }
                    it.remove();
                    SdkAttachmentChangeHandler.undoSdkAttachStates(sdk.getId(), configurations, project);
                }
            });
        }
        catch (InterruptedException | InvocationTargetException exception) {
            Thread.currentThread().interrupt();
            return Status.CANCEL_STATUS;
        }
        SdkAttachmentChangeHandler.showAttachDetachMessage(sdksToAttach, project, true);
        return resultStatus;
    }

    private static void undoSdkAttachStates(String sdkId, Collection<IConfiguration> configsToAttach, IProject project) {
        List actStates = SdkAttachStatusesHolder.INSTANCE.getSDKAttachStates(sdkId);
        List projConfigNames = ProjectConfigurationUtils.getProjectConfigurations((IProject)project).stream().map(IBuildObject::getName).collect(Collectors.toList());
        List attachConfigNames = configsToAttach.stream().map(IBuildObject::getName).collect(Collectors.toList());
        projConfigNames.stream().filter(attachConfigNames::contains).mapToInt(projConfigNames::indexOf).forEach(i -> {
            IStatus iStatus = actStates.set(i, SdkAttachStatuses.OK_SDK_NOT_ATTACHED);
        });
    }

    private static IStatus detachSdks(IProject project, Map<SdkDescriptor, Collection<IConfiguration>> sdksToDetach) {
        if (sdksToDetach.isEmpty()) {
            return Status.OK_STATUS;
        }
        MultiStatus resultStatus = SdkUiActivator.getInstance().createMultiStatus();
        try {
            PlatformUI.getWorkbench().getProgressService().run(false, false, monitor -> resultStatus.addAll(SdkAttachProcessor.detachSdksFromProjectConfigurations((Map)sdksToDetach, (IProject)project, (IProgressMonitor)monitor)));
        }
        catch (InterruptedException | InvocationTargetException e) {
            Thread.currentThread().interrupt();
            IStatus errorStatus = SdkUiActivator.getInstance().createError(String.format("Detaching SDK(s) from project %s error: %s", project.getName(), e.getMessage()), e);
            SdkUiActivator.getInstance().log(errorStatus);
            return errorStatus;
        }
        SdkAttachmentChangeHandler.showAttachDetachMessage(sdksToDetach, project, false);
        return resultStatus;
    }

    public static IStatus backupProject(IProject project, String projectBackupFilePath) {
        ProjectBackupRunnable operation = new ProjectBackupRunnable(project, projectBackupFilePath);
        try {
            PlatformUI.getWorkbench().getProgressService().run(false, false, (IRunnableWithProgress)operation);
        }
        catch (InterruptedException | InvocationTargetException e) {
            Thread.currentThread().interrupt();
            IStatus errorStatus = SdkUiActivator.getInstance().createError(String.format("Detaching SDK(s) from project %s. Error occured while backing up project: %s", project.getName(), e.getMessage()));
            SdkUiActivator.getInstance().log(errorStatus);
        }
        IStatus operationStatus = operation.getStatus();
        if (!operationStatus.isOK()) {
            SdkUiActivator.getInstance().log(operationStatus);
            return operationStatus;
        }
        return Status.OK_STATUS;
    }

    private static void showAttachDetachMessage(Map<SdkDescriptor, Collection<IConfiguration>> sdks, IProject project, boolean isAttach) {
        if (sdks.isEmpty()) {
            return;
        }
        Map<SdkDescriptor, Collection> validEntries = sdks.entrySet().stream().filter(e -> !((Collection)e.getValue()).isEmpty()).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        if (validEntries.isEmpty()) {
            return;
        }
        String messageTitle = isAttach ? Messages.SdkManagementPropertyPage_message_attach_sdks_title : Messages.SdkManagementPropertyPage_message_detach_sdks_title;
        Display display = Display.getDefault();
        String projectName = project.getName();
        if (validEntries.size() == 1) {
            Map.Entry<SdkDescriptor, Collection<IConfiguration>> e2 = validEntries.entrySet().iterator().next();
            String sdkBriefInfo = SdkManagementUtils.getSdkBriefInfo((SdkDescriptor)e2.getKey());
            String messageText = isAttach ? NLS.bind((String)Messages.SdkManagementPropertyPage_message_attach_sdk_text, (Object[])new String[]{sdkBriefInfo, projectName, SdkAttachmentChangeHandler.getConfigurationsList(e2)}) : NLS.bind((String)Messages.SdkManagementPropertyPage_message_detach_sdk_text, (Object[])new String[]{sdkBriefInfo, projectName, SdkAttachmentChangeHandler.getConfigurationsList(e2)});
            display.syncExec(() -> MessageDialog.openInformation((Shell)display.getActiveShell(), (String)messageTitle, (String)messageText));
            return;
        }
        String messageText = isAttach ? NLS.bind((String)Messages.SdkManagementPropertyPage_message_attach_sdks_text, (Object)projectName) : NLS.bind((String)Messages.SdkManagementPropertyPage_message_detach_sdks_text, (Object)projectName);
        String detailsText = isAttach ? Messages.SdkManagementPropertyPage_message_attach_sdks_details : Messages.SdkManagementPropertyPage_message_detach_sdks_details;
        MultiStatus status = SdkUiActivator.getInstance().createMultiStatus(1, messageText);
        validEntries.entrySet().stream().map(e -> SdkUiActivator.getInstance().createStatus(1, NLS.bind((String)detailsText, (Object)SdkManagementUtils.getSdkBriefInfo((SdkDescriptor)((SdkDescriptor)e.getKey())), (Object)SdkAttachmentChangeHandler.getConfigurationsList(e)))).forEach(arg_0 -> ((MultiStatus)status).add(arg_0));
        display.syncExec(() -> {
            int n = new ChangeSdkAttachDialog(messageTitle, display.getActiveShell(), (IStatus)status).open();
        });
    }

    private static String getConfigurationsList(Map.Entry<SdkDescriptor, Collection<IConfiguration>> e) {
        return String.join((CharSequence)", ", e.getValue().stream().map(IBuildObject::getName).collect(Collectors.toList()));
    }

    public static Map<String, List<IStatus>> collectChangedSdksAttachStates(Map<String, List<IStatus>> sdksAttachStates, IProject project) {
        SdkAttachmentChangeHandler.checkSdksForAttach(sdksAttachStates, project);
        sdksAttachStates = sdksAttachStates.entrySet().stream().filter(SdkAttachmentChangeHandler::isSdkAttachStatesEntryValid).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        LinkedHashMap<String, List> aggregatedSdksAttachStates = new LinkedHashMap<String, List>();
        for (Map.Entry<String, List<IStatus>> entry : sdksAttachStates.entrySet()) {
            String sdkId = entry.getKey();
            List<IStatus> srcStates = entry.getValue();
            List actStates = SdkAttachStatusesHolder.INSTANCE.getSDKAttachStates(sdkId);
            boolean isAttachmentStatesChanged = false;
            int i = 0;
            while (i < srcStates.size()) {
                IStatus srcStatus = srcStates.get(i);
                if (!srcStatus.equals(actStates.get(i))) {
                    actStates.set(i, srcStatus);
                    isAttachmentStatesChanged = true;
                }
                ++i;
            }
            if (!isAttachmentStatesChanged) continue;
            if (!ModuleSdkDescriptors.getModuleSdkDescriptorsBySdkId((String)sdkId).isEmpty()) {
                aggregatedSdksAttachStates.put(sdkId, actStates);
                continue;
            }
            changedSDKAttachments.put(sdkId, actStates);
        }
        if (!aggregatedSdksAttachStates.isEmpty()) {
            changedSDKAttachments.putAll(aggregatedSdksAttachStates);
        }
        return changedSDKAttachments;
    }

    private static boolean isSdkAttachStatesEntryValid(Map.Entry<String, List<IStatus>> e) {
        String sdkId = e.getKey();
        if (!SdkManagementUtils.isSdkExists((String)sdkId)) {
            return false;
        }
        List<IStatus> srcStates = e.getValue();
        if (srcStates == null || srcStates.isEmpty() || srcStates.stream().noneMatch(IStatus::isOK)) {
            return false;
        }
        List actStates = SdkAttachStatusesHolder.INSTANCE.getSDKAttachStates(sdkId);
        return actStates != null && srcStates.size() == actStates.size();
    }

    public static IWizard createAttachWizard(IProject project, Map<String, List<IStatus>> sdksAttachStates, Collection<SdkDescriptor> selectedAttachableSdks) {
        attachWizard = new SdkAttachWizard(selectedAttachableSdks, project, sdksAttachStates);
        return attachWizard;
    }

    private static class ChangeSdkAttachDialog
    extends ErrorDialog {
        private ChangeSdkAttachDialog(String title, Shell parentShell, IStatus status) {
            super(parentShell, title, null, status, 1);
        }

        protected boolean shouldShowDetailsButton() {
            return true;
        }

        protected void createButtonsForButtonBar(Composite parent) {
            this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
            this.createDetailsButton(parent);
        }
    }

    private static class ProjectBackupRunnable
    implements IRunnableWithProgress {
        private IProject project;
        private String backupFilePath;
        private IStatus backupStatus;

        private ProjectBackupRunnable(IProject project, String backupFilePath) {
            this.project = Objects.requireNonNull(project);
            this.backupFilePath = Objects.requireNonNull(backupFilePath);
            this.backupStatus = Status.OK_STATUS;
        }

        public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
            this.performProjectBackup(monitor);
        }

        private void performProjectBackup(IProgressMonitor monitor) {
            final SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (String)NLS.bind((String)Messages.SdkAttachmentChangeHandler_task_backup_project, (Object)this.project.getName()), (int)1);
            try {
                Throwable throwable = null;
                Object var4_6 = null;
                try (final ZipOutputStream zos = new ZipOutputStream(new FileOutputStream(this.backupFilePath));){
                    this.project.accept(new IResourceVisitor(){

                        public boolean visit(IResource resource) throws CoreException {
                            return this.backupResource(resource, zos, (IProgressMonitor)subMonitor);
                        }
                    });
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (IOException | CoreException e) {
                this.backupStatus = SdkCoreActivator.getInstance().createError(String.format("Detaching SDK(s) from project %s. Error(s) occured while backing up project.", e));
            }
        }

        private IStatus getStatus() {
            return this.backupStatus;
        }

        private boolean backupResource(IResource resource, ZipOutputStream zos, IProgressMonitor monitor) throws CoreException {
            block15: {
                block14: {
                    if (!resource.isLinked(2)) break block14;
                    return false;
                }
                try {
                    if (resource instanceof IFolder && ((IFolder)resource).members().length == 0) {
                        String zipEntryName = String.valueOf(resource.getFullPath().makeRelative().toString()) + '/';
                        ZipEntry zipEntry = new ZipEntry(zipEntryName);
                        zos.putNextEntry(zipEntry);
                        break block15;
                    }
                    if (!(resource instanceof IFile)) break block15;
                    String zipEntryName = resource.getFullPath().makeRelative().toString();
                    monitor.subTask(zipEntryName);
                    ZipEntry zipEntry = new ZipEntry(zipEntryName);
                    zos.putNextEntry(zipEntry);
                    byte[] readBuffer = new byte[4096];
                    Throwable throwable = null;
                    Object var8_12 = null;
                    try (BufferedInputStream bis = new BufferedInputStream(((IFile)resource).getContents());){
                        int n;
                        while ((n = bis.read(readBuffer)) > 0) {
                            zos.write(readBuffer, 0, n);
                        }
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                    zos.closeEntry();
                    monitor.worked(1);
                }
                catch (IOException ioe) {
                    this.backupStatus = SdkCoreActivator.getInstance().createError(String.format("Detaching SDK(s) from project %s. Error(s) occured while backing up project.", ioe));
                    return false;
                }
            }
            return true;
        }
    }
}

