/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.cle.cdt.sdk.internal.ui.edit.model;

import com.nxp.s32ds.cle.cdt.sdk.internal.ui.edit.model.resource.SdkResource;
import com.nxp.s32ds.cle.cdt.sdk.internal.ui.edit.model.resource.SdkResourcesHolder;
import com.nxp.s32ds.cle.cdt.sdk.internal.ui.edit.model.symbol.SdkSymbolsHolder;
import com.nxp.s32ds.cle.runtime.sdk.registry.resource.ResourceSdkGroup;
import com.nxp.s32ds.cle.runtime.sdk.registry.resource.ResourceSdkKind;
import com.nxp.s32ds.cle.runtime.sdk.registry.symbol.SymbolSdkKind;
import java.util.Collections;
import java.util.Set;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ToolChainHolder {
    public static final String ALL_TOOLCAHINS_ID = "all_toolchains";
    private final String toolchainId;
    private final String alias;
    private SdkResourcesHolder resourcesHolder;
    private SdkSymbolsHolder symbolsHolder;

    public ToolChainHolder(String tc) {
        this(tc, null);
    }

    private ToolChainHolder(String toolchainId, String alias) {
        this.toolchainId = toolchainId;
        this.alias = alias;
        this.resourcesHolder = new SdkResourcesHolder(toolchainId);
        this.symbolsHolder = new SdkSymbolsHolder(toolchainId);
    }

    public ToolChainHolder(Element toolChainElement, String sdkBasePath) {
        this(toolChainElement.getAttribute("id"), toolChainElement.getAttribute("alias"));
        NodeList nodeList = toolChainElement.getChildNodes();
        int i = 0;
        while (i < nodeList.getLength()) {
            Node childNode = nodeList.item(i);
            if (childNode.getNodeType() == 1) {
                Element childElement = (Element)childNode;
                this.process(childElement, sdkBasePath);
            }
            ++i;
        }
    }

    public String getTCId() {
        return this.toolchainId;
    }

    public String getTCAlias() {
        return this.alias;
    }

    public void addSymbol(Element element) {
        this.symbolsHolder.addSymbol(element.getAttribute("name"), element.getAttribute("langId"), element.getAttribute("configurations"), SymbolSdkKind.of((String)element.getAttribute("type")));
    }

    public void addSymbol(String symbolName, String langId, String configurations, SymbolSdkKind type) {
        this.symbolsHolder.addSymbol(symbolName, langId, configurations, type);
    }

    public SdkSymbolsHolder getSymbolsHolder() {
        return this.symbolsHolder != null ? this.symbolsHolder : new SdkSymbolsHolder(this.toolchainId);
    }

    private SdkResourcesHolder getResourcesHolder() {
        return this.resourcesHolder != null ? this.resourcesHolder : new SdkResourcesHolder(this.toolchainId);
    }

    public void process(Element element, String sdkBasePath) {
        String elementName = element.getNodeName();
        if (ResourceSdkKind.validValues().stream().map(ResourceSdkKind::getXmlElementName).anyMatch(elementName::equals)) {
            this.getResourcesHolder().addResource(element, sdkBasePath);
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Tool Chain Holder ALIAS = ").append(this.alias);
        sb.append(" TOOLCHAIN = ").append(this.toolchainId);
        sb.append(this.getResourcesHolder().toString());
        sb.append(this.getSymbolsHolder().toString());
        sb.append(" END.");
        return sb.toString();
    }

    public Set<SdkResource> getResourceByType(ResourceSdkGroup type) {
        switch (type) {
            case BINARY_RESOURCES: {
                return this.getResourcesHolder().getBinaryFiles();
            }
            case HEADER_RESOURCES: {
                return this.getResourcesHolder().getHeaders();
            }
            case INCLUDE_FILE_RESOURCES: {
                return this.getResourcesHolder().getIncludeFiles();
            }
            case LINKER_RESOURCES: {
                return this.getResourcesHolder().getLinkerFiles();
            }
            case UNSPECIFIED_RESOURCES: {
                return this.getResourcesHolder().getUntypedResources();
            }
            case SOURCE_RESOURCES: {
                return this.getResourcesHolder().getSources();
            }
        }
        return Collections.emptySet();
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.alias == null ? 0 : this.alias.hashCode());
        result = 31 * result + (this.toolchainId == null ? 0 : this.toolchainId.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ToolChainHolder other = (ToolChainHolder)obj;
        if (this.alias == null ? other.alias != null : !this.alias.equals(other.alias)) {
            return false;
        }
        return !(this.toolchainId == null ? other.toolchainId != null : !this.toolchainId.equals(other.toolchainId));
    }
}

