/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.cle.cdt.sdk.ui.property;

import com.nxp.s32ds.cle.cdt.sdk.filtering.SdkFilteringParameters;
import com.nxp.s32ds.cle.cdt.sdk.internal.ui.property.WizardSelectSdksDialog;
import com.nxp.s32ds.cle.runtime.sdk.registry.SdkDescriptor;
import com.nxp.s32ds.cle.runtime.sdk.registry.core.SdkDescriptors;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.jface.viewers.DialogCellEditor;
import org.eclipse.jface.viewers.ICellEditorListener;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public class WizardSdksDialogCellEditor
extends DialogCellEditor {
    private SdkFilteringParameters sdkFilteringParams;

    public static Control getControl(Composite parent, List<String> sdksIds, String processorTag, SdkFilteringParameters sdkFilteringParams, final WizardSdksDialogEditorListener listener) {
        final WizardSdksDialogCellEditor editor = new WizardSdksDialogCellEditor(parent, 2048, sdkFilteringParams);
        List<SdkDescriptor> sdks = WizardSdksDialogCellEditor.getSdkListFilteredByTags(sdksIds, processorTag);
        List<SdkDescriptor> choosenSdks = WizardSdksDialogCellEditor.getSdkListFilteredByVersion(sdks);
        if (choosenSdks != null && !choosenSdks.isEmpty()) {
            editor.setValue(choosenSdks.stream().toArray());
        }
        editor.addListener(new ICellEditorListener(){
            private Object previousValue = null;

            public void editorValueChanged(boolean oldState, boolean newState) {
            }

            public void cancelEditor() {
            }

            public void applyEditorValue() {
                Object value = editor.getValue();
                if (listener != null && value != null) {
                    if (value.equals(this.previousValue)) {
                        return;
                    }
                    this.previousValue = value;
                    listener.applyValue(Arrays.stream((Object[])value).filter(obj -> obj instanceof SdkDescriptor).map(obj -> ((SdkDescriptor)obj).getId()).collect(Collectors.toList()));
                }
            }
        });
        return editor.getControl();
    }

    private WizardSdksDialogCellEditor(Composite parent, int style, SdkFilteringParameters sdkFilteringParams) {
        super(parent, style);
        this.sdkFilteringParams = sdkFilteringParams;
    }

    private static List<SdkDescriptor> getSdkListFilteredByTags(List<String> sdksList, String processorTag) {
        if (sdksList == null || sdksList.isEmpty()) {
            return Collections.emptyList();
        }
        return sdksList.stream().map(SdkDescriptors::getSdkDescriptor).filter(Objects::nonNull).filter(sdkDescriptor -> WizardSdksDialogCellEditor.containsTag(sdkDescriptor, processorTag)).collect(Collectors.toList());
    }

    private static List<SdkDescriptor> getSdkListFilteredByVersion(List<SdkDescriptor> sdkList) {
        if (sdkList == null || sdkList.isEmpty()) {
            return Collections.emptyList();
        }
        SdkDescriptor sdkWithMaxVersion = sdkList.stream().max(Comparator.comparing(SdkDescriptor::getVersion)).orElse(null);
        if (sdkWithMaxVersion == null) {
            return Collections.emptyList();
        }
        String maxVersion = sdkWithMaxVersion.getVersion();
        if (maxVersion == null) {
            return Collections.singletonList(sdkWithMaxVersion);
        }
        return sdkList.stream().filter(sdk -> sdk.getVersion().equals(maxVersion)).collect(Collectors.toList());
    }

    private static boolean containsTag(SdkDescriptor sdk, String sdkTag) {
        Set tags = sdk.getTags();
        return tags != null && tags.contains(sdkTag);
    }

    protected Object openDialogBox(Control cellEditorWindow) {
        WizardSelectSdksDialog dialog = new WizardSelectSdksDialog(cellEditorWindow.getShell(), this.sdkFilteringParams, this.getValue());
        if (dialog.open() == 0) {
            return dialog.get();
        }
        return null;
    }

    public void deactivate() {
    }

    protected void updateContents(Object value) {
        List selectedSdksIdentifiers = Arrays.stream(this.checkNullAndCastToArray(value)).filter(sel -> sel instanceof SdkDescriptor).map(sel -> (SdkDescriptor)sel).map(sdk -> NLS.bind((String)"{0} v {1}", (Object)sdk.getName(), (Object)sdk.getVersion())).collect(Collectors.toList());
        super.updateContents((Object)String.join((CharSequence)", ", selectedSdksIdentifiers));
    }

    private Object[] checkNullAndCastToArray(Object value) {
        return value != null ? (Object[])value : new Object[]{};
    }

    @FunctionalInterface
    public static interface WizardSdksDialogEditorListener {
        public void applyValue(List<String> var1);
    }
}

