/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.ext.rcp.internal.ui.resources;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.eclipse.core.runtime.Platform;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.widgets.Display;

public class MonospaceFontUtils {
    private static final FontData[] LINUX_GTK_DATA = new FontData[]{new FontData("Monospace", 10, 0)};
    private static final FontData[] LINUX_DATA = new FontData[]{new FontData("adobe-courier", 12, 0)};
    private static final FontData[] MACOSX_DATA = new FontData[]{new FontData("Monaco", 11, 0), new FontData("Courier", 12, 0), new FontData("Courier New", 12, 0)};
    private static final FontData[] WINDOWS_DATA = new FontData[]{new FontData("Consolas", 10, 0), new FontData("Courier New", 10, 0)};
    private static final FontData[] DEFAULT_DATA = new FontData[]{new FontData("Courier New", 10, 0), new FontData("Courier", 10, 0), new FontData("b&h-lucidabright", 9, 0)};
    private static final Map<Display, Font> FONTS_MAP = new ConcurrentHashMap<Display, Font>();

    public static Font getMonospacedFont(Display display) {
        return FONTS_MAP.computeIfAbsent(display, d -> MonospaceFontUtils.createFont(d));
    }

    private static Font createFont(Display display) {
        FontData[] fontDatas;
        block5 : switch (Platform.getOS()) {
            case "linux": {
                switch (Platform.getWS()) {
                    case "gtk": {
                        fontDatas = LINUX_GTK_DATA;
                        break block5;
                    }
                }
                fontDatas = LINUX_DATA;
                break;
            }
            case "macosx": {
                fontDatas = MACOSX_DATA;
                break;
            }
            case "win32": {
                fontDatas = WINDOWS_DATA;
                break;
            }
            default: {
                fontDatas = DEFAULT_DATA;
            }
        }
        Font font = new Font((Device)display, fontDatas);
        display.disposeExec(() -> {
            FONTS_MAP.remove(display);
            font.dispose();
        });
        return font;
    }
}

