/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.bootimage.settings;

import com.nxp.swtools.bootimage.settings.ABaseComponentSetting;
import com.nxp.swtools.bootimage.settings.Description;
import com.nxp.swtools.bootimage.settings.MessagesSetting;
import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.common.utils.number.NumberFormatValidator;
import java.util.Objects;
import org.simpleframework.xml.Attribute;
import org.simpleframework.xml.Root;

@Root(name="reserved_values", strict=false)
public class ReservedValuesSetting
extends ABaseComponentSetting
implements Comparable<ReservedValuesSetting> {
    @Attribute(name="start_value", required=false)
    private String startValue;
    @Attribute(name="end_value", required=false)
    private String endValue;
    @Attribute(name="start_value_expr", required=false)
    private String startValueExpr;
    @Attribute(name="end_value_expr", required=false)
    private String endValueExpr;
    @Attribute(name="show_segment", required=false)
    private String showSegment = "false";

    public ReservedValuesSetting(String id, String label, @Nullable Description description, String startValue, String endValue, String options, @Nullable MessagesSetting messages, String showSegment, String startValueExpr, String endValueExpr) {
        super(id, label, description, "", options, messages, -1L, "");
        this.startValue = startValue;
        this.endValue = endValue;
        this.startValueExpr = startValueExpr;
        this.endValueExpr = endValueExpr;
        this.showSegment = showSegment;
    }

    public ReservedValuesSetting() {
        this.startValue = "";
        this.endValue = "";
        this.startValueExpr = "";
        this.endValueExpr = "";
        this.showSegment = "false";
    }

    public String getReservedValue() {
        return this.getInitValue();
    }

    public long getStartReservedValue() {
        long value = 0L;
        if (NumberFormatValidator.isValidXmlHexFormat((String)this.startValue)) {
            value = NumberFormatValidator.getDecimalLongFromXmlHex((String)this.startValue);
        } else if (NumberFormatValidator.isValidDecimal((String)this.startValue)) {
            value = NumberFormatValidator.getLongFromStringDecimal((String)this.startValue);
        }
        return value;
    }

    public long getEndReservedValue() {
        long value = 0L;
        if (NumberFormatValidator.isValidXmlHexFormat((String)this.endValue)) {
            value = NumberFormatValidator.getDecimalLongFromXmlHex((String)this.endValue);
        } else if (NumberFormatValidator.isValidDecimal((String)this.endValue)) {
            value = NumberFormatValidator.getLongFromStringDecimal((String)this.endValue);
        }
        return value;
    }

    public String getStartReservedValueExpression() {
        return this.startValueExpr;
    }

    public String getEndReservedValueExpression() {
        return this.endValueExpr;
    }

    public boolean shouldShowSegment() {
        return this.showSegment.equals("true");
    }

    @Override
    public int compareTo(ReservedValuesSetting reservedValues) {
        return Long.toString(this.getStartReservedValue()).compareTo(Long.toString(reservedValues.getStartReservedValue()));
    }

    public int hashCode() {
        return Objects.hash(Long.toString(this.getStartReservedValue()));
    }

    public boolean equals(@Nullable Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ReservedValuesSetting other = (ReservedValuesSetting)obj;
        return Objects.equals(Long.toString(this.getStartReservedValue()), Long.toString(other.getStartReservedValue()));
    }
}

