/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.provider.analytics;

import com.nxp.swtools.common.utils.NonNull;
import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.common.utils.logging.LogManager;
import com.nxp.swtools.common.utils.text.UtilsText;
import com.nxp.swtools.provider.analytics.ActionWithAnalytics;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.resource.ImageDescriptor;

public class ActionAnalyticsBuilder {
    @Nullable
    Runnable fRunnable;
    @Nullable
    String fId;
    @Nullable
    String fText;
    @Nullable
    ImageDescriptor fImage;
    int fStyle = 0;
    private String fToolTipText;
    private boolean fEnabled = true;
    private final Logger LOGGER = LogManager.getLogger(ActionAnalyticsBuilder.class);

    public static @NonNull ActionAnalyticsBuilder empty() {
        return new ActionAnalyticsBuilder();
    }

    public static @NonNull ActionAnalyticsBuilder action(@NonNull Runnable runnable) {
        return ActionAnalyticsBuilder.empty().runnable(runnable);
    }

    public @NonNull ActionAnalyticsBuilder runnable(@NonNull Runnable runnable) {
        this.fRunnable = runnable;
        return this;
    }

    public @NonNull ActionAnalyticsBuilder id(@NonNull String id) {
        this.fId = id;
        return this;
    }

    public @NonNull ActionAnalyticsBuilder tooltip(@NonNull String tooltip) {
        this.fToolTipText = tooltip;
        return this;
    }

    public @NonNull ActionAnalyticsBuilder text(String text) {
        this.fText = text;
        assert (this.fText != null);
        return this;
    }

    public @NonNull ActionAnalyticsBuilder image(@Nullable ImageDescriptor image) {
        this.fImage = image;
        return this;
    }

    public @NonNull IAction build() {
        final Runnable r = this.fRunnable;
        assert (r != null);
        ActionWithAnalytics action = new ActionWithAnalytics(UtilsText.safeString((String)this.fText), this.fStyle){

            @Override
            public void run() {
                r.run();
                this.logAnalytics();
            }
        };
        if (UtilsText.isEmpty((String)this.fId)) {
            this.LOGGER.log(Level.WARNING, "Empty id for action: {0}", this.fText);
        }
        action.setId(this.fId);
        action.setImageDescriptor(this.fImage);
        action.setToolTipText(this.fToolTipText);
        action.setEnabled(this.fEnabled);
        return action;
    }

    public @NonNull ActionAnalyticsBuilder style(int style) {
        this.fStyle = style;
        return this;
    }

    public @NonNull ActionAnalyticsBuilder enabled(boolean enabled) {
        this.fEnabled = enabled;
        return this;
    }
}

