/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.provider.analytics;

import com.nxp.swtools.common.utils.NonNullByDefault;
import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.kex.analytics.IAnalytics;
import com.nxp.swtools.provider.configuration.ISharedConfiguration;
import com.nxp.swtools.provider.configuration.SharedConfigurationFactory;
import java.util.Arrays;
import java.util.regex.Pattern;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.IExecutionListener;
import org.eclipse.core.commands.NotHandledException;

@NonNullByDefault
public class CommandListenerAnalytics
implements IExecutionListener {
    public static final String COMMAND_ACTION = "command";
    private IAnalytics analytics;
    static final String[] IGNORED_COMMANDS = new String[]{"org\\.eclipse\\.cdt\\.ui\\.edit\\..+", "org\\.eclipse\\.debug\\.ui\\.commands\\..+", "org\\.eclipse\\.egit\\..+", "org\\.eclipse\\.jdt\\..+", "org\\.eclipse\\.search\\.ui\\..+", "org\\.eclipse\\.ui\\.edit\\..+", "org\\.eclipse\\.ui\\.file\\..+", "org\\.eclipse\\.ui\\.navigate\\..+", "org\\.eclipse\\.ui\\.window\\..+", "org\\.eclipse\\.team\\..+", "org\\.eclipse\\.tm\\..+"};
    static final Pattern[] IGNORED_COMMANDS_PATTERNS = (Pattern[])Arrays.stream(IGNORED_COMMANDS).map(Pattern::compile).toArray(Pattern[]::new);

    public CommandListenerAnalytics(IAnalytics analytics) {
        this.analytics = analytics;
    }

    public void notHandled(String commandId, NotHandledException exception) {
    }

    public void postExecuteFailure(String commandId, ExecutionException exception) {
    }

    public void postExecuteSuccess(String commandId, @Nullable Object returnValue) {
    }

    public void preExecute(String commandId, ExecutionEvent event) {
        ISharedConfiguration configuration = SharedConfigurationFactory.getSharedConfigurationSingleton();
        if (CommandListenerAnalytics.commandFilter(commandId)) {
            this.analytics.logUserAction(configuration.getUUID(), COMMAND_ACTION, commandId);
        }
    }

    private static boolean commandFilter(String commandId) {
        int i = 0;
        while (i < IGNORED_COMMANDS_PATTERNS.length) {
            if (IGNORED_COMMANDS_PATTERNS[i].matcher(commandId).matches()) {
                return false;
            }
            ++i;
        }
        return true;
    }
}

