/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.provider.configuration.dependencies;

import com.nxp.swtools.common.utils.NonNull;
import com.nxp.swtools.common.utils.logging.LogManager;
import com.nxp.swtools.common.utils.runtime.ExecutableExtensionProvider;
import com.nxp.swtools.common.utils.text.UtilsText;
import com.nxp.swtools.configuration.properties.SWToolsProperties;
import com.nxp.swtools.provider.configuration.ISharedConfiguration;
import com.nxp.swtools.provider.configuration.dependencies.DependencyQueryAnnotation;
import com.nxp.swtools.provider.configuration.dependencies.DependencyResourceAnotation;
import com.nxp.swtools.provider.configuration.dependencies.IDependencyQuery;
import com.nxp.swtools.provider.configuration.dependencies.IDependencyQueryResult;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.logging.Level;
import java.util.logging.Logger;

public class DependencyQueryFactory {
    private static final Logger LOGGER = LogManager.getLogger(DependencyQueryFactory.class);

    private DependencyQueryFactory() {
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    static Collection<@NonNull IDependencyQuery> getQueryResolveInstances() {
        @NonNull ExecutableExtensionProvider provider = new ExecutableExtensionProvider("com.nxp.swtools.sharedconfiguration.validation", "validationQuery", "class");
        return provider.getExtensions();
    }

    static boolean supportedQuery(String resourceType, String featureName, DependencyResourceAnotation annotation) {
        if (annotation.resourceType().equalsIgnoreCase(resourceType)) {
            if (Arrays.stream(annotation.features()).anyMatch(featureName::equalsIgnoreCase)) {
                return true;
            }
        }
        return false;
    }

    static Logger getLogger() {
        return LOGGER;
    }

    public static IDependencyQuery getQueryInstance(ISharedConfiguration configuration) {
        return new QueryInstanceImpl();
    }

    static class QueryInstanceImpl
    implements IDependencyQuery {
        private Collection<@NonNull IDependencyQuery> resolveInstances = DependencyQueryFactory.getQueryResolveInstances();

        @Override
        public @NonNull Collection<@NonNull IDependencyQueryResult> query(ISharedConfiguration configuration, @NonNull String resourceType, @NonNull String resourceId, @NonNull String featureName) {
            ArrayList<@NonNull IDependencyQueryResult> result = new ArrayList<IDependencyQueryResult>();
            this.resolveInstances.stream().forEach(q -> {
                DependencyQueryAnnotation ann = q.getClass().getAnnotation(DependencyQueryAnnotation.class);
                if (ann != null) {
                    try {
                        if (Arrays.stream(ann.resources()).anyMatch(r -> DependencyQueryFactory.supportedQuery(resourceType, featureName, r))) {
                            IDependencyQuery queryInstance = q;
                            result.addAll(queryInstance.query(configuration, resourceType, resourceId, featureName));
                        }
                    }
                    catch (Exception e) {
                        DependencyQueryFactory.getLogger().log(Level.SEVERE, e.getMessage(), e);
                    }
                } else {
                    DependencyQueryFactory.getLogger().log(Level.WARNING, "class {0} does not have @DependencyQueryAnnotation annotation", q);
                }
            });
            if (SWToolsProperties.isVerificationOn()) {
                for (IDependencyQueryResult res : result) {
                    Object resValue = res.getValue();
                    String nullError = res.getNullError();
                    if (resValue != null || nullError == null) continue;
                    DependencyQueryFactory.getLogger().log(Level.WARNING, () -> MessageFormat.format("Null result for query type=''{0}'', resourceid=''{1}'', feature=''{2}'' from tool ''{3}'': {4}", resourceType, resourceId, featureName, res.getSourceTool().getName(), nullError));
                    if (!UtilsText.isEmpty((String)nullError)) continue;
                    DependencyQueryFactory.getLogger().log(Level.FINE, () -> MessageFormat.format("[TOOL] Null result for query type=''{0}'', resourceid=''{1}'', feature=''{2}'' from tool ''{3}'': Error message not specified - need to be added", resourceType, resourceId, featureName, res.getSourceTool().getName()));
                }
                if (result.isEmpty()) {
                    DependencyQueryFactory.getLogger().log(Level.SEVERE, () -> MessageFormat.format("There was no result for query type=''{0}'', resourceid=''{1}'', feature=''{2}''. No tool was able to answer the query.", resourceType, resourceId, featureName));
                }
            }
            return result;
        }
    }
}

