/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.provider.configuration.helper;

import com.nxp.swtools.common.utils.NonNull;
import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.common.utils.lang.CollectionsUtils;
import com.nxp.swtools.common.utils.text.UtilsText;
import com.nxp.swtools.kex.selector.IMcuIdentification;
import com.nxp.swtools.kex.selector.IMcuSelectionWritable;
import com.nxp.swtools.kex.selector.McuSelectionFactory;
import com.nxp.swtools.provider.Messages;
import com.nxp.swtools.provider.configuration.ICommonConfig;
import com.nxp.swtools.provider.configuration.storage.ProcessorCore;
import com.nxp.swtools.provider.configuration.storage.Shield;
import java.util.ArrayList;
import java.util.Collection;
import org.simpleframework.xml.Attribute;
import org.simpleframework.xml.Element;
import org.simpleframework.xml.ElementList;
import org.simpleframework.xml.Root;
import org.simpleframework.xml.Transient;
import org.simpleframework.xml.core.Commit;

@Root(strict=false)
public class CommonConfigImpl
implements ICommonConfig,
IMcuSelectionWritable {
    static final long serialVersionUID = 1L;
    @Transient
    int sessionIndex = 0;
    @Element(name="processor")
    @NonNull
    @Element(name="processor") @NonNull String mcu = "";
    @Element(name="package", required=false)
    private String mcuPackage;
    @Element(name="board", required=false)
    @Nullable
    private @Element(name="board", required=false) @Nullable String board;
    @Element(name="board_revision", required=false)
    @Nullable
    private @Element(name="board_revision", required=false) @Nullable String boardRevision;
    @Element(name="kit", required=false)
    @Nullable
    private @Element(name="kit", required=false) @Nullable String kit;
    @ElementList(name="shields", entry="shield", required=false)
    @Nullable
    @ElementList(name="shields", entry="shield", required=false) @Nullable ArrayList<Shield> shields = null;
    @Element(name="mcu_data")
    @NonNull
    private @Element(name="mcu_data") @NonNull String sdkVersion = "";
    @Element(name="mex_variant", required=false)
    @Nullable
    private @Element(name="mex_variant", required=false) @Nullable String mexVariant;
    @Element(name="example", required=false)
    @Nullable
    private @Element(name="example", required=false) @Nullable String example;
    @Element(name="cores", required=false)
    @NonNull
    @Element(name="cores", required=false) @NonNull Cores cores = new Cores();
    @Element(required=false)
    @Nullable
    protected @Element(required=false) @Nullable String description = "";
    @Transient
    @NonNull
    private String name = "";
    @Nullable
    private String sessionUUID;

    public int getSessionIndex() {
        return this.sessionIndex;
    }

    public String getMcu() {
        return this.mcu;
    }

    @Override
    public String getPackage() {
        return UtilsText.safeString((String)this.mcuPackage);
    }

    public String getBoard() {
        return this.board;
    }

    public String getSdkVersion() {
        return this.sdkVersion;
    }

    public @NonNull String getName() {
        return UtilsText.safeString((String)this.name);
    }

    public void setSessionIndex(int index) {
        this.sessionIndex = index;
    }

    public void setMcu(String mcu) {
        this.mcu = mcu;
    }

    public void setPackage(String mcuPackage) {
        this.mcuPackage = mcuPackage;
    }

    public void setBoard(String board) {
        this.board = board;
    }

    public void setSdkVersion(String sdkversion) {
        this.sdkVersion = UtilsText.safeString((String)sdkversion);
    }

    @Override
    public void setName(String name) {
        this.name = UtilsText.safeString((String)name);
    }

    @Override
    public Collection<ProcessorCore> getCores() {
        return this.cores.cores;
    }

    @Override
    public void setCores(@NonNull Collection<@NonNull ProcessorCore> cores) {
        this.cores.cores = new ArrayList<ProcessorCore>(cores);
        this.updateSelectedCore();
    }

    @NonNull String getSelectedCoreId() {
        return this.cores.selected;
    }

    @Override
    public @Nullable ProcessorCore getSelectedCore() {
        String selCoreId = this.getSelectedCoreId();
        if (!selCoreId.isEmpty()) {
            for (ProcessorCore core : this.cores.cores) {
                if (!core.getID().equals(selCoreId)) continue;
                return core;
            }
        }
        return null;
    }

    private void updateSelectedCore() {
        if (this.cores.cores.size() == 1) {
            this.setSelectedCore(this.cores.cores.get(0));
        } else if (!this.cores.selected.isEmpty() && !this.cores.cores.isEmpty()) {
            boolean foundSelCore = false;
            for (ProcessorCore core : this.cores.cores) {
                if (!core.getID().equals(this.cores.selected)) continue;
                foundSelCore = true;
                break;
            }
            if (!foundSelCore) {
                this.setSelectedCore(null);
            }
        }
    }

    @Override
    public void setSelectedCore(@Nullable ProcessorCore core) {
        if (core != null) {
            this.cores.selected = core.getID();
            assert (CollectionsUtils.findAny(this.cores.cores, c -> c.getID().equals(this.cores.selected)) != null);
        } else {
            this.cores.selected = "";
        }
    }

    @Override
    public @Nullable Collection<Shield> getShields() {
        return this.shields;
    }

    @Override
    public void setShields(@Nullable Collection<Shield> shields) {
        this.shields = shields != null ? new ArrayList<Shield>(shields) : null;
    }

    public String getSessionUUID() {
        return this.sessionUUID;
    }

    @Commit
    public void commit() {
        this.description = UtilsText.safeString((String)this.description);
        this.updateSelectedCore();
    }

    public String getKit() {
        return this.kit;
    }

    public void setKit(@Nullable String kit) {
        this.kit = kit;
    }

    public String getBoardRevision() {
        return this.boardRevision;
    }

    public String getDescription() {
        return this.description;
    }

    @Override
    public void setDescription(String description) {
        this.description = description;
    }

    public void setBoardRevision(String boardRevision) {
        this.boardRevision = boardRevision;
    }

    public String getExample() {
        return this.example;
    }

    public void setExample(String example) {
        this.example = example;
    }

    @Override
    public @NonNull IMcuIdentification getMcuIdentification() {
        return McuSelectionFactory.createMcuSelectionIdentification((String)this.mcu, (String)UtilsText.safeString((String)this.mcuPackage), (String)this.sdkVersion, (String)("".equals(this.board) ? null : this.board), (String)this.kit, (String)this.mexVariant);
    }

    public String toString() {
        return "CommonConfigImpl [mcu=" + this.mcu + ", mcuPackage=" + this.mcuPackage + ", board=" + this.board + ", kit=" + this.kit + ", sdkVersion=" + this.sdkVersion + ", mexVariant=" + this.mexVariant + ", name=" + this.name + "]";
    }

    @Override
    public @Nullable String getKitOrBoard() {
        return UtilsText.getFirstNonEmptyString((String[])new String[]{this.kit, this.board});
    }

    @Override
    public @Nullable ProcessorCore findCore(@NonNull String id) {
        return (ProcessorCore)CollectionsUtils.nullableOptionalGet(this.getCores().stream().filter(c -> id.equals(c.getID())).findFirst());
    }

    @Override
    public @Nullable ProcessorCore findCore_CaseInsensitive(@NonNull String id) {
        ProcessorCore result = this.findCore(id);
        if (result != null) {
            return result;
        }
        return (ProcessorCore)CollectionsUtils.findAny(this.getCores(), c -> id.equalsIgnoreCase(c.getID()));
    }

    private static boolean compareTwoValues(@Nullable String v1, @Nullable String v2, @NonNull String errMsg, @NonNull StringBuilder result, @NonNull String v1Prefix, @NonNull String v2Prefix) {
        String UNSELECTED_VALUE = Messages.get().CommonConfigImpl_NotSelected;
        assert (UNSELECTED_VALUE != null);
        if (v1 == null || v1.isEmpty()) {
            v1 = UNSELECTED_VALUE;
        }
        if (v2 == null || v2.isEmpty()) {
            v2 = UNSELECTED_VALUE;
        }
        if (v1.equals(v2)) {
            return true;
        }
        if (result.length() > 0) {
            result.append(" ");
        }
        result.append(String.valueOf(errMsg) + ": " + v1Prefix + " " + "'" + v1 + "'" + " differs from " + v2Prefix + " " + "'" + v2 + "'");
        return false;
    }

    @Override
    public @Nullable String compareWith(@NonNull ICommonConfig config, boolean ignoreMissingBoard, @NonNull String currentToolId, @NonNull String configTooldId) {
        StringBuilder result = new StringBuilder();
        if (CommonConfigImpl.compareTwoValues(this.getMcu(), config.getMcu(), UtilsText.safeString((String)Messages.get().CommonConfigImpl_ProcessorNotMatch), result, currentToolId, configTooldId) && CommonConfigImpl.compareTwoValues(this.getSdkVersion(), config.getSdkVersion(), UtilsText.safeString((String)Messages.get().CommonConfigImpl_SdkNotMatch), result, currentToolId, configTooldId) && CommonConfigImpl.compareTwoValues(this.getPackage(), config.getPackage(), UtilsText.safeString((String)Messages.get().CommonConfigImpl_PartNmbNotMatch), result, currentToolId, configTooldId)) {
            ProcessorCore curCore = this.getSelectedCore();
            String curCoreName = curCore != null ? curCore.getName() : null;
            ProcessorCore cfgCore = config.getSelectedCore();
            String cfgCoreName = cfgCore != null ? cfgCore.getName() : null;
            CommonConfigImpl.compareTwoValues(curCoreName, cfgCoreName, UtilsText.safeString((String)Messages.get().CommonConfigImpl_CoresNotMatch), result, currentToolId, configTooldId);
        }
        if (!ignoreMissingBoard || this.getBoard() != null && config.getBoard() != null) {
            CommonConfigImpl.compareTwoValues(this.getBoard(), config.getBoard(), UtilsText.safeString((String)Messages.get().CommonConfigImpl_BoardNotMatch), result, currentToolId, configTooldId);
        }
        CommonConfigImpl.compareTwoValues(this.getKit(), config.getKit(), UtilsText.safeString((String)Messages.get().CommonConfigImpl_KitNotMatch), result, currentToolId, configTooldId);
        if (result.length() == 0) {
            return null;
        }
        if (result.charAt(result.length() - 1) == "\n".charAt(0)) {
            result.delete(result.length() - 1, result.length());
        }
        if (result.charAt(result.length() - 1) == "\r\n".charAt(0)) {
            result.delete(result.length() - 1, result.length());
        }
        return result.toString();
    }

    @Override
    public void setMexVariant(@Nullable String mexVariant) {
        this.mexVariant = mexVariant;
    }

    public @Nullable String getMexVariant() {
        return this.mexVariant;
    }

    static class Cores {
        @Attribute(name="selected", required=false)
        @NonNull
        @Attribute(name="selected", required=false) @NonNull String selected = "";
        @ElementList(entry="core", inline=true, required=false)
        @NonNull
        @ElementList(entry="core", inline=true, required=false) @NonNull ArrayList<@NonNull ProcessorCore> cores = new ArrayList();

        Cores() {
        }

        public String toString() {
            return "Cores [selected=" + this.selected + ", cores=" + this.cores + "]";
        }
    }
}

