/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.provider.configuration.sources;

import com.nxp.swtools.common.utils.files.UtilsFile;
import com.nxp.swtools.common.utils.text.UtilsText;
import com.nxp.swtools.provider.configuration.sources.IDestinationPathProvider;
import java.nio.file.Path;
import java.nio.file.Paths;

public class SimpleDestinationPathProvider
implements IDestinationPathProvider {
    private final Path targetPath;

    public SimpleDestinationPathProvider(Path targetPath) {
        this.targetPath = targetPath;
    }

    @Override
    public Path getDestinationPath(String relFilePath) {
        Path basePath;
        if ((relFilePath = UtilsFile.toEclipsePath((String)relFilePath)).startsWith(UtilsText.ECLIPSE_PATH_SEPARATOR)) {
            basePath = this.targetPath.getParent();
            if (basePath == null) {
                basePath = Paths.get("", new String[0]);
            }
            relFilePath = relFilePath.substring(1);
        } else {
            basePath = this.targetPath;
            String targetPathStr = String.valueOf(UtilsFile.toEclipsePath((String)this.targetPath.toString())) + '/';
            if (relFilePath.startsWith(targetPathStr)) {
                relFilePath = relFilePath.substring(targetPathStr.length());
            }
        }
        Path result = basePath.resolve(relFilePath);
        assert (result != null);
        return result;
    }

    protected Path getTargetPath() {
        return this.targetPath;
    }
}

