/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.provider.configuration.storage;

import com.nxp.swtools.common.utils.NonNull;
import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.common.utils.lang.CollectionsUtils;
import com.nxp.swtools.provider.configuration.dependencies.DependencyCreator;
import com.nxp.swtools.provider.configuration.dependencies.IDependency;
import com.nxp.swtools.provider.configuration.storage.IDependenciesConfiguration;
import com.nxp.swtools.provider.configuration.storage.IDependenciesProvider;
import com.nxp.swtools.provider.configuration.storage.OptionsConverter;
import com.nxp.swtools.provider.configuration.storage.StorageDependency;
import com.nxp.swtools.provider.configuration.storage.StorageValue;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.simpleframework.xml.Attribute;
import org.simpleframework.xml.Element;
import org.simpleframework.xml.ElementList;
import org.simpleframework.xml.Root;
import org.simpleframework.xml.convert.Convert;

@Root(strict=false)
public abstract class StorageToolBaseConfiguration
implements IDependenciesConfiguration,
IDependenciesProvider {
    static final long serialVersionUID = 1L;
    @NonNull
    @Element(required=false)
    protected @NonNull @Element(required=false) String description = "";
    @NonNull
    @Element(name="options")
    @Convert(value=OptionsConverter.class)
    protected @NonNull @Element(name="options") @Convert(value=OptionsConverter.class) ArrayList<@NonNull StorageValue> options = new ArrayList();
    @NonNull
    @Attribute(name="name")
    protected @NonNull @Attribute(name="name") String name;
    @Nullable
    @ElementList(name="dependencies", entry="dependency", required=false, empty=true, type=StorageDependency.class)
    private @Nullable @ElementList(name="dependencies", entry="dependency", required=false, empty=true, type=StorageDependency.class) ArrayList<@NonNull IDependency> dependencies;

    public StorageToolBaseConfiguration() {
        this.name = "";
    }

    public StorageToolBaseConfiguration(@NonNull String name) {
        this.name = name;
    }

    public @NonNull String getName() {
        return this.name;
    }

    public void setName(@NonNull String name) {
        this.name = name;
    }

    public @NonNull String getDescription() {
        return this.description;
    }

    public void setDescription(@NonNull String description) {
        this.description = description;
    }

    public List<StorageValue> getOptions() {
        return this.options;
    }

    public void setOptions(@NonNull ArrayList<@NonNull StorageValue> options) {
        this.options = options;
    }

    @Override
    public synchronized @NonNull Collection<@NonNull IDependency> getDependencies() {
        ArrayList<@NonNull IDependency> dependenciesLoc = this.dependencies;
        if (dependenciesLoc == null) {
            this.dependencies = dependenciesLoc = new ArrayList();
        }
        return CollectionsUtils.unmodifiableList(dependenciesLoc);
    }

    public synchronized void setDependencies(@NonNull Collection<@NonNull IDependency> dependencies) {
        ArrayList<@NonNull IDependency> deps = new ArrayList<IDependency>(dependencies);
        deps.sort((d1, d2) -> d1.getDependencyCreator().compareTo(d2.getDependencyCreator()));
        this.dependencies = deps;
    }

    public String toString() {
        String str = String.valueOf(this.name) + (this.description.isEmpty() ? "" : ", " + this.description);
        return str;
    }

    @Override
    public @NonNull String getConfigurationName() {
        return this.getName();
    }

    @Override
    public @NonNull Collection<@NonNull IDependency> getConfigurationDependencies() {
        return this.getDependencies();
    }

    @Override
    public synchronized void setCreatorDependencies(@NonNull DependencyCreator creator, @NonNull Collection<@NonNull IDependency> scriptDependencies) {
        ArrayList<@NonNull IDependency> newDependencies = new ArrayList<IDependency>(scriptDependencies);
        if (this.dependencies != null) {
            this.dependencies.stream().filter(dep -> !creator.equals((Object)dep.getDependencyCreator())).forEach(dep -> {
                boolean bl = newDependencies.add((IDependency)dep);
            });
        }
        newDependencies.sort((d1, d2) -> d1.getDependencyCreator().compareTo(d2.getDependencyCreator()));
        this.dependencies = newDependencies;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        StorageToolBaseConfiguration cfg = (StorageToolBaseConfiguration)obj;
        if (!this.name.equals(cfg.name) || !this.description.equals(cfg.description)) {
            return false;
        }
        return new HashSet<StorageValue>(this.options).equals(new HashSet<StorageValue>(cfg.options));
    }

    public int hashCode() {
        return this.name.hashCode() * 31 + this.description.hashCode();
    }

    @Override
    public boolean isCalledFromInit() {
        return this.options.contains(new StorageValue("callFromInitBoot", "true"));
    }

    @Override
    public @NonNull Collection<@NonNull String> getAlternativeNames() {
        return Collections.emptyList();
    }
}

