/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.provider.configuration.storage.bootimage;

import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.provider.configuration.storage.bootimage.StorageBootArraySetting;
import com.nxp.swtools.provider.configuration.storage.bootimage.StorageBootScalarSetting;
import java.util.ArrayList;
import java.util.Objects;
import org.simpleframework.xml.Attribute;
import org.simpleframework.xml.ElementList;
import org.simpleframework.xml.Root;

@Root(name="struct", strict=false)
public class StorageBootStructSetting {
    @Attribute(name="name", required=false)
    private String name;
    @ElementList(name="setting", required=false)
    private ArrayList<StorageBootScalarSetting> scalarSettings = new ArrayList();
    @ElementList(name="arrays", required=false)
    private ArrayList<StorageBootArraySetting> arraySettings = new ArrayList();
    @ElementList(name="child_structs", required=false)
    private ArrayList<StorageBootStructSetting> childStructSettings = new ArrayList();

    public StorageBootStructSetting() {
        this.name = "";
    }

    public StorageBootStructSetting(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public ArrayList<StorageBootScalarSetting> getScalarSettings() {
        return this.scalarSettings;
    }

    public @Nullable StorageBootScalarSetting getScalarSettingByName(String settingName) {
        for (StorageBootScalarSetting setting : this.scalarSettings) {
            if (!setting.getName().equals(settingName)) continue;
            return setting;
        }
        for (StorageBootStructSetting structSetting : this.childStructSettings) {
            if (structSetting.getScalarSettingByName(settingName) == null) continue;
            return structSetting.getScalarSettingByName(settingName);
        }
        return null;
    }

    public ArrayList<StorageBootArraySetting> getArraySettings() {
        return this.arraySettings;
    }

    public @Nullable StorageBootArraySetting getArraySettingByName(String arrayName) {
        for (StorageBootArraySetting arraySetting : this.arraySettings) {
            if (!arraySetting.getName().equals(arrayName)) continue;
            return arraySetting;
        }
        return null;
    }

    public ArrayList<StorageBootStructSetting> getChildStructSettings() {
        return this.childStructSettings;
    }

    public @Nullable StorageBootStructSetting getChildStructSettingByName(String structName) {
        for (StorageBootStructSetting structSetting : this.childStructSettings) {
            if (!structSetting.getName().equals(structName)) continue;
            return structSetting;
        }
        return null;
    }

    public boolean equals(@Nullable Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        StorageBootStructSetting other = (StorageBootStructSetting)obj;
        return Objects.equals(this.name, other.name) && Objects.equals(this.scalarSettings, other.scalarSettings) && Objects.equals(this.arraySettings, other.arraySettings);
    }

    public int hashCode() {
        int result = super.hashCode();
        result = result * 31 + this.name.hashCode();
        result = result * 31 + Objects.hashCode(this.scalarSettings);
        result = result * 31 + Objects.hashCode(this.arraySettings);
        return result;
    }
}

